<%-- ================   SQL Replay Upgrade page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     12/10/08 - XbranchMerge ezeng_bug-7572808 from
                           st_emdbgc_10.2.0.1.0
      ezeng     06/04/08 - new upgrade page
      yfeng     04/10/07 - XbranchMerge yfeng_bug-5945053 from st_emdbsa_11.1
      yfeng     03/14/07 - XbranchMerge yfeng_bug-5906169 from st_emdbsa_11.1
      ezeng     09/10/07 - 
      yfeng     04/06/07 - Add validation error message for task name
      yfeng     03/07/07 - Fix ADA issues
      nachen    02/23/07 - 
      yfeng     01/23/07 - Created
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>
  
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@upgradeBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destController@servletRequest"
        method="post"
        copyParams="target,type,higher">
        <uix:formValue name="pageName" 
                       value="/database/instance/spia/upgrade"/>

        <uix:pageLayout titleBinding="title@upgradeBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"
                shortDescBinding="CANCEL@DBMsg"
                destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton formName="form" 
                textBinding="SUBMIT@SQLMsg"
                shortDescBinding="SUBMIT@SQLMsg"
                name="event" value="submit"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

          <uix:tableLayout width="100%">

            <uix:rowLayout hAlign="right">
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="form" 
                  textBinding="SUBMIT@SQLMsg"
                  shortDescBinding="SUBMIT@SQLMsg"
                  name="event" value="submit"/>
              </uix:pageButtonBar>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>

              <uix:borderLayout>
                <uix:right>
                  <uix:contentContainer textBinding="descriptionTitle@upgradeBean@servletRequest" 
                                        width="450">

                    <uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="descriptionParagraph@upgradeBean@servletRequest"/>

                        <uix:bulletedList>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="descriptionList1@upgradeBean@servletRequest"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="descriptionList2@upgradeBean@servletRequest"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="descriptionList3@upgradeBean@servletRequest"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="UPGRADE_DESCRIPTION_LIST_3@SPIAMsg"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="UPGRADE_DESCRIPTION_LIST_5@SPIAMsg"/>
                        </uix:bulletedList>
                        <uix:spacer height="0"/>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="UPGRADE_DESCRIPTION_NOTE@SPIAMsg"/>
                    </uix:stackLayout>

                  </uix:contentContainer>
                </uix:right>
                
                
                <uix:stackLayout>
                <uix:header textBinding="TASK_INFORMATION@SPIAMsg">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="taskName"
                                           promptBinding="ANALYSIS_NAME@SPIAMsg"
                                           required="yes"  />
                    </uix:cellFormat>
                    <uix:textInput name="taskName" id="taskName"
                         columns="40"
                         textBinding="taskName@upgradeBean@servletRequest"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="taskName@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
       
                    <%-- SQL Tuning Set  --%>
                    <uix:rowLayout>
                    <uix:cellFormat hAlign="right"> 
                    <uix:messagePrompt labeledNodeId="fullStsName"
                            styleClass="OraPromptText" 
                            promptBinding ="SQL_TUNING_SET@SQLMsg"
                            required="yes"/>
                    </uix:cellFormat>

                    <uix:messageLovField 
                                         name="fullStsName" 
                                         searchDescBinding="SQL_TUNING_SET@SQLMsg"
                                         id="fullStsName" 
                                         columns="40"
                                         textBinding="fullStsName@upgradeBean@servletRequest" 
                                         onClick="startLov('fullStsName', 'ListSTS');return false;"/>

                    </uix:rowLayout>   
                <uix:rowLayout>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                  </uix:cellFormat >
                  <uix:cellFormat hAlign="left">
                    <uix:messageText messageType="error" messageBinding="fullStsName@errors@servletRequest" />
                  </uix:cellFormat >
                </uix:rowLayout> 
            
                         <uix:rowLayout>  
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="taskDescription" 
                               promptBinding="DESCRIPTION@DBMsg" />
                    </uix:cellFormat>
                    <uix:textInput name="taskDescription" id="taskDescription"
                            columns="40"
                            textBinding="taskDescription@upgradeBean@servletRequest"  />
                    </uix:rowLayout> 
                    
                  </uix:tableLayout>
                </uix:header>
               
                <%-- Pre-upgrade Trial --%>
                <uix:header textBinding="PRE_TRIAL@SPIAMsg">
      <uix:switcher childNameBinding="higher@upgradeBean@servletRequest">
        <uix:case name="false">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt promptBinding="METHOD@SPIAMsg" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText styleClass="OraDataText"
                                textBinding="FROM_STS@SPIAMsg"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:case>
        <uix:case name="true">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt labeledNodeId="creationMethodSelectedPre"
                                   promptBinding="METHOD@SPIAMsg" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:choice id="creationMethodSelectedPre"
                            name="creationMethodSelectedPre"
                            selectedValueBinding="creationMethodSelectedPre@upgradeBean@servletRequest"
                            shortDescBinding="METHOD@SPIAMsg"
                            onChange="submitForm('form', false, {'event':'changeCreationMethodSelection'})">
                  <uix:contents childDataBinding="creationMethodList@upgradeBean@servletRequest">
                    <uix:option textBinding="stext"
                                valueBinding="sval"/>
                  </uix:contents>
                </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
            <%-- Per-SQL time limit --%>
            <uix:rowLayout renderedBinding="showTimeLimitPre@upgradeBean@servletRequest">
              <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="perSqlTimeLimitSelectedPre" 
                               promptBinding="PER_SQL_TIME_LIMIT@SPIAMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:choice id="perSqlTimeLimitSelectedPre" 
                                name="perSqlTimeLimitSelectedPre"
                                selectedValueBinding="perSqlTimeLimitSelectedPre@upgradeBean@servletRequest"                                
                                shortDescBinding="PER_SQL_TIME_LIMIT@SPIAMsg"
                                onChange="submitForm('form', false, {'event':'changeSqlTimeLimitSelection'})">
                      <uix:contents childDataBinding="perSqlTimeLimitList@upgradeBean@servletRequest">
                        <uix:option textBinding="stext"
                                    valueBinding="sval"/>
                      </uix:contents>
                    </uix:choice>
                    <uix:switcher childNameBinding="perSqlTimeLimitSelectedPre@upgradeBean@servletRequest">
                      <uix:case name="CUSTOMIZE">
                        <uix:flowLayout>
                        <uix:textInput name="timeLimitPerSQLPre" 
                                       columns="10"
                                       id="timeLimitPerSQLPre"
                                       textBinding="timeLimitPerSQLPre@upgradeBean@servletRequest"/>
                        <uix:choice id="timeLimitPerSQLUnitPre"
                                    name="timeLimitPerSQLUnitPre"
                                    selectedValueBinding="timeLimitPerSQLUnitPre@upgradeBean@servletRequest"
                                    shortDescBinding="timeLimitPerSQLUnitPre@upgradeBean@servletRequest">
                          <uix:contents childDataBinding="timeLimitPerSQLUnitList@upgradeBean@servletRequest">
                            <uix:option textBinding="stext"
                                        valueBinding="sval"/>
                          </uix:contents>
                        </uix:choice>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    </uix:rowLayout>             
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showTimeLimitPre@upgradeBean@servletRequest">
                    <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText" 
                                       textBinding="PER_SQL_TIME_LIMIT_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat width="120" hAlign="right">
                    <uix:messagePrompt labeledNodeId="dbLinkPre"
                            styleClass="OraPromptText"
                            promptBinding ="DB_LINK@SPIAMsg"
                            required="yes"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:messageLovField name="dbLinkPre"
                                         searchDescBinding="DB_LINK@SPIAMsg"
                                         id="dbLinkPre"
                                         columns="28"
                                         textBinding="dbLinkPre@upgradeBean@servletRequest"
                                         onClick="preserveCase();startLov('dbLinkPre', 'ListDBLinks');return false;"/>
                    <uix:spacer width="3"/> 
                    <uix:submitButton shortDescBinding="DB_LINK_CREATE@SPIAMsg"
                                      textBinding="DB_LINK_CREATE@SPIAMsg"
                                      name="event"
                                      value="createDBLink"/>
                    </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText"
                                       textBinding="DB_LINK_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
          </uix:tableLayout>
        </uix:case>
      </uix:switcher>
                </uix:header>

                <%-- Post-upgrade Trial --%>
                <uix:header textBinding="POST_TRIAL@SPIAMsg">
      <uix:switcher childNameBinding="higher@upgradeBean@servletRequest">
        <uix:case name="false">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt labeledNodeId="creationMethodSelected"
                                   promptBinding="METHOD@SPIAMsg" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:choice id="creationMethodSelected"
                            name="creationMethodSelected"
                            selectedValueBinding="creationMethodSelected@upgradeBean@servletRequest"
                            shortDescBinding="METHOD@SPIAMsg"
                            onChange="submitForm('form', false, {'event':'changeCreationMethodSelection'})">
                  <uix:contents childDataBinding="creationMethodList@upgradeBean@servletRequest">
                    <uix:option textBinding="stext"
                                valueBinding="sval"/>
                  </uix:contents>
                </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
            <%-- Per-SQL time limit --%>
            <uix:rowLayout renderedBinding="showTimeLimit@upgradeBean@servletRequest">
              <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="perSqlTimeLimitSelected" 
                               promptBinding="PER_SQL_TIME_LIMIT@SPIAMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:choice id="perSqlTimeLimitSelected" 
                                name="perSqlTimeLimitSelected"
                                selectedValueBinding="perSqlTimeLimitSelected@upgradeBean@servletRequest"                                
                                shortDescBinding="PER_SQL_TIME_LIMIT@SPIAMsg"
                                onChange="submitForm('form', false, {'event':'changeSqlTimeLimitSelection'})">
                      <uix:contents childDataBinding="perSqlTimeLimitList@upgradeBean@servletRequest">
                        <uix:option textBinding="stext"
                                    valueBinding="sval"/>
                      </uix:contents>
                    </uix:choice>
                    <uix:switcher childNameBinding="perSqlTimeLimitSelected@upgradeBean@servletRequest">
                      <uix:case name="CUSTOMIZE">
                        <uix:flowLayout>
                        <uix:textInput name="timeLimitPerSQL" 
                                       columns="10"
                                       id="timeLimitPerSQL"
                                       textBinding="timeLimitPerSQL@upgradeBean@servletRequest"/>
                        <uix:choice id="timeLimitPerSQLUnit"
                                    name="timeLimitPerSQLUnit"
                                    selectedValueBinding="timeLimitPerSQLUnit@upgradeBean@servletRequest"
                                    shortDescBinding="timeLimitPerSQLUnit@upgradeBean@servletRequest">
                          <uix:contents childDataBinding="timeLimitPerSQLUnitList@upgradeBean@servletRequest">
                            <uix:option textBinding="stext"
                                        valueBinding="sval"/>
                          </uix:contents>
                        </uix:choice>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    </uix:rowLayout>             
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showTimeLimit@upgradeBean@servletRequest">
                    <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText" 
                                       textBinding="PER_SQL_TIME_LIMIT_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat width="120" hAlign="right">
                    <uix:messagePrompt labeledNodeId="dbLink"
                            styleClass="OraPromptText"
                            promptBinding ="DB_LINK@SPIAMsg"
                            required="yes"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:messageLovField name="dbLink"
                                         searchDescBinding="DB_LINK@SPIAMsg"
                                         id="dbLink"
                                         columns="28"
                                         textBinding="dbLink@upgradeBean@servletRequest"
                                         onClick="preserveCase();startLov('dbLink', 'ListDBLinks');return false;"/>
                    <uix:spacer width="3"/> 
                    <uix:submitButton shortDescBinding="DB_LINK_CREATE@SPIAMsg"
                                      textBinding="DB_LINK_CREATE@SPIAMsg"
                                      name="event"
                                      value="createDBLink"/>
                    </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                      <uix:styledText styleClass="OraTipText"
                                      textBinding="DB_LINK_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
          </uix:tableLayout>
        </uix:case>
        <uix:case name="true">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
                <uix:cellFormat width="120" hAlign="right">
                <uix:checkBox name="sameDb"
                              id="sameDb"
                              checkedBinding="sameDb@upgradeBean@servletRequest"
                              onClick="submitForm('form', false, {'event':'changeSameDb'})"/>
                </uix:cellFormat>
                <uix:styledText labeledNodeId="sameDb"
                                styleClass="OraInstructionText"
                                textBinding="SAME_DB@SPIAMsg"/>
            </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat width="120" hAlign="right">
                    <uix:messagePrompt labeledNodeId="dbLink"
                            styleClass="OraPromptText"
                            promptBinding ="DB_LINK@SPIAMsg"
                            required="yes"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:messageLovField name="dbLink"
                                         searchDescBinding="DB_LINK@SPIAMsg"
                                         id="dbLink"
                                         columns="28"
                                         textBinding="dbLink@upgradeBean@servletRequest"
                                         onClick="preserveCase();startLov('dbLink', 'ListDBLinks');return false;"
                                         disabledBinding="higherAndSameDb@upgradeBean@servletRequest"/>
                    <uix:spacer width="3"/>
                    <uix:submitButton shortDescBinding="DB_LINK_CREATE@SPIAMsg"
                                      textBinding="DB_LINK_CREATE@SPIAMsg"
                                      name="event"
                                      value="createDBLink"
                                      disabledBinding="higherAndSameDb@upgradeBean@servletRequest"/>
                    </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="differentDb@upgradeBean@servletRequest">
                    <uix:cellFormat width="120" wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                      <uix:styledText styleClass="OraTipText"
                                      textBinding="DB_LINK_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>
                  <uix:spacer height="5"/>
                  <uix:rowLayout renderedBinding="higher@upgradeBean@servletRequest">
                    <uix:tip>
                      <uix:styledText styleClass="OraTipText"
                                      textBinding="SAME_CREATION_LIMIT@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                </uix:header>
 
                <%-- Evaluation --%>
                <uix:header textBinding="EVALUATION@SPIAMsg">
                
                <uix:rowLayout>
                  <uix:spacer height="6" />
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                <uix:flowLayout>

                  <uix:messagePrompt promptBinding="COMPARISON_METRIC@SPIAMsg" />
                  <uix:choice id="selectedComparisonMetric" 
                            name="selectedComparisonMetric"
                            selectedValueBinding="selectedComparisonMetric@upgradeBean@servletRequest"                                
                            shortDescBinding="COMPARISON_METRIC@SPIAMsg">
                    <uix:contents childDataBinding="comparisonMetricOptions@upgradeBean@servletRequest">
                      <uix:option textBinding="stext"
                                  valueBinding="sval"/>
                    </uix:contents>
                  </uix:choice>  
                </uix:flowLayout>
              </uix:rowLayout>
                </uix:header>
                
          <%@ include file="schedule.jspf" %>
          
                </uix:stackLayout>
              </uix:borderLayout>

            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
