<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="UPGRADE_HIGHER@SPIAMsg"/>
    </uix:metaContainer>

    <uix:body>

      <db:form name="followupForm"
               destination="/console/database/instance/SPIAUpgrade"
               copyParams="target,type,SPIATaskName,SPIATaskOwner">
        <uix:pageLayout>
          <%@ include file="/database/globalPopup.jspf" %>
          <%@ include file="infoAndError.jspf" %>

          <uix:spacer height="20"/>
          <uix:header iconBinding="confirmationIcon@servletRequest"
                      textBinding="CONFIRMATION@DBMsg">

            <uix:stackLayout>
              <uix:rowLayout>
                <uix:styledText styleClass="OraDataText"
                                textBinding="followupMsg@servletRequest"/>
              </uix:rowLayout>
              <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:checkBox name="upgradeDone"
                              id="upgradeDone"
                              checkedBinding="upgradeDone@upgradeBean@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:styledText labeledNodeId="upgradeDone"
                                styleClass="OraInstructionText"
                                textBinding="UPGRADE_DONE@SPIAMsg"/>
              </uix:rowLayout>
            </uix:stackLayout>
          </uix:header>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="SUBMIT@SQLMsg"
                          name="event" value="submit2"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

