<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="DBObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
  
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>


        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText"
                          mainTextKey="mainText"/>

        <db:form name="foo" destination="/console/database/instance/response"
                    copyParams="target,type">


          <uix:header textBinding="VIEW_BASELINE@sqlBundle@servletRequest">

	    <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:pageButtonBar>
                  <uix:styledText styleClass="OraTipText"
            		textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
          	  <uix:styledText styleClass="OraTipLabel"
            		textBinding="refreshTime@servletRequest"/>
                  <uix:switcher childNameBinding="viewHistoryEnabled@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:submitButton textBinding="VIEW_HISTORY@sqlBundle@servletRequest"
                        name="event"
                        value="viewHistory" />
                    </uix:case>
                  </uix:switcher>
                  <uix:submitButton textBinding="RESET_BASELINE@sqlBundle@servletRequest"
                       	name="event"
                        value="resetBaseline" />
          	  <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
            		destinationBinding="refreshDest@servletRequest" />
                </uix:pageButtonBar>
              </uix:rowLayout>
	    </uix:tableLayout>

            <uix:tableLayout width="100%" renderedBinding="latestSummaryAvailable@defaultBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat vAlign="top" width="50%">
                  <uix:header textBinding="GENERAL@sqlBundle@servletRequest" size="1">
                    <oem:table name="general" width="100%"
                         dataSourceProp="generalDataSource"/>
                  </uix:header>
		</uix:cellFormat>
                <uix:switcher childNameBinding="DBVersion10gOrHigher@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat vAlign="top">
                      <uix:header textBinding="INST_STAT@sqlBundle@servletRequest" size="1">
                        <oem:table name="general" width="100%"
			 summaryBinding="INST_STAT@sqlBundle@servletRequest"
                         dataSourceProp="statisticsDataSource"/>
                      </uix:header>
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:switcher childNameBinding="viewHistoryEnabled@defaultBean@servletRequest">     
              <uix:case name="true">
	        <uix:header textBinding="COLLECTION_DETAILS@sqlBundle@servletRequest">
                  <oem:table name="baseline" width="100%" 
			 summaryBinding="COLLECTION_DETAILS@sqlBundle@servletRequest"
                         dataSourceProp="baselineDataSource"
                         alternateTextBinding="NO_BASELINE@sqlBundle@servletRequest">
                    <uix:tableSelection>              
                      <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                                         selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                      	<uix:submitButton textBinding="DELETE@DBObjectMsg"
                                        name="event"
                                        value="deleteSQL"/>
                      </uix:singleSelection>
                    </uix:tableSelection>
                  </oem:table>                  
	        </uix:header>
              </uix:case>          
              <uix:case name="false">
		<uix:stackLayout>
		  <uix:styledText styleClass="OraPromptText"
                        textBinding="BASELINE_STATEMENTS@sqlBundle@servletRequest"/>
                  <uix:spacer height="5"/>
                  <oem:table name="baseline" width="100%" 
			 summaryBinding="VIEW_BASELINE@sqlBundle@servletRequest"
                         dataSourceProp="baselineDataSource"
                         alternateTextBinding="NO_BASELINE@sqlBundle@servletRequest">
                  </oem:table>                  
		</uix:stackLayout>
              </uix:case>                          
            </uix:switcher>

	  </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

