<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" 
               destinationBinding="destURI@servletRequest"
               copyParams="target,type, pageNum,sqlHash,sqlAddr,sql_id,breadCrumb">

      <uix:pageLayout  titleBinding="hdr@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
          <uix:cellFormat wrappingDisabled="true" hAlign="right">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="CATEGORY@sqlMsg"  />
          </uix:cellFormat>
          <uix:textInput id="categoryInput" 
                         name="category"
                               textBinding="category@servletRequest"  />
        </uix:labeledFieldLayout>


        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@dbMsg"
                              name="event"
                              value="doLoad"/>
            <uix:submitButton textBinding="OK@dbMsg"
                              name="event"
                              value="changeCategory"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

