<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/topSqls"
      copyParams="target,type">

    <uix:formValue name="refreshChoice" valueBinding="refreshChoice@servletRequest" />
    <uix:formValue name="pageName" value="/database/instance/sql/createSTS" />

    <uix:pageLayout titleBinding="CREATE_STS@DBMsgBundle@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:stackLayout>
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="nameInput" promptBinding="NAME@DBMsgBundle@servletRequest"
             required="yes"  />
        </uix:cellFormat>
           <uix:textInput id="nameInput" name="stsName"
            textBinding="stsName@topSqlsBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="descInput" promptBinding="DESCRIPTION@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
           <uix:textInput id="descInput" name="stsDescription"
            textBinding="stsDescription@topSqlsBean@servletRequest"  />
     </uix:labeledFieldLayout>

      <uix:spacer height="30" />

      <oem:table name="twoDUIDataSource"
                 summaryBinding="CREATE_STS@DBMsgBundle@servletRequest"
                 id="theSTSCreateTable"
                 beanKey="stsBean"
                 formSubmitted="true"
                 dataSourceProp="twoDUIDataSource"
                 width="100%"
                 blockSize="25" />

     </uix:stackLayout>


        <uix:pageButtons>
        <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest"
              name="event"
              value="cancelSTS" />
            <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest"
              name="event"
              value="doCreateSTS"/>
        </uix:pageButtonBar>
        </uix:pageButtons>



    </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

