<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %> 
    
        <uix:form name="foo" method="get" destinationBinding="destURI@servletRequest">

          <uix:formValue name="target"
                        valueBinding="targetName@defaultBean@servletRequest"/>
	  <uix:formValue name="type"
                        valueBinding="targetType@defaultBean@servletRequest"/>

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                        msgBundleBinding="ResourceBundle"
                        titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
         		errorTableBinding="errors@servletRequest"
         		titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:header textBinding="DUP_SQL_STMTS@ResourceBundle@servletRequest" >
                <%@ include file="/database/instances.jspf" %>
	    <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:rowLayout>
                    <%@ include file="../refreshTime.jspf" %>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
	      <uix:rowLayout hAlign="left">
		 <uix:styledText styleClass="OraPromptText"
                                textBinding="DUP_SQL_TEXT@ResourceBundle@servletRequest"/>
	      </uix:rowLayout>
	    </uix:tableLayout>
	    <uix:header textBinding="CPU_CONSUMPTION_HEADER@ResourceBundle@servletRequest">
	      <uix:tableLayout>
	        <uix:rowLayout>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:styledText textBinding="CPU_USAGE_PER@ResourceBundle@servletRequest"
                                styleClass="OraPromptText"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer width="5"/>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:styledText textBinding="CPURatio@defaultBean@servletRequest"
                                styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                    <uix:styledText textBinding="PARSE_TO_CPU_PER@ResourceBundle@servletRequest"
                                styleClass="OraPromptText"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer width="5"/>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:styledText textBinding="parseRatio@defaultBean@servletRequest"
                                styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
   	      </uix:tableLayout>
	    </uix:header>
            <uix:header textBinding="DUP_SQL_DUP_SQL_STMTS@ResourceBundle@servletRequest" >
              <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="left">
                  <uix:styledText styleClass="OraPromptText"
                  		textBinding="LIB_CACHE_CONTENTION_DESC2@ResourceBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:styledText styleClass="OraTipText"
                        textBinding="MAX_ROWS_LIMIT@ResourceBundle@servletRequest"/>

              <uix:hGrid id="duplicateSql"
		       summaryBinding="DUP_SQL_DUP_SQL_STMTS@ResourceBundle@servletRequest"
                       width="100%"
                       alternateTextBinding="DUP_SQL_NO_DATA@ResourceBundle@servletRequest"
                       destinationBinding="destURI@servletRequest"
                       columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest"
                       columnFormatsBinding="columnFormatData@defaultBean@servletRequest"
                       treeDataBinding="treeData@defaultBean@servletRequest"
                       proxyBinding="proxy@servletRequest">
                  
                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="DUP_SQL_DUPLICATE@ResourceBundle@servletRequest"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="duplicates"
                                  styleClass="OraFieldText" />
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:text textBinding="text"/>
                </uix:columnHeaderStamp>
              	<uix:styledText textBinding="planHashValue" 
				destinationBinding="sqlDetailURL"/>
                <uix:styledText textBinding="sqlText"
                              destinationBinding="sqlDetailURL"/>
              </uix:hGrid>
            </uix:header>
	  </uix:header>

         <uix:spacer height="15" />

         <%@ include file="/database/instance/monitoringLinks.jspf" %>

        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
