<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"
	      class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
  
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>

        <db:form name="foo" destination="/console/database/instance/response" copyParams="target,type">

          <uix:header textBinding="EDIT_BASELINE_HDR@sqlBundle@servletRequest">

	    <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="RESET_BASELINE@sqlBundle@servletRequest"
                       	            name="event" value="resetBaselineFromEditBaseline"/>
                </uix:pageButtonBar>
              </uix:rowLayout>
	    </uix:tableLayout>

            <oem:table name="editBaseline" width="100%" 
		       summaryBinding="EDIT_BASELINE_HDR@sqlBundle@servletRequest"
                       dataSourceProp="editBaselineDataSource"
                       alternateTextBinding="NO_BASELINE@sqlBundle@servletRequest">
              <uix:tableSelection>              
                <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                                     selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                  <uix:submitButton textBinding="DELETE@DBObjectMsg"
                                    name="event"
                                    value="deleteSQLFromEditBaseline"/>
                </uix:singleSelection>
              </uix:tableSelection>
            </oem:table>                  

	  </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

