<%-- ================  Statistics tab of SQL Details Page =================== 

   MODIFIED    (MM/DD/YY)
      manaraya  06/10/08 - Backport manaraya_bug-6718429 from main
      ychan     09/24/07 - Add sql monitor
      manaraya  04/17/07 - XbranchMerge manaraya_bug-5934867 from
                           st_emdbsa_11.1
      manaraya  04/15/07 - XbranchMerge manaraya_bug-5852154 from
      manaraya  02/28/07 - 
      nachen    01/14/07 - XbranchMerge nachen_bug-5758143 from st_emdbsa_11.1
      nachen    01/09/07 - hide tuning info tab for sql worksheet
      yfeng     10/10/06 - align Information name value pair with others
      hxlin     04/07/06 - Use sharable execution plan table 
      yfeng     06/15/06 - Temporary disable checkbox for PQ because of uix 
                           bug 
      yfeng     06/06/06 - Add Information name value pair 
      yfeng     03/16/06 - Dispaly Information name value pair for Plan tab if 
                           exists 
      yfeng     03/15/06 - Add rendered attributes for those new columns added 
      yfeng     03/15/06 - Add more columns into xplan table 
      yfeng     03/13/06 - Add checkBox to show PQ 
      yfeng     03/09/06 - xplan enhancement and removed the switcher to
                           control the columns to be shown
      nachen    06/01/06 - add child number 
      nachen    04/27/06 - add results tab 
      yfeng     11/21/05 - Fix bug 4728583 - object node displayed at wrong 
                           col 
      nachen    09/15/05 - fix bug 4614108 
      yfeng     06/24/05 - Fix ADA violation - add summary for oem:table 
      nachen    02/21/05 - move back query rewrite 
      nachen    02/16/05 - fix legend 
      nachen    01/20/05 - fix layout problem 
      yfeng     10/15/04 - Show message when plan is not available
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="executionPlan">
  <uix:dataScope>    
<uix:bundle name="sdkMessageBundle"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<jsp:useBean
    id="sqlDetailUI"
    scope="request"
    type="oracle.sysman.emo.perf.bean.sql.SQLDetailUI"/>
  
<uix:subTabLayout>
  <uix:subTabs>
    <uix:subTabBar selectedIndex="3">
      <uix:link textBinding="RESULTS@sqlMsg"
                destinationBinding="resultsDest@servletRequest"
                renderedBinding="renderResultsTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_STATS@sqlMsg"
                destinationBinding="exeDest@servletRequest"/>
      <uix:link textBinding="SESS_ACTIVITY@sqlMsg"
                destinationBinding="actDest@servletRequest"
                renderedBinding="renderSessActTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_PLAN@sqlMsg"/>
      <uix:link renderedBinding="isVer11Higher@sqlDetailUI@servletRequest">
      <uix:flowLayout>
      	<uix:styledText styleClass="OraPromptText" textBinding="DETAIL_PLAN_CONTROL@sqlMsg" destinationBinding="plnControlDest@servletRequest" renderedBinding="renderTuningInfoTab@sqlDetailUI@servletRequest"/>
        <uix:image source="/em/images/infoicon_active.gif" id="processIcon" shortDescBinding="DETAIL_PLAN_CONTROL@sqlMsg"
        	renderedBinding="renderIcon@sqlDetailUI@servletRequest" destinationBinding="plnControlDest@servletRequest"/>
      </uix:flowLayout>
      </uix:link>
      <uix:link textBinding="tuningText@servletRequest" 
                destinationBinding="tunDest@servletRequest"
                renderedBinding="renderTuningInfoTab@sqlDetailUI@servletRequest"/>
    <uix:switcher childNameBinding="disableMonitor@sqlDetailUI@servletRequest">
        <uix:case name="true">
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                shortDescBinding="NO_MONITOR_INFO@sqlMsg"
                disabled="true"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:case>
        <uix:default>
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:default>
     </uix:switcher>
     </uix:subTabBar>
  </uix:subTabs>

<uix:switcher childNameBinding="isHT8@sqlDetailUI@servletRequest">
  <uix:case name="true">   
      <uix:styledText styleClass="OraInstructionText"
                      textBinding="PLAN_NOT_AVAIL@sqlMsg" />
  </uix:case>
  <uix:default>
  <uix:switcher childNameBinding="hasPlan@servletRequest">
    <uix:case name="true">
  <uix:stackLayout>
  <uix:tableLayout width="100%" cellSpacing="5">
  <uix:rowLayout>
  <uix:cellFormat wrappingDisabled="true"  hAlign="right">
    <uix:styledText styleClass="OraPromptText" 
                    textBinding="SQL_DATA_SOURCE@dbMsg"/>           
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="false"  hAlign="left">                    
    <uix:switcher childNameBinding="planDataSourceURLForSnapshotExisted@executionPlanUI@servletRequest">
      <uix:case name="true">
        <uix:link textBinding="planDataSource@executionPlanUI@servletRequest"
                  destinationBinding="planDataSourceURLForSnapshot@executionPlanUI@servletRequest"/>
      </uix:case>
      <uix:case name="false">
        <uix:styledText styleClass="OraDataText" 
                        textBinding="planDataSource@executionPlanUI@servletRequest"/>
      </uix:case>
    </uix:switcher>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="true"  hAlign="right">
    <uix:styledText styleClass="OraPromptText"
                    textBinding="CAPTURE_TIME@dbMsg"/>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="false"  hAlign="left">    
    <uix:styledText styleClass="OraDataText"
                    textBinding="planCaptureTime@executionPlanUI@servletRequest"/>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="true"  hAlign="right">                    
    <uix:styledText styleClass="OraPromptText" textBinding="PARSE_SCHEMA@dbMsg"/>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="false"  hAlign="left"> 
    <uix:styledText styleClass="OraDataText" 
                    textBinding="parsingSchema@executionPlanUI@servletRequest"/>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="true"  hAlign="right">
    <uix:styledText styleClass="OraPromptText" textBinding="SQL_OPT_MODE@dbMsg"/>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="false"  hAlign="left"> 
    <uix:styledText styleClass="OraDataText" 
                    textBinding="optimizerMode@executionPlanUI@servletRequest"/>
  </uix:cellFormat>
  </uix:rowLayout>

  <uix:rowLayout>
  <uix:cellFormat wrappingDisabled="true"  hAlign="right">
    <uix:styledText styleClass="OraPromptText" textBinding="ADDITIONAL_INFORMATION@sqlMsg"/>
  </uix:cellFormat>
  <uix:cellFormat wrappingDisabled="false"  hAlign="left" columnSpan="7" renderedBinding="hasGeneralInformation@executionPlanUI@servletRequest"> 
    <uix:styledText styleClass="OraDataText" 
                    textBinding="generalInformation@executionPlanUI@servletRequest"/>
  </uix:cellFormat>
  </uix:rowLayout>

  </uix:tableLayout>  

  <uix:switcher childNameBinding="usingSVG@servletRequest">
  <uix:case name="true">
  <uix:tableLayout>
  <uix:rowLayout>
    <uix:styledText styleClass="OraPromptText" textBinding="VIEW_DETAIL@dbMsg"/>
      <uix:flowLayout>
        <uix:contents childDataBinding="displayTypesList@executionPlanUI@servletRequest">
          <uix:radioButton name="displayType" 
                           textBinding="text"
                           valueBinding="val" 
                           onClickBinding="onclick"
                           selectedBinding="selected"/>
        </uix:contents>
      </uix:flowLayout>
  </uix:rowLayout>
  </uix:tableLayout>
  </uix:case>
  </uix:switcher>

<%--
  <uix:switcher childNameBinding="tabularDisplay@executionPlanUI@servletRequest">
    <uix:case name="true">
      <uix:rowLayout>
          <uix:checkBox name="showPQ" 
                        textBinding="SHOW_PQ_INFO@sqlMsg"
                        checkedBinding="enableShowPQ@executionPlanUI@servletRequest" 
                        disabledBinding="disableShowPQ@executionPlanUI@servletRequest" 
                        onClick="submitForm('sqlForm', true, {event:'showPQ'})" />

      </uix:rowLayout>
    </uix:case>
  </uix:switcher>
--%>
    <uix:switcher childNameBinding="displayType@executionPlanUI@servletRequest">
    <uix:case name="graphical">
      <%
        if (sqlDetailUI.getIsVer10Higher())
        {
      %>
          <uix:tableLayout width="100%">
          <uix:rowLayout>
          <oem:topology topoPageType="sqlPlanTopoPageType"
		    keyParameters="target, type, sql_id, planHashValue"
                    width="100%"
                    height="100%"/> 
          </uix:rowLayout>
          <uix:rowLayout> 
            <uix:tip>
            <uix:styledText textBinding="LEGEND_TEXT@sdkMessageBundle"/>
            <uix:link textBinding="ICON_LEGEND_HEADER@sqlMsg" destinationBinding="iconLegendUrl@servletRequest"/>  
            </uix:tip>
          </uix:rowLayout>
        </uix:tableLayout>
      <%
        }
        else
        {
      %>
          <uix:tableLayout width="100%">
          <uix:rowLayout>
           <oem:topology topoPageType="sqlPlanTopoPageType"
		    keyParameters="target, type, sqlHash"
                    width="100%"
                    height="100%"/> 
          </uix:rowLayout>
          <uix:rowLayout> 
            <uix:tip>          
            <uix:styledText textBinding="LEGEND_TEXT@sdkMessageBundle"/>
            <uix:link textBinding="ICON_LEGEND_HEADER@sqlMsg" destinationBinding="iconLegendUrl@servletRequest"/>  
            </uix:tip>
          </uix:rowLayout>
        </uix:tableLayout>
      <%
        }
      %>
    </uix:case>
    <uix:case name="tabular">
      <%@ include file="/database/instance/executionPlanTable.jspf" %>
    </uix:case> <%-- case tabular --%>
  </uix:switcher> 
    
  <uix:spacer height="5"/>
  <uix:switcher childNameBinding="showExplainRewrite@sqlDetailUI@servletRequest">        
    <uix:case name="true"> 
      <uix:hideShow id="hideShowExplainRewrite"
                    undisclosedTextBinding="SHOW_EXPLAIN_REWRITE@sqlMsg"
                    disclosedTextBinding="HIDE_EXPLAIN_REWRITE@sqlMsg"
                    disclosedBinding="discloseExplainRewrite@sqlDetailUI@servletRequest"
                    formSubmitted="true" >
        <uix:header textBinding="EXPLAIN_REWRITE@mvMsgs">
          <uix:styledText textBinding="EXPLAIN_REWRITE_TEXT1@mvMsgs" styleClass="OraInstructionText" />
          <uix:tableLayout width="100%" cellSpacing="5"  renderedBinding="isVer10_2Higher@sqlDetailUI@servletRequest">
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer height="10"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="top">
                <uix:messageStyledText promptBinding="QUERY_REWRITABLE@mvMsgs" 
                    shortDescBinding="QUERY_REWRITABLE@mvMsgs"
                    textBinding="explainRewriteable@sqlDetailUI@servletRequest" 
                    contentStyleClass="OraDataText" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="10"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="top">
                <uix:messageStyledText promptBinding="MV_QUERY_REWRITTEN@mvMsgs" vAlign="top"
                    shortDescBinding="MV_QUERY_REWRITTEN@mvMsgs"
                    textBinding="explainRewriteMaterializedView@sqlDetailUI@servletRequest" 
                    contentStyleClass="OraDataText" />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
      <uix:tableLayout width="100%">
        <uix:spacer height="10" renderedBinding="isShowExplainRewrittenColumn@sqlDetailUI@servletRequest"/>
        <uix:rowLayout>
          <uix:styledText textBinding="EXPLAIN_REWRITE_TEXT2@mvMsgs" styleClass="OraInstructionText" />
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:table name="ExplainRewrite"
                 summaryBinding="EXEC_PLAN@sqlMsg"
                 width="100%"
                 formSubmitted="true"
                 tableDataBinding="tableData@sqlDetailUI@servletRequest"
                 maxValueBinding="length@sqlDetailUI@servletRequest"
                 valueBinding="startIndex@sqlDetailUI@servletRequest"
                 blockSizeBinding="blockSize@sqlDetailUI@servletRequest"
                 alternateTextBinding="TABLE_NO_DATA@dbMsg">
          <uix:tableFormat tableBanding="rowBanding"/>
         
          <%-- Table column name column --%>
          <uix:column renderedBinding="isShowExplainRewrittenColumn@sqlDetailUI@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="QUERY_REWRITABLE@mvMsgs"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteable@sqlDetailUI@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="MESSAGE@mvMsgs"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteMessage@sqlDetailUI@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="ORIGINAL_COST@mvMsgs"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteOrginalCost@sqlDetailUI@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="REWRITTEN_COST@mvMsgs"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteRewrittenCost@sqlDetailUI@servletRequest"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="numberFormat"/>
          </uix:column>
          <uix:column renderedBinding="isVer10_2Higher@sqlDetailUI@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="QUERY_BLOCK@mvMsgs"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="queryBlockNumber@objectBean@servletRequest"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="numberFormat"/>
          </uix:column>
      </uix:table>

        </uix:header>
     </uix:hideShow>
    </uix:case> 
  </uix:switcher>        
  <uix:spacer height="10"/>
  </uix:stackLayout>
  </uix:case>
  <uix:case name="false">
    <uix:styledText styleClass="OraInstructionText"
                    textBinding="PLAN_NOT_AVAIL@sqlMsg" />
  </uix:case>
  </uix:switcher>

  </uix:default>
 </uix:switcher> 
</uix:subTabLayout>

  </uix:dataScope>     
</uix:buildTree>


