<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="SQLMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText"
                          mainTextKey="mainText"/>

        <db:form name="histForm" destination="/console/database/instance/response"
                    copyParams="target,type">
          <uix:formValue name="event" value=""/>
              
          <uix:header textBinding="VIEW_HISTORY@sqlBundle@servletRequest">  
              
            <uix:styledText styleClass="OraPromptText"
                  textBinding="NO_HISTORY_STATEMENTS@sqlBundle@servletRequest"
                  renderedBinding="historyNotAvailable@defaultBean@servletRequest"/>

            <uix:styledText styleClass="OraPromptText"
                  textBinding="HISTORY_STATEMENTS@sqlBundle@servletRequest"
		  renderedBinding="historyAvailable@defaultBean@servletRequest"/>
                  
            <uix:tableLayout width="100%" renderedBinding="historyAvailable@defaultBean@servletRequest">
              <uix:rowLayout hAlign="right">
		<uix:cellFormat>
                  <uix:styledText styleClass="OraFieldText" textBinding="VIEW_COLLECTION@SQLMsg"/>
                  <oem:choice name="selectedHistCaptureTime" 
                          selectedValueBinding="selectedHistCaptureTime@defaultBean@servletRequest" 
                          onChange="submitForm('histForm', true, {'event':'switchCaptureTime'})" 
                          optionsBinding="histCaptureTimes@defaultBean@servletRequest" />
		</uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout> 
              
            <uix:tableLayout width="100%" renderedBinding="historySummaryAvailable@defaultBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat vAlign="top" width="50%">
                  <uix:header textBinding="GENERAL@sqlBundle@servletRequest" size="1">
                    <oem:table name="historyGeneral" width="100%"
                         dataSourceProp="historyGeneralDataSource"/>
                  </uix:header>
                </uix:cellFormat>
                <uix:switcher childNameBinding="DBVersion10gOrHigher@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat vAlign="top">
                      <uix:header textBinding="INST_STAT@sqlBundle@servletRequest" size="1">
                        <oem:table name="historyStatistics" width="100%"
                         dataSourceProp="historyStatisticsDataSource"/>
                      </uix:header>
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>

              </uix:rowLayout>
            </uix:tableLayout>

	    <uix:header textBinding="COLLECTION_DETAILS@sqlBundle@servletRequest"
			renderedBinding="historySummaryAvailable@defaultBean@servletRequest">
              <oem:table name="history" width="100%" 
			 summaryBinding="COLLECTION_DETAILS@sqlBundle@servletRequest"
                         dataSourceProp="baselineHistoryDataSource"
                         alternateTextBinding="NO_BASELINE@sqlBundle@servletRequest">            
              </oem:table>
	    </uix:header>

	  </uix:header>
        </db:form>
      </uix:pageLayout>          
    </uix:body>
  </uix:document>
</uix:renderingContext>

