<%-- ================  Activity tab of SQL Details page  =================== 

   MODIFIED    (MM/DD/YY)
      manaraya  06/10/08  - Backport manaraya_bug-6718429 from main
      ychan     09/24/07  - Add sql monitor
      swexler   08/29/07 - add flex region
      manaraya  04/15/07  - XbranchMerge manaraya_bug-5852154 from
                            st_emdbsa_11.1
      yma       03/09/07 -  remove yAxisWidth attribute in chart
      manaraya  02/28/07 - 
      ezeng     01/02/07 - 
      nachen    05/09/06 - add results tab for sql worksheet
      sresrini  03/20/06 - 
      yfeng     06/24/05 - Fix ADA violation - add summary for oem:table 
      swexler   03/14/05 - ash report 
      yfeng     01/21/05 - Change the chart session description
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:buildTree nodeID="sessActivity">
  <uix:dataScope>    
  
<uix:subTabLayout>
  <uix:subTabs>
    <uix:subTabBar selectedIndex="2">
      <uix:link textBinding="RESULTS@sqlMsg"
                destinationBinding="resultsDest@servletRequest"
                renderedBinding="renderResultsTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_STATS@sqlMsg"
                destinationBinding="exeDest@servletRequest"/>
      <uix:link textBinding="SESS_ACTIVITY@sqlMsg"/>
      <uix:link textBinding="EXEC_PLAN@sqlMsg"
                destinationBinding="plnDest@servletRequest"/>
      <uix:link renderedBinding="isVer11Higher@sqlDetailUI@servletRequest">
      <uix:flowLayout>
      	<uix:styledText styleClass="OraPromptText" textBinding="DETAIL_PLAN_CONTROL@sqlMsg" destinationBinding="plnControlDest@servletRequest"/>
        <uix:image source="/em/images/infoicon_active.gif" id="processIcon" shortDescBinding="DETAIL_PLAN_CONTROL@sqlMsg"
        	renderedBinding="renderIcon@sqlDetailUI@servletRequest" destinationBinding="plnControlDest@servletRequest"/>
      </uix:flowLayout>
      </uix:link>
      <uix:link textBinding="tuningText@servletRequest" 
                destinationBinding="tunDest@servletRequest"/>
   <uix:switcher childNameBinding="disableMonitor@sqlDetailUI@servletRequest">
        <uix:case name="true">
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                shortDescBinding="NO_MONITOR_INFO@sqlMsg"
                disabled="true"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:case>
        <uix:default>
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:default>
     </uix:switcher>
    </uix:subTabBar>
  </uix:subTabs>



      <uix:stackLayout>
        <uix:header textBinding="EXEC_ACTIVITY@sqlMsg">
          <uix:switcher childNameBinding="useSVG@sessionActivityBean@servletRequest">
            <uix:case name="true">
              <uix:tableLayout renderedBinding="showChart@sessionActivityBean@servletRequest">
                <uix:rowLayout hAlign="left">
                  <uix:messagePrompt promptBinding="WAIT_DETAIL_SELECTOR_TIP@dbMsg" />
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="false">
              <uix:tableLayout renderedBinding="showChart@sessionActivityBean@servletRequest">
                <uix:rowLayout hAlign="left">
                  <uix:messagePrompt promptBinding="EXEC_ACTIVITY_INTR@sqlMsg" />
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>


   <uix:switcher childNameBinding="showChart@sessionActivityBean@servletRequest">   
   <uix:case name="true">
      <uix:switcher childNameBinding="useSVG@sqlDetailUI@servletRequest">
      <uix:case name="true">
               <db:flexRegion
                  swfName="/database/flex/sqlDetails.swf"
                  dataSrcKeyBinding="flexKey@sqlDetailUI@servletRequest"
                  windowWidth="100%"
                  windowHeight="250"
                  idBase="flexSqlDetailsChart" />
       </uix:case>   
       <uix:case name="false" >
            <oem:chart 
                chartType="timeSeriesChart"
                width="900"
                height="175"
                timeGranularity="SECOND" 
                orientation="vertical"
                fill="cumulative"  
                yAxisLabelBinding="ACTIVE_SESSIONS@dbMsg"  
                legendPosition="east"
                legendVisible="true"
                titleBinding="ACTIVE_SESSIONS@dbMsg"
                titleVisible="false"
                seriesColorsAutomatic="true"
                format="svg"
                svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
                xAxisMinBinding="beginDate@waitAreaChart@sessionActivityBean@servletRequest"
                xAxisMaxBinding="endDate@waitAreaChart@sessionActivityBean@servletRequest"
                axisMin="0"
                axisMaxBinding="actualMaxValue@waitAreaChart@sessionActivityBean@servletRequest"
                svgHighlightLegend="true"
                svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@dbMsg"
                colorPaletteBinding="waitColorsTable@activityDetailsChart@sessionActivityBean@servletRequest"
                >
                <uix:contents>
                  <oem:timeSelector
                    xAxisMinBinding="beginDate@waitAreaChart@sessionActivityBean@servletRequest"
                    xAxisMaxBinding="endDate@waitAreaChart@sessionActivityBean@servletRequest"
                    intervalTimeSecBinding="intervalTimeSec@servletRequest"
                    height="20"
                    selectedMaxDateBinding="selectedMaxDate@activityDetailsChart@sessionActivityBean@servletRequest"
                    selectedMinDateBinding="selectedMinDate@activityDetailsChart@sessionActivityBean@servletRequest"
                    numBandsSelectedBinding="numBandsSelected@servletRequest"
                    selectionDest="my_goto_band"
                    selectionDestType="JavaScript"
                    selectionAltTextBinding="SELECT_PERIOD_RANGE@dbMsg" 
                    position="south"
                    dynamicTimeSelector="true"
                    xAxisScrollDest="scroll_timechart"
                    xAxisScrollDestType="JavaScript"
                    xAxisScrollPrevBinding="scrollButtonsAvailable@activityDetailsChart@sessionActivityBean@servletRequest"
                    xAxisScrollPrevAltTextBinding="GO_BACKWARD@dbMsg" 
                    xAxisScrollNextBinding="scrollButtonsAvailable@activityDetailsChart@sessionActivityBean@servletRequest"
                    xAxisScrollNextAltTextBinding="GO_FORWARD@dbMsg" 
                    selectionIndicator="shading"
                    dynamicTimeSelectorColorBinding="sliderColor@waitAreaChart@sessionActivityBean@servletRequest"
                    dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitAreaChart@sessionActivityBean@servletRequest"
                    >
                  </oem:timeSelector>
                  <oem:boundChartDataSource 
                    dataClass="oracle.sysman.db.adm.inst.SqlDetailController"
                    dataMethod="updateChartData" />
                  <oem:chartColumn                                   
                    isKey="true" 
                    displayLabel=""
                    sourceIndex="0" />
                  <oem:chartColumn
                    isTimeColumn="true"
                    displayLabel="Time"
                    sourceIndex="1"  />
                  <oem:chartColumn                                   
                    displayLabel=""
                    sourceIndex="2" />
                </uix:contents>
              </oem:chart>
       
        </uix:case>
        </uix:switcher>

         </uix:case>
         <uix:case name="false">
            <uix:rowLayout>
              <uix:text textBinding="5001@ChartMsgBundle@servletRequest"/>
            </uix:rowLayout>
        </uix:case>
        </uix:switcher>


        </uix:header>
      </uix:stackLayout>


      <uix:switcher childNameBinding="showDetails@servletRequest">
        <uix:case name="true">
          <uix:header size="1"
                      textBinding="detailIntervalHeader@sessionActivityBean@servletRequest"
                      renderedBinding="showChart@sessionActivityBean@servletRequest">

            <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top" >
                <uix:cellFormat hAlign="left">
                    <uix:spacer width="8"/>
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="SPOT_SQL_DETAIL_TEXT@dbMsg"/>
                    <uix:spacer width="8"/>
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="detailStartTime@sessionActivityBean@servletRequest"/>
                  
                    <uix:cellFormat hAlign="right" >
                     <uix:button textBinding="SQL_REPORT@DBMsgBundle@servletRequest"
                      renderedBinding="showSqlReportLink@servletRequest"
                      destinationBinding="sqlReportLink@servletRequest" />
                     <uix:spacer width="5" />
                     <uix:button textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
                      renderedBinding="showAshReportLink@servletRequest"
                      destinationBinding="ashReportLink@servletRequest" />
                   </uix:cellFormat>
                  </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer height="8" />
                  </uix:rowLayout>

                    <oem:table name="aggregatedDetailsTable"
                               summaryBinding="EXEC_ACTIVITY@sqlMsg"
                               beanKey="sessionActivityBean"
                               destinationBinding="destURI@servletRequest"
                               alternateTextBinding="noDataMessage@aggregatedDetailsTable@sessionActivityBean@servletRequest"
                               formSubmitted="true"
                               dataSourceProp="aggregatedDetailsTable"
                               blockSize="10"
                               showAll="yes"
                               width="100%">
                    </oem:table>
                
            </uix:tableLayout>

            </uix:header>
            </uix:case>
            </uix:switcher>

</uix:subTabLayout>
  </uix:dataScope>     
</uix:buildTree>
