<%@ include file="/sdk/oemTop.jspf" %>
<%-- ================  SQL Page =================== 
   MODIFIED    (MM/DD/YY)
      yfeng     06/24/05 - Fix ADA violation - add summary for oem:table 
      yfeng     08/10/04 - remove beginTimestamp and endTimestamp 
      yfeng     04/17/04 - Fix bug 3576997 - show unformated sql text 
      ychan     02/25/04 - 
      yfeng     10/27/03 - remove Plan hash value attribute 
      yfeng     10/23/03 - Copy dbUser and pageNum 
      yfeng     10/14/03 - Copy sqlAddr for 8i and 9i 
      yfeng     10/13/03 - Fix null pointer exception 
      yfeng     10/08/03 - Show Run SQL Tuning Advisor button conditionally 
      yfeng     08/11/03 - Use TABLE_NO_DATA for no data 
      yfeng     08/06/03 - Add PPR 
      yfeng     08/04/03 - Modify timestamp 
      yfeng     07/30/03 - Add SQL Text prompt
      hsu       07/25/03 - change global
      swexler   07/23/03 - add tuning advisor button
      yfeng     06/09/03 - Display a list of existing recommendations
      yfeng     04/30/03 - Support Recommdation History
      qsong     04/29/03 - Add oemTop.jspf
      yfeng     04/10/03 - Add Execution History tab
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
        <db:form name="tsForm"  destinationBinding="destURI@servletRequest"
                  copyParams="target,type,sqlHash,sqlAddr,childNum,sql_id,planHashValue,dbUser,pageNum,breadCrumb">

      <uix:pageLayout titleBinding="header@sqlObjectBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>   
                  
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                 <uix:messagePrompt promptBinding="HDR_SQL_TEXT@DBMsgBundle@servletRequest"
                                    labeledNodeId="ViewLabel" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left">
                  <uix:textInput name="sqlText" id="ViewLabel"
                                 textBinding="sqlText@sqlObjectBean@servletRequest"
                                 readOnly="true"
                                 columns="120"
                                 rows="10" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5"/>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="3">
                    <uix:link textBinding="EXPLAIN_PLAN_HEADER@DBMsgBundle@servletRequest"
                              destinationBinding="explainDest@servletRequest"/>
                    <uix:link textBinding="SQL_STATISTICS@DBMsgBundle@servletRequest"
                              destinationBinding="statDest@servletRequest"/>
                    <uix:link textBinding="EXEC_HISTORY@DBMsgBundle@servletRequest"
                              destinationBinding="execHisDest@servletRequest"/>
                    <uix:link textBinding="sqlAssessRecommTab@sqlObjectBean@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

            <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right">
                   <uix:cellFormat>
                     <uix:rowLayout>
                         <uix:styledText styleClass="OraTipText"
                           textBinding="DATA_RETRIEVED@DBMsgBundle@servletRequest"/>
                         <uix:spacer width="5" />
                         <uix:styledText styleClass="OraTipLabel"
                           textBinding="lastUpdatedTime@sqlObjectBean@servletRequest"/>
                      </uix:rowLayout>
                   </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

              <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
               <uix:case name="true">
            <uix:tableLayout width="100%">
                  <uix:rowLayout>
                 <uix:styledText styleClass="OraInstructionText"
                                 textBinding="SQL_RECOM_HIST_DESC@DBMsgBundle@servletRequest" />
                  </uix:rowLayout>

                  <uix:rowLayout>
                      <uix:spacer height="5"/>
                  </uix:rowLayout>

            </uix:tableLayout>
               </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
               <uix:case name="true">
                 <oem:table name="twoDUIDataSource"
                            summaryBinding="header@sqlObjectBean@servletRequest"
                            beanKey="sqlObjectBean"
                            dataSourceProp="sqlRecomHistTableUIDS"
                            alternateTextBinding="TABLE_NO_DATA@DBMsgBundle@servletRequest"
                            formSubmitted="true"
                            width="100%">
                 </oem:table>
               </uix:case>
               <uix:case name="false">

                <uix:rowLayout>
                    <uix:stackLayout>
                      <uix:switcher childNameBinding="sqlProblemsExist@sqlObjectBean@servletRequest">
                        <uix:case name="true">

                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="PROBLEM_SUMMARY_RESPONSE_ONLY@DBMsgBundle@servletRequest" />
                          <oem:table name="twoDUIDataSource"
                                     beanKey="sqlObjectBean"
                                     destination="/console/database/instance/realTimeSqlObject"
                                     formSubmitted="true"
                                     dataSourceProp="problemsUIDataSource"
                                     width="100%">
                          </oem:table>
                        </uix:case>

                        <uix:case name="false">

                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="PROBLEM_SUMMARY_NONE@DBMsgBundle@servletRequest" />
                        </uix:case>
                      </uix:switcher>
                    </uix:stackLayout>
                </uix:rowLayout>
               </uix:case>
              </uix:switcher>
              <uix:spacer height="5"/>

            </uix:subTabLayout>


          <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
               <uix:switcher childNameBinding="sqlTunable@sqlObjectBean@servletRequest">
                <uix:case name="true">
                  <uix:submitButton textBinding="RUN_TUNING_ADVISOR@DBMsgBundle@servletRequest"
                                    name="event"
                                    value="sqlTuning" />
                </uix:case>
               </uix:switcher>
            </uix:case>
           </uix:switcher>
          </uix:pageButtonBar>
          </uix:pageButtons>

              
      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

