<%-- ================   SQL Details page  =================

   MODIFIED    (MM/DD/YY)
      yemeng    12/10/08 - XbranchMerge yemeng_bug-7554196 from
                           st_emdbgc_10.2.0.1.0
      yemeng    11/07/08 - bug 7554196
      manaraya  08/01/08 - XbranchMerge manaraya_bug-6955156 from main
      manaraya  07/11/08 - XbranchMerge manaraya_bug-6718429 from main
      manaraya  06/10/08 - Backport manaraya_bug-6718429 from main
      manaraya  05/13/08 - Bug 6955156
      ychan     01/23/08 - 
      ezeng     12/24/07 - Backport ezeng_bug-6674423_gc from main
      ychan     12/18/07 - Support sql monitoring
      ezeng     12/13/07 - 
      ychan     09/27/07 - 
      manaraya  04/15/07 - XbranchMerge manaraya_bug-5852154 from
                           st_emdbsa_11.1
      hsu       03/06/07 - Removed URL from auto refresh meta tag
      yfeng     03/06/07 - XbranchMerge yfeng_bug-5847889 from st_emdbsa_11.1
      manaraya  02/28/07 - Add SQL Plan Control
      yfeng     02/28/07 - Fix bug 5847889 to add note for having multiple
                           plans
      yfeng     09/20/06 - Code clean up
      jro       08/02/06 - checked out for build
      jro       05/19/06 - Diagnostic Result Analysis button 
      yfeng     03/09/06 - Testing only 
      nachen    05/18/06 - add SQL Worksheet 
      yma       06/22/05 - bug 4449918 
      swexler   05/05/05 - 
      yfeng     03/31/05 - Fix 4277200 - use svf refresh for 15 sec for 
                           Activity 
      yfeng     03/23/05 - Fix bug 4121357 - Add refresh button 
      yfeng     01/13/05 - Do not show hide/show icon for sql text if not needed
--%>

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>


<uix:styleSheet/>


  <script>

    function scroll_timechart(direction)
    {
    if (direction == 'prev'){
    document.sqlForm.direction.value = '1';
    }
    else{
    document.sqlForm.direction.value = '2';
    }
    submitForm('sqlForm', true, {'event':'scrollChart'});
    }

    function my_goto_band(selIdx, startMS, endMS)
    {
    submitForm('sqlForm', true, {'event':'moveSlider','leftEdge':startMS,'rightEdge':endMS,'selectedBand':selIdx});
    }

    function sliderOffLeft(param)
    {
    location.href = param;
    }
    function svgIconClicked(iconIndex, startMS, endMS)
    {
        document.sqlForm.iconIndex.value = iconIndex;  
        submitForm('sqlForm', true, {'event':'iconClicked'});   
    }
  </script>


<jsp:useBean
    id="sqlDetailUI"
    scope="request"
    type="oracle.sysman.emo.perf.bean.sql.SQLDetailUI"/>
    
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="mvMsgs" class="oracle.sysman.db.rsc.schm.MViewMsg"/>

  <uix:switcher childNameBinding="refreshChoice@sqlDetailUI@servletRequest">
     <uix:case name="RT_15">
       <uix:switcher childNameBinding="isVer10Higher@sqlDetailUI@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="autoRefresh@servletRequest">
              <uix:case name="true">
            <uix:rawText>
              <meta http-equiv="Refresh"
                    content="15; URL=<%=request.getAttribute("sqlDetailRefreshURL")%>">
            </uix:rawText> 
              </uix:case>  
            </uix:switcher>
          </uix:case>
          <uix:default>
            <uix:rawText>
              <meta http-equiv="Refresh"
                    content="15; URL=<%=request.getAttribute("sqlDetailRefreshURLpre10g")%>">
            </uix:rawText>           
          </uix:default>
        </uix:switcher>  
      </uix:case>  
  </uix:switcher>
  
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
        <db:form name="sqlForm"  destinationBinding="destURI@servletRequest"
                 copyParams="target,type, pageNum,sqlHash,sqlAddr,sql_id,breadCrumb,state,_root,node">
              <uix:formValue name="leftEdge" />
              <uix:formValue name="rightEdge" />
              <uix:formValue name="event" />
              <uix:formValue name="direction" value=""/>
              <uix:formValue name="selectedBand" value=""/>
              <uix:formValue name="iconIndex" value=""/>                 
              
      <uix:pageLayout titleBinding="header@sqlDetailUI@servletRequest">
        <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>  
    <oem:messageBox messageType="warning"
                        errorTableBinding="intervalWarning@servletRequest"
                        mainTextKey="exceptionText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="intervalError@servletRequest"
                        mainTextKey="exceptionText"/>
      
    <%@ include file="/database/instances.jspf" %> 
      
  <uix:tableLayout  width="100%"  >
      <uix:rowLayout>       
    <uix:cellFormat hAlign="left">   
     <uix:tableLayout cellSpacing="3" renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">
          <uix:rowLayout  hAlign="right">
            <uix:cellFormat  hAlign="right">
              <uix:messageTextInput name="switchID" columns="10" promptBinding="SWITCH_ID@sqlMsg" textBinding="switchID@sqlDetailUI@servletRequest" />        
            </uix:cellFormat> 
            <uix:cellFormat hAlign="left">   
              <uix:submitButton textBinding="GO@sqlMsg" name="event" value="go"/> 
            </uix:cellFormat>           
          </uix:rowLayout>     
        </uix:tableLayout>  
    </uix:cellFormat>
    <uix:cellFormat hAlign="right">   
    <uix:tableLayout cellSpacing="3">
      <uix:rowLayout  hAlign="right">   
              <uix:cellFormat hAlign="right"> 
                    <uix:messagePrompt promptBinding="VIEW_DATA_LABEL@dbMsg" labeledNodeId="refreshChoice"/> 
                    </uix:cellFormat> 
                    <uix:cellFormat hAlign="right"> 
                      <uix:spacer width="5" />
                      <uix:choice id="refreshChoice" name="refreshChoice"
                                 onChange="submitForm('sqlForm', true, {'event':'changeViewData'})"
                                 selectedValueBinding="refreshChoice@sqlDetailUI@servletRequest"                                
                                 shortDescBinding="VIEW_DATA_LABEL@dbMsg">
                                 <uix:contents childDataBinding="viewDataList@sqlDetailUI@servletRequest">
                                    <uix:option textBinding="stext"
                                                valueBinding="sval"/>
                     </uix:contents>
                    </uix:choice>      
                    </uix:cellFormat>   
                     
      <uix:cellFormat hAlign="right">
        <uix:submitButton textBinding="REFRESH@SDKBundle@servletRequest" 
                          name="event" value="doLoad" />
      </uix:cellFormat> 
      <%
      if (sqlDetailUI.getIsVer10Higher())
      {
      %>
      <uix:cellFormat hAlign="right" renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest">
              <uix:button textBinding="SQL_WORKSHEET@sqlMsg" destinationBinding="sqlWorksheetURL@servletRequest"/>
       </uix:cellFormat>
      <%
        }
      %>
      <uix:cellFormat hAlign="right" renderedBinding="sqlTunable@servletRequest">
              <uix:submitButton textBinding="RUN_TUNING_ADVISOR@dbMsg" name="event" value="sqlTuning" />

       </uix:cellFormat> 
       <uix:cellFormat hAlign="right" renderedBinding="sqlTunable@servletRequest">
              <uix:submitButton textBinding="DIAGOPT_RESULT_ANALYSIS@sqlMsg" name="event" value="sqlDiag"/>
       </uix:cellFormat>
      </uix:rowLayout>    
    </uix:tableLayout>  
    </uix:cellFormat>
    
      </uix:rowLayout>     
    </uix:tableLayout>  

    <uix:switcher childNameBinding="showTextIcon@sqlDetailUI@servletRequest">        
      <uix:case name="true"> 
       <uix:stackLayout>
         <uix:rowLayout>    
           <uix:hideShowHeader textBinding="TEXT@sqlMsg"
                    disclosedBinding="disclosedIcon@sqlDetailUI@servletRequest" 
                    formSubmitted="true" id="hideShowSql" />
           <uix:spacer width="15"/>
           <uix:image source="/em/images/database/sql/file_html.gif" id="processIcon"  shortDescBinding="FORMAT_SQL_IN_HTML@sqlMsg" destinationBinding="formatSqlURL@servletRequest"/>
         </uix:rowLayout>    

          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer width="15" />
                </uix:cellFormat > 
                <uix:cellFormat hAlign="left">
                  <db:sqlDisplay sqlListBinding="sqlList@sqlDetailUI@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>              
          </uix:tableLayout>
       </uix:stackLayout>
      </uix:case>         
      <uix:case name="false"> 
     	<uix:stackLayout>
          <uix:rowLayout>
            <uix:header textBinding="TEXT@sqlMsg"/>
            <uix:spacer width="15"/>
            <uix:image source="/em/images/database/sql/file_html.gif" id="processIcon"  shortDescBinding="FORMAT_SQL_IN_HTML@sqlMsg" destinationBinding="formatSqlURL@servletRequest"/>
          </uix:rowLayout>
          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer width="15" />
                </uix:cellFormat > 
                <uix:cellFormat hAlign="left">
                  <db:sqlDisplay sqlListBinding="sqlList@sqlDetailUI@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>              
            </uix:tableLayout>
        </uix:stackLayout>
      </uix:case>         
        </uix:switcher> 
        
        
       <uix:header textBinding="DETAILS@sqlMsg">
              <uix:tableLayout cellSpacing="5"  renderedBinding="isVer90Higher@sqlDetailUI@servletRequest">   
               <uix:rowLayout> 
                    <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                    <uix:messagePrompt promptBinding="SELECT_PLAN_HASH@sqlMsg" />                     
                    </uix:cellFormat> 
                    <uix:cellFormat> 
                    <uix:spacer width="10" />
                    </uix:cellFormat> 
                    <uix:cellFormat> 
                    <uix:messagePrompt promptBinding="PLAN_HASH_VALUE@dbMsg" labeledNodeId="planHashValue"/> 
                    </uix:cellFormat> 
                    <uix:cellFormat>                       
                      <uix:choice id="planHashValue" name="planHashValue"
                                 selectedValueBinding="planHashValue@sqlDetailUI@servletRequest"                                
                                 shortDescBinding="PLAN_HASH_VALUE@dbMsg"
                                 onChange="submitForm('sqlForm', true, {'event':'changePlanHash'})"> 
                                 <uix:contents childDataBinding="planHashList@sqlDetailUI@servletRequest">
                                    <uix:option textBinding="stext"
                                                valueBinding="sval"/>
                     </uix:contents>
                    </uix:choice>      
                    </uix:cellFormat>   
                    <%-- Show note when multiple plans are available --%>
                    <uix:cellFormat renderedBinding="moreThanOnePlans@sqlDetailUI@servletRequest"> 
                    <uix:spacer width="10" />
                    </uix:cellFormat> 
                    <uix:cellFormat renderedBinding="moreThanOnePlans@sqlDetailUI@servletRequest"> 
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="MULTIPLE_PLANS_AVAILABLE@sqlMsg"/>
                    </uix:cellFormat>                     
                  </uix:rowLayout>                    
              </uix:tableLayout>                     
              
            <uix:spacer height="3"/>

    <uix:switcher childNameBinding="pageNum@servletRequest">        
      <uix:case name="2"> 
       <%
        if (sqlDetailUI.getIsVer10Higher())
        {
       %>
          <jsp:include page="sessActivity.jsp" />   
          <uix:ref refID="sessActivity" />
       <%
        }
       %>
         
      </uix:case>    
      <uix:case name="3">
        <jsp:include page="executionPlan.jsp" />   
        <uix:ref refID="executionPlan" />              
      </uix:case>      
      <uix:case name="4">
       <%
        if (sqlDetailUI.getIsVer11Higher())
        {
       %>
        <jsp:include page="sqlPlanControl.jsp" />   
        <uix:ref refID="sqlPlanControl" />              
       <%
        }
       %>
      </uix:case>      
      <uix:case name="5">      
        <uix:switcher childNameBinding="SWRF@sqlDetailUI@servletRequest">
          <uix:case name="true">
            <jsp:include page="sqlTuningInfo.jsp" />   
            <uix:ref refID="sqlTuningInfo" />
          </uix:case>
           <uix:case name="false">
            <jsp:include page="sqlAssess.jsp" />   
            <uix:ref refID="sqlAssess" />
          </uix:case>         
        </uix:switcher> 
        
      </uix:case>            
      <uix:case name="6">
        <jsp:include page="sqlMonitor.jsp" />   
        <uix:ref refID="sqlMonitor" />              
      </uix:case>      
      <uix:default> 
        <jsp:include page="sqlExecStats.jsp" />   
        <uix:ref refID="sqlExecStats" />   
      </uix:default>         
    </uix:switcher> 
       
  </uix:header>       
  <uix:tableLayout  width="100%" renderedBinding="sqlTunable@servletRequest" >
    <uix:rowLayout  hAlign="right">       
       <uix:tableLayout cellSpacing="5">
         <uix:rowLayout  hAlign="right">      
           <%
            if (sqlDetailUI.getIsVer10Higher())
            {
            %>
            <uix:cellFormat hAlign="right" renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest">
              <uix:button textBinding="SQL_WORKSHEET@sqlMsg" destinationBinding="sqlWorksheetURL@servletRequest"/>
            </uix:cellFormat>
            <%
            }
            %>
           <uix:cellFormat hAlign="right">         
             <uix:submitButton textBinding="RUN_TUNING_ADVISOR@dbMsg" name="event" value="sqlTuning" />
           </uix:cellFormat> 
         </uix:rowLayout>     
       </uix:tableLayout>  
    </uix:rowLayout>     
  </uix:tableLayout>  
  
      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
