<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
        <db:form name="foo"  destinationBinding="destURI@servletRequest"
         copyParams="target,type,sqlHash,sqlAddr,childNum,sql_id,planHashValue,dbUser,pageNum,breadCrumb">

      <uix:pageLayout titleBinding="header@sqlObjectBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>  
                  
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                 <uix:messagePrompt promptBinding="HDR_SQL_TEXT@DBMsgBundle@servletRequest"
                                    labeledNodeId="ViewLabel" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left">
                  <uix:textInput name="sqlText" id="ViewLabel"
                                 textBinding="sqlText@sqlObjectBean@servletRequest"
                                 readOnly="true"
                                 columns="120"
                                 rows="10" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5"/>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="2">
                    <uix:link textBinding="EXPLAIN_PLAN_HEADER@DBMsgBundle@servletRequest"
                              destinationBinding="explainDest@servletRequest"/>
                    <uix:link textBinding="SQL_STATISTICS@DBMsgBundle@servletRequest"
                              destinationBinding="statDest@servletRequest"/>
                    <uix:link textBinding="EXEC_HISTORY@DBMsgBundle@servletRequest"/>
                    <uix:link textBinding="sqlAssessRecommTab@sqlObjectBean@servletRequest"
                              destinationBinding="assessDest@servletRequest"/>

                </uix:subTabBar>
              </uix:subTabs>

                <uix:spacer height="5"/>

            <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">

              <uix:submitButton textBinding="REFRESH_LABEL@DBMsgBundle@servletRequest"
                                name="event" value="refreshChart"/>

            </uix:rowLayout>
            </uix:tableLayout>


              <uix:rowLayout>
                  <uix:stackLayout>
                <uix:header textBinding="chartHeaderTitle@servletRequest">

            <uix:tableLayout>


             <uix:switcher childNameBinding="8i@sqlObjectBean@servletRequest">
              <uix:case name="false">
                <uix:rowLayout hAlign="left">
                  <uix:flowLayout>
                    <uix:spacer width="10"/>
                    <uix:messagePrompt
                      promptBinding="VIEW_CHART@DBMsgBundle@servletRequest"/>
                    <uix:spacer width="10"/>

                    <oem:radioButton name="chartTypeChoice" value="totalStatisticsCharts"
                      selectedValueBinding="statisticsChartType@sqlObjectBean@servletRequest"
                      textBinding="TIME_IN_SECONDS@DBMsgBundle@servletRequest"
                      styleClass="OraInstructionText" />

                    <oem:radioButton name="chartTypeChoice" value="perExecStatisticsCharts"
                      selectedValueBinding="statisticsChartType@sqlObjectBean@servletRequest"
                      textBinding="TIME_IN_SECONDS_PER_EXEC@DBMsgBundle@servletRequest"
                      styleClass="OraInstructionText" />


            <uix:spacer width="5"/>

                    <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                      name="event" value="setChartType" />
                  </uix:flowLayout>
              </uix:rowLayout>
             </uix:case>
             <uix:case name="true">
                <uix:rowLayout hAlign="left">
                  <uix:flowLayout>
                    <uix:spacer width="10"/>
                    <uix:messagePrompt
                      promptBinding="VIEW_CHART@DBMsgBundle@servletRequest"/>
                    <uix:spacer width="10"/>

                    <oem:radioButton name="chartTypeChoice" value="totalStatisticsCharts"
                      selectedValueBinding="statisticsChartType@sqlObjectBean@servletRequest"
                      textBinding="BLOCKS@sqlMsg"
                      styleClass="OraInstructionText" />

                    <oem:radioButton name="chartTypeChoice" value="perExecStatisticsCharts"
                      selectedValueBinding="statisticsChartType@sqlObjectBean@servletRequest"
                      textBinding="BLOCKS_PER_EXEC@sqlMsg"
                      styleClass="OraInstructionText" />

            <uix:spacer width="5"/>

                    <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                      name="event" value="setChartType" />
                  </uix:flowLayout>
              </uix:rowLayout>
                    </uix:case>
                   </uix:switcher>



                <uix:rowLayout>
                    <uix:stackLayout>
                          <oem:chart 
                            titleBinding="chartHeaderTitle@servletRequest"
                            noDataMessageBinding="DATA_NOT_AVAILABLE@DBMsgBundle@servletRequest"
                            titleVisible="false"
                            chartType="timeSeriesChart"
                            orientation="vertical"
                            width="700"
                            height="160" 
                            timeGranularity="MINUTE"
                            legendPosition="south"
                            yAxisNumberFormatBinding="numberFormat@servletRequest"
                            seriesColorsAutomatic="true">
                          <uix:contents>
                            <oem:boundChartDataSource 
                              chartDataSourceBinding="timeStatisticsChartDS@servletRequest" />
                            <oem:chartColumn
                              displayLabel="Name"
                              sourceIndex="0" 
                              isKey="true" 
                            />
                            <oem:chartColumn
                              displayLabel="Time"
                              sourceIndex="1" 
                              isTimeColumn="true" 
                            />
                            <oem:chartColumn
                              sourceIndex="2"
                            />
                          </uix:contents>
                        </oem:chart>

                    </uix:stackLayout>
                </uix:rowLayout>
            </uix:tableLayout>

               </uix:header>
               <oem:chart
                    titleBinding="EXECUTIONS@DBMsgBundle@servletRequest"
                    noDataMessageBinding="DATA_NOT_AVAILABLE@DBMsgBundle@servletRequest"
                    chartType="timeSeriesChart"
                    orientation="vertical"
                    width="700"
                    height="160"
                    timeGranularity="MINUTE"
                    legendPosition="south"
                    yAxisNumberFormatBinding="numberFormat@servletRequest"
                    seriesColorsAutomatic="true">
                  <uix:contents>
                    <oem:boundChartDataSource
                      chartDataSourceBinding="executionsChartDS@servletRequest" />
                    <oem:chartColumn
                      displayLabel="Name"
                      sourceIndex="0"
                      isKey="true"
                    />
                    <oem:chartColumn
                      displayLabel="Time"
                      sourceIndex="1"
                      isTimeColumn="true"
                    />
                    <oem:chartColumn
                      sourceIndex="2"
                    />
                  </uix:contents>
                </oem:chart>
                  </uix:stackLayout>
              </uix:rowLayout>

                      <uix:spacer height="10"/>


            </uix:subTabLayout>
          
          <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
               <uix:switcher childNameBinding="sqlTunable@sqlObjectBean@servletRequest">
                <uix:case name="true">
                  <uix:submitButton textBinding="RUN_TUNING_ADVISOR@DBMsgBundle@servletRequest"
                                    name="event"
                                    value="sqlTuning" />
                </uix:case>
               </uix:switcher>
            </uix:case>
           </uix:switcher>
          </uix:pageButtonBar>
          </uix:pageButtons>
          
      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

