<%-- ================  Statistics tab of SQL Details Page =================== 

   MODIFIED    (MM/DD/YY)
      manaraya  06/10/08 - Backport manaraya_bug-6718429 from main
      ychan     09/24/07 - Add sql monitor
      manaraya  04/17/07 - XbranchMerge manaraya_bug-5934867 from
                           st_emdbsa_11.1
      manaraya  04/15/07 - XbranchMerge manaraya_bug-5852154 from
                           st_emdbsa_11.1
      yfeng     03/06/07 - XbranchMerge yfeng_bug-5847889 from st_emdbsa_11.1
      nachen    01/14/07 - XbranchMerge nachen_bug-5758143 from st_emdbsa_11.1
      manaraya  04/17/07 - XbranchMerge manaraya_bug-5934867 from
                           st_emdbsa_11.1
      yfeng     03/06/07 - XbranchMerge yfeng_bug-5847889 from st_emdbsa_11.1
      nachen    01/14/07 - XbranchMerge nachen_bug-5758143 from st_emdbsa_11.1
      manaraya  02/28/07 - 
      yfeng     03/01/07 - Add more information requested in bug 5847889
      nachen    01/09/07 - hide tuning info tab for sql worksheet
      yfeng     09/20/06 - Remove unused code to improve CC number
      nachen    04/27/06 - add results tab 
      yfeng     06/24/05 - Fix ADA violation - add summary for uix:table 
      yma       02/02/05 - add user
      yma       02/01/05 - add last load time
      yma       01/18/05 - Sql Detail page UI change
      yfeng     10/01/04 - Fix problem that RT chart does not show up - add stackLayout
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="sqlExecStats">
  <uix:dataScope>        
    <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                    <uix:link textBinding="RESULTS@sqlMsg"
                              destinationBinding="resultsDest@servletRequest"
                              renderedBinding="renderResultsTab@sqlDetailUI@servletRequest"/>
                    <uix:link textBinding="EXEC_STATS@sqlMsg" />
                    <uix:link textBinding="SESS_ACTIVITY@sqlMsg"
                              destinationBinding="actDest@servletRequest"
                              renderedBinding="renderSessActTab@sqlDetailUI@servletRequest"/>
                    <uix:link textBinding="EXEC_PLAN@sqlMsg"
                              destinationBinding="plnDest@servletRequest"/>
      <uix:link renderedBinding="isVer11Higher@sqlDetailUI@servletRequest">
      <uix:flowLayout>
      	<uix:styledText styleClass="OraPromptText" textBinding="DETAIL_PLAN_CONTROL@sqlMsg" destinationBinding="plnControlDest@servletRequest" renderedBinding="renderTuningInfoTab@sqlDetailUI@servletRequest"/>
        <uix:image source="/em/images/infoicon_active.gif" id="processIcon" shortDescBinding="DETAIL_PLAN_CONTROL@sqlMsg"
        	renderedBinding="renderIcon@sqlDetailUI@servletRequest" destinationBinding="plnControlDest@servletRequest"/>
      </uix:flowLayout>
      </uix:link>
                    <uix:link textBinding="tuningText@servletRequest"
                              destinationBinding="tunDest@servletRequest"
                              renderedBinding="renderTuningInfoTab@sqlDetailUI@servletRequest"/>
   <uix:switcher childNameBinding="disableMonitor@sqlDetailUI@servletRequest">
        <uix:case name="true">
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                shortDescBinding="NO_MONITOR_INFO@sqlMsg"
                disabled="true"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:case>
        <uix:default>
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:default>
     </uix:switcher> 

                </uix:subTabBar>
              </uix:subTabs>

<uix:switcher childNameBinding="showStats@sqlDetailUI@servletRequest">
  <uix:case name="false">        
    <uix:stackLayout>
        <uix:spacer height="20"/>
          <uix:switcher childNameBinding="isRealTime@sqlDetailUI@servletRequest">        
            <uix:case name="true">             
                <uix:styledText styleClass="OraInstructionText"
                    textBinding="SQL_STAT_NOT_FOUND@dbMsg" />
            </uix:case>
            <uix:default>
                <uix:styledText styleClass="OraInstructionText"
                    textBinding="STATS_NOT_AVAIL@sqlMsg" />            
            </uix:default>        
          </uix:switcher>            
        <uix:spacer height="20"/>                    
    </uix:stackLayout>                    
  </uix:case>
  
  <uix:default>
  <uix:stackLayout>
 <uix:header textBinding="EXEC_ACTIVITY@sqlMsg" size="2"  renderedBinding="isHist10@sqlDetailUI@servletRequest">  
   <uix:switcher childNameBinding="refreshChoice@sqlDetailUI@servletRequest">
      <uix:case name="HIST_CUST">      
        <uix:stackLayout>
          <%@ include file="sqlExecActHT.jspf" %>        
        </uix:stackLayout>                    
      </uix:case>            
      <uix:default> 
        <uix:stackLayout>
          <%@ include file="sqlExecActRT.jspf" %>
        </uix:stackLayout>                    
      </uix:default>         
    </uix:switcher> 
 </uix:header>     

  <uix:stackLayout  renderedBinding="isStatsFound@sqlDetailUI@servletRequest" >  
  
    <uix:tableLayout width="100%">
	  <uix:rowLayout width="100%" > 
      
        <uix:cellFormat  vAlign="top" >    
  
        <uix:header textBinding="GENERAL@sqlMsg" size="2" >      
          <uix:tableLayout >                  
            <uix:rowLayout >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="MODULE@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left">               
               <uix:styledText styleClass="OraDataText" 
                              textBinding="module@sqlDetailUI@servletRequest" />
              </uix:cellFormat>                              
            </uix:rowLayout>  
             <uix:rowLayout renderedBinding="isRT10@sqlDetailUI@servletRequest" >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="ACTION@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>              
              <uix:cellFormat wrappingDisabled="true" hAlign="left">                             
              <uix:styledText styleClass="OraDataText" 
                              textBinding="action@sqlDetailUI@servletRequest" />
              </uix:cellFormat>                                                            
            </uix:rowLayout>  
            <uix:rowLayout  renderedBinding="isRT10@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="PARSING_SCHEMA@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>              
              <uix:cellFormat wrappingDisabled="true" hAlign="left">                             
              <uix:styledText styleClass="OraDataText" 
                              textBinding="parsingSchema@sqlDetailUI@servletRequest" />
              </uix:cellFormat> 
            </uix:rowLayout> 
            <uix:rowLayout renderedBinding="showUser@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="USER@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="parsingUser@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout> 
            <uix:rowLayout  renderedBinding="showPlsql@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="false" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="PLSQL_SOURCE@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>              
              <uix:cellFormat wrappingDisabled="false" hAlign="left" width="50">                             

              <uix:switcher childNameBinding="programNameAndLineNumberExisted@sqlDetailUI@servletRequest">
                <uix:case name="true">
                  <uix:link textBinding="programNameAndLineNumber@sqlDetailUI@servletRequest"
                            destinationBinding="programURL@sqlDetailUI@servletRequest"/>
                </uix:case>
                <uix:case name="false">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="programNameAndLineNumber@sqlDetailUI@servletRequest" />
                </uix:case>
              </uix:switcher>              
              </uix:cellFormat> 
            </uix:rowLayout>  
            <uix:rowLayout renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="PROFILE_NAME@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="activeSqlProfileName@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout> 
              
            <uix:rowLayout renderedBinding="showSqlPlanBaseline@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="SQL_PLAN_BASELINE@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="activeSqlPlanBaseline@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout> 
          </uix:tableLayout>
          </uix:header>
        </uix:cellFormat>
        
        <uix:cellFormat vAlign="top" width="320" renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">    
        <uix:header textBinding="ACT_WAITS@sqlMsg" size="2" >          
         <oem:chart 
           chartType="pieChart"
           width="120"
           height="140"
           legendPosition="east"
           legendVisible="external"
           showSlicePercentLabels="true"
           hideZeroSlices="true"
           titleBinding="ACTIVITY@sqlMsg"
           titleVisible="false" 
           pieValuesInLegend="percent"
           noDataMessageBinding="NO_DATA@sqlMsg"
           pieSliceColorsBinding="activityColors@sqlDetailUI@servletRequest">

           <oem:boundChartDataSource chartDataSourceBinding="activityDataSource@sqlDetailUI@servletRequest"/>
           <oem:chartColumn isKey="true"
             displayLabel="Label 1"
             sourceIndex="0" />
           <oem:chartColumn displayLabel="Label 2"
             sourceIndex="1" />            
         </oem:chart>
         </uix:header>
        </uix:cellFormat>               
        
        <uix:cellFormat vAlign="top">
        
        <uix:rowLayout width="100%" >
        <uix:cellFormat vAlign="top">
        
        <uix:header textBinding="ACT_TIME@sqlMsg" size="2" renderedBinding="isVer90Higher@sqlDetailUI@servletRequest">
          <uix:tableLayout>                  
            <uix:rowLayout >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="ELAPSED_TIME@sqlMsg"/>
               </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="elapsedTime@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>  
             <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="CPU_TIME@sqlMsg"/>
               </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="cpuTime@sqlDetailUI@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>  
             <uix:rowLayout >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="WAIT_TIME@sqlMsg"/>
               </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="waitTime@sqlDetailUI@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>  
           </uix:tableLayout>
          </uix:header>

          </uix:cellFormat>
         </uix:rowLayout>
        <uix:rowLayout width="100%">
         <uix:cellFormat vAlign="top" >
         
        <uix:header textBinding="ELAPSED_TIME_BD@sqlMsg" size="2" renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">
          <uix:tableLayout>                  
             <uix:rowLayout >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="SQL_TIME@sqlMsg"/>
               </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="sqlExecTime@sqlDetailUI@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>  
             <uix:rowLayout >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="PLSQL_TIME@sqlMsg"/>
               </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="plsqlExecTime@sqlDetailUI@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>  
             <uix:rowLayout >       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="JAVA_TIME@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="javaExecTime@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>  
          </uix:tableLayout>
         </uix:header>       
        </uix:cellFormat>    
      </uix:rowLayout>  

        </uix:cellFormat>    
      </uix:rowLayout>  

      
	  <uix:rowLayout width="100%"> 
     <uix:cellFormat vAlign="top">   
      <uix:header textBinding="SD_CURSORS_STAT@sqlMsg" size="2">  
        <uix:tableLayout> 
          <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="TOT_PARSES@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="parseCalls@sqlDetailUI@servletRequest" />
              </uix:cellFormat>                               
          </uix:rowLayout>  
          <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="HARD_PARSES@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="hardParse@sqlDetailUI@servletRequest" />
              </uix:cellFormat>                               
          </uix:rowLayout>  
          <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="CHILD_CURSORS@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="numberOfChildCursors@sqlDetailUI@servletRequest" />
              </uix:cellFormat >                                                             
          </uix:rowLayout>  
          <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="LOADED_PLANS@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="loadedVersions@sqlDetailUI@servletRequest" />
              </uix:cellFormat >                               
          </uix:rowLayout>             
          <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="INVALIDATIONS@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="invalidations@sqlDetailUI@servletRequest" />
              </uix:cellFormat >                                                             
          </uix:rowLayout>  
          <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="LARGEST_CURSOR_SIZE@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="sharableMem@sqlDetailUI@servletRequest" />             
              </uix:cellFormat >                                                             
          </uix:rowLayout>  
          <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="ALL_CURSOR_SIZE@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="totalSharableMem@sqlDetailUI@servletRequest" />
              </uix:cellFormat >                                                             
            </uix:rowLayout>  
            <uix:rowLayout  renderedBinding="isRealTime@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="FIRST_LOAD_TIME@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="false" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="firstLoadTime@sqlDetailUI@servletRequest" />
              </uix:cellFormat >                                                             
            </uix:rowLayout>  
            <uix:rowLayout  renderedBinding="isRTand90@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="LAST_LOAD_TIME@sqlMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                            <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="false" hAlign="left"> 
                <uix:styledText styleClass="OraDataText" 
                              textBinding="lastLoadTime@sqlDetailUI@servletRequest" />
              </uix:cellFormat >                                                             
            </uix:rowLayout>  
          </uix:tableLayout>
        </uix:header>            
      </uix:cellFormat > 
            
      <uix:cellFormat  vAlign="top">        
        <uix:header textBinding="EXEC_STATS_SECTION@sqlMsg" size="2"> 
          
          <uix:rowLayout width="100%">
            <uix:table  width="100%"                        
                           summaryBinding="EXEC_STATS@sqlMsg"
                           name="history"
                           columnFormatsBinding="execStatColFormats@sqlDetailUI@pageContext"
                           columnHeaderDataBinding="execStatColHeader@sqlDetailUI@servletRequest"
                           tableDataBinding="execStatData@sqlDetailUI@servletRequest">
              <uix:tableFormat tableBanding="rowBanding"/>
              <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text" />
              </uix:columnHeaderStamp>
              <uix:contents>
                     <uix:styledText textBinding="name" />      
                     <uix:styledText textBinding="total" />      
                     <uix:styledText textBinding="per execute"/>  
                     <uix:styledText textBinding="per row"/>           
              </uix:contents>
            </uix:table>    
          </uix:rowLayout>       

            </uix:header>            
            
            </uix:cellFormat> 
   
        <uix:cellFormat  vAlign="top">        
            <uix:header textBinding="OTHER_STATS@sqlMsg" size="2" renderedBinding="isRT10@sqlDetailUI@servletRequest">
        
         <uix:switcher childNameBinding="isRealTime@sqlDetailUI@servletRequest">
          <uix:case name="true">      
           <uix:tableLayout>
       
            <uix:rowLayout renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="FETCHED_ALL_ROWS@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 

              <uix:styledText styleClass="OraDataText" 
                              textBinding="fetchedAllRows@sqlDetailUI@servletRequest" />
             </uix:cellFormat>                               
            </uix:rowLayout>  
            <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="AVG_PERSIST_MEM@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="persistentMem@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>  
             <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="AVG_RUNTIME_MEM@sqlMsg"/>
              </uix:cellFormat>                
              <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="runtimeMem@sqlDetailUI@servletRequest" />
             </uix:cellFormat>               
            </uix:rowLayout>  
            <uix:rowLayout>       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="SERIAL_ABORTS@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="serialAborts@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>  
             <uix:rowLayout renderedBinding="isVer90Higher@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="REMOTE@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="isRemote@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>  
            <uix:rowLayout renderedBinding="isVer90Higher@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="IS_OBSOLETE@sqlMsg"/>
               </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="isObsolete@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>              

            <uix:rowLayout renderedBinding="isVer92Higher@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="CHILD_LATCH@sqlMsg"/>
                </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 
              <uix:styledText styleClass="OraDataText" 
                              textBinding="childLatch@sqlDetailUI@servletRequest" />
             </uix:cellFormat>
            </uix:rowLayout>  
          </uix:tableLayout>


      </uix:case>            

      <uix:default> 
          <uix:tableLayout>
            <uix:rowLayout renderedBinding="isVer10Higher@sqlDetailUI@servletRequest">       
              <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                <uix:messagePrompt promptBinding="FETCHED_ALL_ROWS@sqlMsg"/>
              </uix:cellFormat>
               <uix:cellFormat>
                            <uix:spacer width="5"/>
               </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="left"> 

              <uix:styledText styleClass="OraDataText" 
                              textBinding="fetchedAllRows@sqlDetailUI@servletRequest" />
             </uix:cellFormat>                               
            </uix:rowLayout>  
          </uix:tableLayout>

      </uix:default>         
    </uix:switcher> 

            </uix:header>            
            
            </uix:cellFormat> 
            
            
            </uix:rowLayout>  
          </uix:tableLayout>
  </uix:stackLayout>
 
  </uix:stackLayout>
      
  </uix:default>
</uix:switcher>
    </uix:subTabLayout>    
  </uix:dataScope>     
</uix:buildTree>

