<%@ include file="/sdk/oemTop.jspf" %>
<%-- ================  SQL Page =================== 
   MODIFIED    (MM/DD/YY)
      sresrini  03/20/06 - Fix jsp compilation errors
      nachen    01/14/05 - add state,_root,node to keep the state of the table 
      yfeng     08/10/04 - remove beginTimestamp and endTimestamp 
      yfeng     04/17/04 - Fix bug 3576997 - show unformated sql text 
      ychan     02/25/04 - 
      yfeng     10/27/03 - use table layout to display attributes 
      yfeng     10/23/03 - Copy dbUser and pageNum 
      yfeng     10/14/03 - Copy timestamps 
      yfeng     10/04/03 - Fix bug 3174140 
      yfeng     08/11/03 - Reorder the order for the explain plan table 
      yfeng     08/06/03 - Add PPR 
      yfeng     08/04/03 - Modify timestamp 
      yfeng     07/30/03 - Use percent for textInput
      hsu       07/25/03 - change global
      yfeng     06/17/03 - Copy sql_id and planHashValue for  10i
      yfeng     05/01/03 - Display the timestamp under the subtab
      qsong     04/29/03 - Add oemTop.jspf
      yfeng     04/10/03 - Add Execution History tab
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
        <db:form name="tsForm"  destinationBinding="destURI@servletRequest"
                 copyParams="target,type,sqlHash,sqlAddr,childNum,sql_id,planHashValue,dbUser,pageNum,breadCrumb,state,_root,node">

      <uix:pageLayout titleBinding="header@sqlObjectBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>  
                  

            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                 <uix:messagePrompt promptBinding="HDR_SQL_TEXT@DBMsgBundle@servletRequest"
                                    labeledNodeId="ViewLabel" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:textInput name="sqlText" id="ViewLabel"
                                 textBinding="sqlText@sqlObjectBean@servletRequest"
                                 readOnly="true"
                                 columns="120"
                                 rows="10">
                  </uix:textInput>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5"/>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="0">
                    <uix:link textBinding="EXPLAIN_PLAN_HEADER@DBMsgBundle@servletRequest"/>
                    <uix:link textBinding="SQL_STATISTICS@DBMsgBundle@servletRequest"
                              destinationBinding="statDest@servletRequest"/>
                    <uix:link textBinding="EXEC_HISTORY@DBMsgBundle@servletRequest"
                              destinationBinding="execHisDest@servletRequest"/>
                    <uix:link textBinding="sqlAssessRecommTab@sqlObjectBean@servletRequest"
                              destinationBinding="assessDest@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

            <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right">
                   <uix:cellFormat>
                     <uix:rowLayout>
                         <uix:styledText styleClass="OraTipText"
                           textBinding="DATA_RETRIEVED@DBMsgBundle@servletRequest"/>
                         <uix:spacer width="5" />
                         <uix:styledText styleClass="OraTipLabel"
                           textBinding="lastUpdatedTime@sqlObjectBean@servletRequest"/>
                      </uix:rowLayout>
                   </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:spacer height="5"/>

<uix:tableLayout>
  <uix:rowLayout>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="SQL_DATA_SOURCE@DBMsgBundle@servletRequest"/>

    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:switcher childNameBinding="planDataSourceURLForSnapshotExisted@sqlObjectBean@servletRequest">
        <uix:case name="true">
          <uix:link textBinding="planDataSource@sqlObjectBean@servletRequest"
                    destinationBinding="planDataSourceURLForSnapshot@sqlObjectBean@servletRequest"/>
        </uix:case>
        <uix:case name="false">
          <uix:styledText styleClass="OraDataText" 
                          textBinding="planDataSource@sqlObjectBean@servletRequest"/>
        </uix:case>
      </uix:switcher>
    </uix:cellFormat>


    <uix:spacer width="20"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="PLAN_HASH_VALUE@DBMsgBundle@servletRequest"/>
    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraDataText"
                      textBinding="planHashValue@sqlObjectBean@servletRequest"/>
    </uix:cellFormat>

    <uix:spacer width="20"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="MODULE@DBMsgBundle@servletRequest"/>

    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraDataText"
                      textBinding="module@sqlObjectBean@servletRequest"/>
    </uix:cellFormat>
  </uix:rowLayout>

  <uix:rowLayout>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="CAPTURE_TIME@DBMsgBundle@servletRequest"/>
    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraDataText" 
                      textBinding="planCaptureTime@sqlObjectBean@servletRequest"/>
    </uix:cellFormat>

    <uix:spacer width="20"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="SQL_OPT_MODE@DBMsgBundle@servletRequest"/>
    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraDataText"
                      textBinding="optimizerMode@sqlObjectBean@servletRequest"/>
    </uix:cellFormat>

    <uix:spacer width="20"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="ACTION@DBMsgBundle@servletRequest"/>

    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraDataText"
                      textBinding="action@sqlObjectBean@servletRequest"/>
    </uix:cellFormat>
  </uix:rowLayout>

  <uix:rowLayout>
    <uix:cellFormat>
      <uix:styledText styleClass="OraPromptText"
                      textBinding="PARSE_SCHEMA@DBMsgBundle@servletRequest"/>

    </uix:cellFormat>
    <uix:spacer width="4"/>
    <uix:cellFormat>
      <uix:styledText styleClass="OraDataText"
                      textBinding="parsingSchema@sqlObjectBean@servletRequest"/>
    </uix:cellFormat>
    <uix:spacer width="20"/>
    <uix:cellFormat>
    <uix:spacer width="4"/>
    </uix:cellFormat>
    <uix:spacer width="20"/>
    <uix:cellFormat>
    <uix:spacer width="4"/>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>




              

            <uix:spacer height="5"/>

              <uix:hGrid id="explainPlans"
                         width="100%"
                         formSubmitted="true"
                         alternateTextBinding="TABLE_NO_DATA@DBMsgBundle@servletRequest"
                         columnHeaderDataBinding="columnHeaderData@sqlObjectBean@servletRequest"
                         columnFormatsBinding="columnFormatData@sqlObjectBean@servletRequest"
                         treeDataBinding="treeData@sqlObjectBean@servletRequest"
                         proxyBinding="proxy@servletRequest">
               <uix:nodeStamp>
                  <uix:column>
                    <uix:columnFormat width="300"/>
                    <uix:columnHeader>
                      <uix:styledText textBinding="XP_OPERATION@DBMsgBundle@servletRequest"/>
                    </uix:columnHeader>
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:styledText textBinding="text"/>
                </uix:columnHeaderStamp>


                <uix:styledText textBinding="xp_object"
                                destinationBinding="objURL"/>
                <uix:styledText textBinding="xp_object_type"/>
                <uix:styledText textBinding="xp_order"/>
                <uix:styledText textBinding="xp_cadinality"/>
                <uix:styledText textBinding="xp_bytes"/>
                <uix:styledText textBinding="xp_cost"/>
                <uix:styledText textBinding="xp_time"/>
                <uix:styledText textBinding="xp_cpu_cost"/>
                <uix:styledText textBinding="xp_io_cost"/>
                <uix:styledText textBinding="xp_object_node"/>
              </uix:hGrid>

              <uix:spacer height="5"/>
            </uix:subTabLayout>

          <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
               <uix:switcher childNameBinding="sqlTunable@sqlObjectBean@servletRequest">
                <uix:case name="true">
                  <uix:submitButton textBinding="RUN_TUNING_ADVISOR@DBMsgBundle@servletRequest"
                                    name="event"
                                    value="sqlTuning" />
                </uix:case>
               </uix:switcher>
            </uix:case>
           </uix:switcher>
          </uix:pageButtonBar>
          </uix:pageButtons>
          
      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

