<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean
    id="sqlDetailUI"
    scope="request"
    type="oracle.sysman.emo.perf.bean.sql.SQLDetailUI"/>

<uix:buildTree nodeID="sqlMonitor">
  <uix:dataScope>    
  
<uix:subTabLayout>
  <uix:subTabs>
    <uix:subTabBar selectedIndex="6">
      <uix:link textBinding="RESULTS@sqlMsg"
                destinationBinding="resultsDest@servletRequest"
                renderedBinding="renderResultsTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_STATS@sqlMsg"
                destinationBinding="exeDest@servletRequest"/>
      <uix:link textBinding="SESS_ACTIVITY@sqlMsg"
                destinationBinding="actDest@servletRequest"
                renderedBinding="renderSessActTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_PLAN@sqlMsg"
                destinationBinding="plnDest@servletRequest"/>
      <uix:link renderedBinding="isVer11Higher@sqlDetailUI@servletRequest">
      <uix:flowLayout>
      	<uix:styledText styleClass="OraPromptText" textBinding="DETAIL_PLAN_CONTROL@sqlMsg" destinationBinding="plnControlDest@servletRequest"/>
        <uix:image source="/em/images/infoicon_active.gif" id="processIcon" shortDescBinding="DETAIL_PLAN_CONTROL@sqlMsg"
        	renderedBinding="renderIcon@sqlDetailUI@servletRequest" destinationBinding="plnControlDest@servletRequest"/>
      </uix:flowLayout>
      </uix:link>
      <uix:link textBinding="tuningText@servletRequest"
                destinationBinding="tunDest@servletRequest"
                renderedBinding="renderTuningInfoTab@sqlDetailUI@servletRequest"/>
     <uix:switcher childNameBinding="disableMonitor@sqlDetailUI@servletRequest">
        <uix:case name="true">
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                shortDescBinding="NO_MONITOR_INFO@sqlMsg"
                disabled="true"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:case>
        <uix:default>
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:default>
     </uix:switcher>
    </uix:subTabBar>
  </uix:subTabs>

  <uix:stackLayout>
  
  <db:flexRegion
                swfName="/database/flex/sqlmonitor/SqlMonitorList.swf"
                dataSrcKeyBinding="sqlMonitorKey@sqlDetailUI@servletRequest"
                optionsBinding="sqlMonitorParams@sqlDetailUI@servletRequest"
                windowWidth="100%"
                windowHeight="300"
                idBase="flexSqlDetailMonitor" />

  </uix:stackLayout>

</uix:subTabLayout>

  </uix:dataScope>     
</uix:buildTree>
