<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<uix:buildTree nodeID="sqlPlanControl">
  <uix:dataScope currentDataBinding="sqlPlanBaselineUIDS@sqlDetailUI@servletRequest">    
  
<uix:subTabLayout>
  <uix:subTabs>
    <uix:subTabBar selectedIndex="4">
      <uix:link textBinding="RESULTS@sqlMsg"
                destinationBinding="resultsDest@servletRequest"
                renderedBinding="renderResultsTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_STATS@sqlMsg"
                destinationBinding="exeDest@servletRequest"/>
      <uix:link textBinding="SESS_ACTIVITY@sqlMsg"
                destinationBinding="actDest@servletRequest"
                renderedBinding="renderSessActTab@sqlDetailUI@servletRequest"/>
      <uix:link textBinding="EXEC_PLAN@sqlMsg"
                destinationBinding="plnDest@servletRequest"/>
      <uix:link>
      <uix:flowLayout>
      	<uix:styledText styleClass="OraDataText" textBinding="DETAIL_PLAN_CONTROL@sqlMsg"/>
        <uix:image source="/em/images/infoicon_active.gif" id="processIcon" shortDescBinding="DETAIL_PLAN_CONTROL@sqlMsg"
        	renderedBinding="renderIcon@sqlDetailUI@servletRequest"/>
      </uix:flowLayout>
      </uix:link>
      <uix:link textBinding="tuningText@servletRequest" 
      			destinationBinding="tunDest@servletRequest"
			renderedBinding="renderTuningInfoTab@sqlDetailUI@servletRequest"/>
     <uix:switcher childNameBinding="disableMonitor@sqlDetailUI@servletRequest">
        <uix:case name="true">
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                shortDescBinding="NO_MONITOR_INFO@sqlMsg"
                disabled="true"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:case>
        <uix:default>
           <uix:link textBinding="MONITORING@sqlMsg"
                destinationBinding="monitorDest@servletRequest"
                renderedBinding="renderMonitorTab@sqlDetailUI@servletRequest"/>
        </uix:default>
     </uix:switcher>
    </uix:subTabBar>
  </uix:subTabs>

  <uix:stackLayout>

    <uix:header textBinding="PROF_OUTLN@sqlMsg">
    <uix:flowLayout>
      <uix:styledText styleClass="OraPromptText" 
                      textBinding="PROFILE_INSTR@sqlMsg"/>
      <uix:styledText styleClass="OraPromptText" 
                      textBinding="PATCH_INSTR@sqlMsg"/>
    </uix:flowLayout>
      <oem:table name="sqlprofoutlines"
                 summaryBinding="tuningText@servletRequest"
                 beanKey="sqlDetailUI"
                 dataSourceProp="SQLPOtnsTableUIDS"
                 alternateTextBinding="TABLE_NO_DATA@dbMsg"
                 formSubmitted="true"
                 blockSize="10"
                 showAll="yes"

                 width="100%">
       <uix:tableSelection>
           <oem:singleSelection 
                shortDescBinding="SELECT@dbMsg"
                selectedIndexBinding="selectedIndex@SQLPOtnsTableUIDS@sqlDetailUI@servletRequest">
              <uix:submitButton 
                textBinding="CHANGE_CATEGORY@sqlMsg"
                name="event" 
                value="getNewCategory"/>
              <uix:submitButton 
                textBinding="DELETE@dbMsg"
                name="event" 
                value="delete"/>
              <uix:submitButton 
                textBinding="DISABLE_ENABLE@sqlMsg"
                name="event" 
                value="disableEnable"/>
           </oem:singleSelection>
        </uix:tableSelection>
      </oem:table>
    </uix:header>
   
    <uix:header textBinding="OPM_PLN_BASELINE_TAB@sqlMsg">
      <uix:styledText styleClass="OraPromptText" 
                      textBinding="BASELINE_INSTR@sqlMsg"/>
      <uix:table width="100%"
                 formSubmitted="true"
                 id="sqlPlanBaselineUIDS"
                 name="sqlPlanBaselineUIDS"
                 showAll="yes"
                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
             blockSizeBinding="<%=UIXDataSource.S_BLOCK_SIZE_ATTR%>" 
             maxValueBinding="<%=UIXDataSource.S_NUM_ROWS_ATTR%>"
             valueBinding="<%=UIXDataSource.S_START_INDEX_ATTR%>" 
                 
                 alternateTextBinding="TABLE_NO_DATA@dbMsg">
		       <uix:column>
		       <uix:columnHeader>
		        	<uix:sortableHeader textBinding="OPM_NAME@sqlMsg" sortableBinding="sortPlanName"/>
		       </uix:columnHeader>
		        <uix:text textBinding="planName" /> 
		       </uix:column>
		
		       <uix:column>
		       <uix:columnHeader>
		        	<uix:sortableHeader textBinding="OPM_FIX@sqlMsg" sortableBinding="sortFix"/>
		       </uix:columnHeader>
		        <uix:text textBinding="fix" />
		       </uix:column>
		       
		       <uix:column>
		       <uix:columnHeader>
		        	<uix:sortableHeader textBinding="OPM_ACCEPT@sqlMsg" sortableBinding="sortAccept"/>
		       </uix:columnHeader>
		        <uix:text textBinding="accept" />
		       </uix:column>
		       
		       <uix:column>
		       <uix:columnHeader>
		        	<uix:sortableHeader textBinding="OPM_AUTO_PURGE@sqlMsg" sortableBinding="sortApurge"/>
		       </uix:columnHeader>
		        <uix:text textBinding="apurge" />
		       </uix:column>
		       
		       <uix:column>
		       <uix:columnHeader>
		        	<uix:sortableHeader textBinding="ENABLED@sqlMsg" sortableBinding="sortStatus"/>
		       </uix:columnHeader>
		        <uix:text textBinding="status" />
		       </uix:column>
		       
		       <uix:column>
		       <uix:columnHeader>
		        	<uix:sortableHeader textBinding="OPM_CREATED@sqlMsg" sortableBinding="sortCreated"/>
		       </uix:columnHeader>
		        <uix:text textBinding="created" />
		       </uix:column>
		       <uix:tableSelection>
		           <uix:singleSelection 
		                shortDescBinding="SELECT@dbMsg"
		                selectedIndex="0">
		              <uix:submitButton 
		                textBinding="DELETE@dbMsg"
		                name="event" 
		                value="deletePlanBaseline"/>
		              <uix:submitButton 
		                textBinding="DISABLE_ENABLE@sqlMsg"
		                name="event" 
		                value="disableEnablePlanBaseline"/>
		           </uix:singleSelection>
		        </uix:tableSelection>
        </uix:table>
        
    </uix:header>
  </uix:stackLayout>

</uix:subTabLayout>

  </uix:dataScope>     
</uix:buildTree>
