<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Duplicate SQL Report Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>


    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <uix:switcher childNameBinding="stateChange@servletRequest">
          <uix:case name="true">
            <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	          errorTableBinding="msgBox@servletRequest"
                                 destTableBinding="msgUrls@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:case>
        </uix:switcher>

        <uix:form name="tsForm" destination="/console/database/instance/sqlReuse">
          <uix:header textBinding="header@sqlReuseBean@servletRequest" >
          <uix:spacer height="10"/>
            <uix:tableLayout  width="100%">
               <uix:rowLayout>
                  <uix:styledText styleClass="OraInlineInfoText"
                     textBinding="LIB_CACHE_CONTENTION_DESC1@ResourceBundle@servletRequest"/>
               </uix:rowLayout>
               <uix:rowLayout>
                  <uix:styledText styleClass="OraInlineInfoText"
                     textBinding="LIB_CACHE_CONTENTION_DESC2@ResourceBundle@servletRequest"/>
               </uix:rowLayout>
               <uix:rowLayout>
                  <uix:styledText styleClass="OraInlineInfoText"
                     textBinding="LIB_CACHE_CONTENTION_DESC3@ResourceBundle@servletRequest"/>
               </uix:rowLayout>
             </uix:tableLayout>
           <uix:spacer height="5"/>

            <uix:tableLayout  width="100%">
                <uix:rowLayout hAlign="right">
                   <uix:cellFormat>
                     <uix:rowLayout>
                         <uix:styledText styleClass="OraTipText"
                           textBinding="DATA_RETRIEVED@ResourceBundle@servletRequest"/>
                         <uix:spacer width="5" />
                         <uix:styledText styleClass="OraTipLabel"
                           textBinding="collectionTime@sqlReuseBean@servletRequest"/>
                      </uix:rowLayout>
                   </uix:cellFormat>
              </uix:rowLayout>
                  <!-- <include baja:node="sqlReusesInclude"/> -->
                  <uix:stackLayout>
                    <uix:switcher childNameBinding="node@sqlReuseBean@servletRequest">
                      <uix:case name="okNode">
                        <oem:table name="twoDUIDataSource" blockSize="25" beanKey="dataSourceBean"
                          destination="/em/console/database/instance/sqlReuse" formSubmitted="true"
                          dataSourceProp="twoDUIDataSource" width="100%">
                        </oem:table>
                      </uix:case>
                      <uix:case name="emptyNode">
                        <!-- <html:em> -->
                        <uix:styledText textBinding="DUP_SQL_NO_DATA@ResourceBundle@servletRequest"/>
                        <!-- </html:em> -->
                      </uix:case>
                      <!-- Error message -->
                      <uix:case name="errNode">
                        <!-- <include baja:node="errMessage" /> -->
                      </uix:case>
                    </uix:switcher>
                  </uix:stackLayout>
              
            </uix:tableLayout>
          <uix:spacer height="5"/>
          </uix:header>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
