<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Database SQL Reuse Details Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>


    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <uix:switcher childNameBinding="stateChange@servletRequest">
          <uix:case name="true">
            <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	          errorTableBinding="msgBox@servletRequest"
                                 destTableBinding="msgUrls@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:case>
        </uix:switcher>

        <uix:form name="tsForm" destination="/em/console/database/instance/sqlReuseDetails">
          <uix:header textBinding="header@sqlReuseDetailsBean@servletRequest">
          <uix:spacer height="15"/>
          </uix:header>
            <uix:tableLayout  width="100%">
               <uix:rowLayout>
                  <uix:styledText styleClass="OraInlineInfoText"
                     textBinding="DUP_SQL_DETAILS_INSTRUCTION@ResourceBundle@servletRequest"/>
               </uix:rowLayout>
             </uix:tableLayout>
            <uix:spacer height="15"/>

             <uix:tableLayout  width="100%">
               <uix:rowLayout>
               <uix:cellFormat vAlign="top" wrappingDisabled="true">
               <contents>
                   <uix:styledText styleClass="OraPromptText"
                     textBinding="DUP_SQL_SUG_SQL@ResourceBundle@servletRequest" />
               </contents>
               </uix:cellFormat>
               <uix:spacer width="8"/>
                   <uix:styledText styleClass="OraDataText"
                     textBinding="selectedNormSql@sqlReuseDetailsBean@servletRequest" />
               </uix:rowLayout>

               </uix:tableLayout>
                  <!-- <include baja:node="sqlReuseDetailssInclude"/> -->
               <uix:spacer height="15"/>
                  <uix:stackLayout>

                    <uix:switcher childNameBinding="node@sqlReuseDetailsBean@servletRequest">
                      <uix:case name="okNode">
                        <oem:table name="twoDUIDataSource" blockSize="25" beanKey="dataSourceBean"
                          destination="/em/console/database/instance/sqlReuseDetails" formSubmitted="true"
                          dataSourceProp="twoDUIDataSource" width="100%">
                        </oem:table>
                      </uix:case>
                      <uix:case name="emptyNode">
                        <!-- <html:em> -->
                        <uix:styledText textBinding="DUP_SQL_NO_DATA@ResourceBundle@servletRequest"/>
                        <!-- </html:em> -->
                      </uix:case>
                      <!-- Error message -->
                      <uix:case name="errNode">
                        <!-- <include baja:node="errMessage" /> -->
                      </uix:case>
                    </uix:switcher>
                  </uix:stackLayout>
              
          <uix:spacer height="5"/>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
