<%@ include file="/sdk/oemTop.jspf" %>
<%-- ================  SQL Page =================== 
   MODIFIED    (MM/DD/YY)
      nachen    01/08/07 - add timezone
      sresrini  03/20/06 - Fix jsp compilation errors
      yfeng     08/10/04 - remove beginTimestamp and endTimestamp 
      yfeng     04/17/04 - Fix bug 3576997 - show unformated sql text 
      ychan     03/26/04 - Fix bug 3536836 
      ychan     02/25/04  - 
      yfeng     10/30/03  - Show unavailable or not applicable instead of 
      yfeng     10/27/03  - ADA compliant 
      yfeng     10/22/03  - Use number of child cursor for 8i 
      yfeng     10/14/03  - Copy sqlAddr for 8i and 9i 
      yfeng     10/03/03  - Fix bug 3174140 
      yfeng     08/19/03  - Add sql profile status 
      yfeng     08/11/03  - Align Time nodel with sharted pool stat 
      yfeng     08/06/03  - Add PPR 
      yfeng     08/04/03  - Modify timestamp 
      yfeng     07/30/03  - Add plan hash value
      hsu       07/25/03  - change global
      yfeng     07/21/03  - use SQL_PROFILE
      yfeng     04/30/03 -  Display the timestamp under the subtab
      qsong     04/29/03  - Add oemTop.jspf
      yfeng     04/10/03 -  Add Execution History tab
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
        <db:form name="tsForm"  destinationBinding="destURI@servletRequest"
                 copyParams="target,type,sqlHash,sqlAddr,childNum,sql_id,planHashValue,breadCrumb">
      <uix:pageLayout titleBinding="header@sqlObjectBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>  
                  
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                 <uix:messagePrompt promptBinding="HDR_SQL_TEXT@DBMsgBundle@servletRequest"
                                    labeledNodeId="ViewLabel" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left">
                  <uix:textInput name="sqlText" id="ViewLabel"
                                 textBinding="sqlText@sqlObjectBean@servletRequest"
                                 readOnly="true"
                                 columns="120"
                                 rows="10" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5"/>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                    <uix:link textBinding="EXPLAIN_PLAN_HEADER@DBMsgBundle@servletRequest"
                              destinationBinding="explainDest@servletRequest"/>
                    <uix:link textBinding="SQL_STATISTICS@DBMsgBundle@servletRequest"/>
                    <uix:link textBinding="EXEC_HISTORY@DBMsgBundle@servletRequest"
                              destinationBinding="execHisDest@servletRequest"/>
                    <uix:link textBinding="sqlAssessRecommTab@sqlObjectBean@servletRequest"
                              destinationBinding="assessDest@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

            <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right">
                   <uix:cellFormat>
                     <uix:rowLayout>
                         <uix:styledText styleClass="OraTipText"
                           textBinding="DATA_RETRIEVED@DBMsgBundle@servletRequest"/>
                         <uix:spacer width="5" />
                         <uix:styledText styleClass="OraTipLabel"
                           textBinding="lastUpdatedTime@sqlObjectBean@servletRequest"/>
                      </uix:rowLayout>
                   </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:switcher childNameBinding="statisticsExisted@sqlObjectBean@servletRequest">
             <uix:case name="true">
               
             <uix:tableLayout width="100%" cellSpacing="2">
               <uix:rowLayout vAlign="top">
                 <uix:cellFormat vAlign="top" width="50%">

                <%-- ...................  General Section .................. --%>

                  <uix:stackLayout>
                  <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest">
                        <uix:tableLayout hAlign="left">

                    <uix:switcher childNameBinding="8i@sqlObjectBean@servletRequest">
                     <uix:case name="false">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="NUMBER_OF_PLANS@sqlMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="numberOfPlans@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    </uix:case>
                     <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="NUMBER_CHILD_CUROSR@sqlMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="numberOfChildCursors@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    </uix:case>
                   </uix:switcher>

            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="PROGRAM_NAME_LINE_NUM@sqlMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:switcher childNameBinding="programNameAndLineNumberExisted@sqlObjectBean@servletRequest">
                         <uix:case name="true">
                           <uix:link textBinding="programNameAndLineNumber@sqlObjectBean@servletRequest"
                                     destinationBinding="programURL@sqlObjectBean@servletRequest"/>
                         </uix:case>
                         <uix:case name="false">
                           <uix:styledText styleClass="OraDataText"
                               textBinding="programNameAndLineNumber@sqlObjectBean@servletRequest"/>
                         </uix:case>
                       </uix:switcher>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>


            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="SQL_PROFILE@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="false">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="sqlProfile@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>

                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:switcher childNameBinding="sqlProfileFound@sqlObjectBean@servletRequest">
                    <uix:case name="true">
                    <uix:submitButton textBinding="DROP@DBMsgBundle@servletRequest"
                              name="event"
                              value="dropSqlProfile" />
                     </uix:case>
                </uix:switcher>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>

            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="SQL_PROFILE_STATUS@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="false">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="sqlProfileStatus@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>

                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:switcher childNameBinding="sqlProfileStatus@sqlBean@servletRequest">
                    <uix:case name="ENABLED">
                    <uix:submitButton textBinding="DISABLE@DBMsgBundle@servletRequest"
                              name="event"
                              value="disableSqlProfile" />
                     </uix:case>
                    <uix:case name="DISABLED">
                    <uix:submitButton textBinding="ENABLE@DBMsgBundle@servletRequest"
                              name="event"
                              value="enableSqlProfile" />
                     </uix:case>
                </uix:switcher>
                      </uix:cellFormat>
                </uix:rowLayout>
            </uix:case>
           </uix:switcher>

            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="SQL_PROFILE_CATEGORY@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="false">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="sqlProfileCategory@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>

                      <uix:spacer width="8"/>
               
              </uix:rowLayout>
            </uix:case>
           </uix:switcher>
            </uix:tableLayout>



          </uix:header>




         </uix:stackLayout>
         
        </uix:cellFormat>


    <uix:cellFormat vAlign="top" width="50%" >

                <%-- ...................  Execution Statistics  Section .................. --%>

                  <uix:stackLayout>

                  <uix:header textBinding="EXECUTION_STATISTICS@DBMsgBundle@servletRequest">
                        <uix:tableLayout hAlign="left">

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="EXECUTIONS@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="executions@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="TSQL_PARSE_CALLS@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="parseCalls@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="ROWS_PER_FETCH@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="rowsPerFetch@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="ROWS_PER_EXEC@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="rowsPerExec@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="EXEC_PER_PARSE@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="execPerParse@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                  </uix:tableLayout>

          </uix:header>


         </uix:stackLayout>
        </uix:cellFormat>


           </uix:rowLayout>

               <uix:rowLayout vAlign="top">
                 <uix:cellFormat vAlign="top" width="50%">
                  <uix:stackLayout>
                <%-- ...................  Time Model Section .................. --%>

                  <uix:header textBinding="TIME_MODEL@DBMsgBundle@servletRequest">
                        <uix:tableLayout hAlign="left">

            <uix:switcher childNameBinding="8i@sqlObjectBean@servletRequest">
             <uix:case name="false">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="ELAPSED_TIME_PER_EXEC@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="elapsedTimeInSecPerExec@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="DISK_READS@dbMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="diskReads@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>

            <uix:switcher childNameBinding="8i@sqlObjectBean@servletRequest">
             <uix:case name="false">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="CPU_TIME_PER_EXEC@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="cpuTimeInSecPerExec@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="BUFFER_GETS@dbMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="bufferGets@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>

            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="WAIT_RATIO@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="waitRatio@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>
                  </uix:tableLayout>

          </uix:header>
         </uix:stackLayout>
        </uix:cellFormat>


    <uix:cellFormat vAlign="top" width="50%" >
            <%-- ...................  Shared Pool Statistics  Section .................. --%>


                  <uix:header textBinding="SHARED_POOL_STATISTICS@DBMsgBundle@servletRequest">
                        <uix:tableLayout hAlign="left">

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="TSQL_SHARE_MEM@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="sharableMem@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="TSQL_LOADS@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="loads@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

            <uix:switcher childNameBinding="8i@sqlObjectBean@servletRequest">
             <uix:case name="false">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="LAST_LOAD_TIME@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="lastLoadTime@sqlObjectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
            </uix:case>
           </uix:switcher>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText"
                            textBinding="SQL_INVALIDATIONS@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat hAlign="left" wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText"
                          textBinding="invalidations@sqlBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                  </uix:tableLayout>

          </uix:header>
         
        </uix:cellFormat>
           </uix:rowLayout>

      </uix:tableLayout>

               </uix:case>
               <uix:case name="false">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="SQL_STAT_NOT_FOUND@DBMsgBundle@servletRequest" />
                        </uix:case>
                      </uix:switcher>

	<uix:rowLayout>
              <uix:spacer height="5"/>
                </uix:rowLayout>


    </uix:subTabLayout>

          <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:switcher childNameBinding="SWRF@sqlObjectBean@servletRequest">
             <uix:case name="true">
               <uix:switcher childNameBinding="sqlTunable@sqlObjectBean@servletRequest">
                <uix:case name="true">
                  <uix:submitButton textBinding="RUN_TUNING_ADVISOR@DBMsgBundle@servletRequest"
                                    name="event"
                                    value="sqlTuning" />
                </uix:case>
               </uix:switcher>
            </uix:case>
           </uix:switcher>
          </uix:pageButtonBar>
          </uix:pageButtons>
          
      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

