<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <db:form name="tsForm"  destinationBinding="destURI@servletRequest"
                 copyParams="target,type">
          <uix:header textBinding="header@servletRequest" >

            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInlineInfoText"
                          textBinding="lastUpdatedTime@sqlObjectBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>



        <uix:tableLayout cellSpacing="2" width="100%" >
         <uix:cellFormat vAlign="top" width="50%">
          <uix:contents>

          <uix:stackLayout>
               <oem:chart 
                    titleBinding="TSQL_EXEC_GETS@DBMsgBundle@servletRequest"
                    chartType="timeSeriesChart"
                    orientation="vertical"
                    width="350"
                    height="160" 
                    timeGranularity="MINUTE"
                    legendPosition="south"
                    seriesColorsAutomatic="true">
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="bufPerExecChartDS@servletRequest" />
                    <oem:chartColumn
                      displayLabel="Name"
                      sourceIndex="0" 
                      isKey="true" 
                    />
                    <oem:chartColumn
                      displayLabel="Time"
                      sourceIndex="1" 
                      isTimeColumn="true" 
                    />
                    <oem:chartColumn
                      sourceIndex="2"
                    />
                  </uix:contents>
                </oem:chart>
           </uix:stackLayout>
          </uix:contents>
        </uix:cellFormat>

         <uix:cellFormat vAlign="top" width="50%">
          <uix:contents>

          <uix:stackLayout>
               <oem:chart 
                    titleBinding="TSQL_EXEC_READS@DBMsgBundle@servletRequest"
                    chartType="timeSeriesChart"
                    orientation="vertical"
                    width="350"
                    height="160" 
                    timeGranularity="MINUTE"
                    legendPosition="south"
                    seriesColorsAutomatic="true">
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="diskPerExecChartDS@servletRequest" />
                    <oem:chartColumn
                      displayLabel="Name"
                      sourceIndex="0" 
                      isKey="true" 
                    />
                    <oem:chartColumn
                      displayLabel="Time"
                      sourceIndex="1" 
                      isTimeColumn="true" 
                    />
                    <oem:chartColumn
                      sourceIndex="2"
                    />
                  </uix:contents>
                </oem:chart>
           </uix:stackLayout>
          </uix:contents>
        </uix:cellFormat>

              <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
                    <uix:link textBinding="PG_SQL_DETAILS@DBMsgBundle@servletRequest"
                              destinationBinding="explainDest@servletRequest"/>
                  </uix:header>
                </uix:stackLayout>
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:header>            
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

