<%-- ================  SQL Page =================== 
   MODIFIED    (MM/DD/YY)
      yfeng     06/24/05 - Fix ADA violation - add summary for oem:table 
      yfeng     05/26/05 - Add Search section 
      yfeng     05/24/05 - Add required asterisks next to start and end 
                           controls 
      yfeng     02/02/05 - Fix bug 4153246 - get rid of Refresh button 
      yfeng     10/21/04 - Fix bug 3090652 - by removing partialRenderMode in 
                           oem:table and use get
      yfeng     10/08/04 - Fix bug 3928682 - providing event name
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>                

    <db:form name="foo" 
             destination="/console/database/instance/topSqls"
             copyParams="target,type,refreshChoice">
    <uix:formValue name="pageName" value="/database/instance/sql/topSqlHistCust" />
    <uix:formValue name="event" />
    
    <uix:header textBinding="header@topSqlHistCustBean@topSqlsBean@servletRequest">

    <uix:header textBinding="SEARCH@sqlMsg">

    <uix:header textBinding="SELECT_REPORT_TIMES@dbMsg" >
 
    <uix:cellFormat width="50%" >
      <uix:tableLayout cellSpacing="2" >
        <uix:cellFormat hAlign="left" vAlign="top" columnSpan="2"> 
          <uix:messageDateField name="startDate" id="startDate" required="yes"  labeledNodeId="startDate" 
           columns="15" valueBinding="startDate@topSqlHistCustBean@topSqlsBean@servletRequest"
           tipBinding="exampleDate@topSqlHistCustBean@topSqlsBean@servletRequest"
           promptBinding="START_DATE@SDKBundle@servletRequest" 
           maxValueBinding="currentDate@topSqlHistCustBean@topSqlsBean@servletRequest" >
            <uix:onSubmitValidater>
              <uix:date dateStyle="short"/>
            </uix:onSubmitValidater>
          </uix:messageDateField>
        </uix:cellFormat>

     <uix:rowLayout>
      <uix:messagePrompt promptBinding="START_TIME@SDKBundle@servletRequest"  required="yes"  labeledNodeId="startTimeHour" />
      <uix:cellFormat hAlign="left" vAlign="top"> 
      <uix:spacer width="5" />
  	  <oem:choice
		     name="startTimeHour" id="startTimeHour"
         shortDescBinding="START_TIME@SDKBundle@servletRequest"
		     optionsBinding="hoursListSource@topSqlHistCustBean@topSqlsBean@servletRequest" 
		     selectedValueBinding="startTimeHour@topSqlHistCustBean@topSqlsBean@servletRequest" />
		  <oem:choice
		     name="startTimeMinute"
         shortDescBinding="START_TIME@SDKBundle@servletRequest"
		     optionsBinding="minutesListSource@topSqlHistCustBean@topSqlsBean@servletRequest" 
		     selectedValueBinding="startTimeMinute@topSqlHistCustBean@topSqlsBean@servletRequest" />
        <oem:radioButton name="startTimeAmPm" value="am"
                           selectedValueBinding="startTimeAmPm@topSqlHistCustBean@topSqlsBean@servletRequest"
                           textBinding="AM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
        <oem:radioButton name="startTimeAmPm" value="pm"
                           selectedValueBinding="startTimeAmPm@topSqlHistCustBean@topSqlsBean@servletRequest"
                           textBinding="PM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
</uix:cellFormat>
   </uix:rowLayout>
  </uix:tableLayout>
  </uix:cellFormat> 
  <uix:cellFormat width="50%" >
    <uix:tableLayout cellSpacing="2" >
      <uix:cellFormat hAlign="left" vAlign="top" columnSpan="2"> 
        <uix:messageDateField name="endDate" id="endDate"  required="yes"  labeledNodeId="endDate"
         columns="15" valueBinding="endDate@topSqlHistCustBean@topSqlsBean@servletRequest"
         tipBinding="exampleDate@topSqlHistCustBean@topSqlsBean@servletRequest"
         promptBinding="END_DATE@SDKBundle@servletRequest" 
         maxValueBinding="currentDate@topSqlHistCustBean@topSqlsBean@servletRequest" >
          <uix:onSubmitValidater>
            <uix:date dateStyle="short"/>
          </uix:onSubmitValidater>
        </uix:messageDateField>
      </uix:cellFormat>
          
     <uix:rowLayout>
      <uix:messagePrompt promptBinding="END_TIME@SDKBundle@servletRequest" required="yes"  labeledNodeId="endTimeHour" />
      <uix:cellFormat hAlign="left" vAlign="top"> 
      <uix:spacer width="5" />
		  <oem:choice
		     name="endTimeHour" id="endTimeHour"
         shortDescBinding="END_TIME@SDKBundle@servletRequest"
		     optionsBinding="hoursListSource@topSqlHistCustBean@topSqlsBean@servletRequest" 
		     selectedValueBinding="endTimeHour@topSqlHistCustBean@topSqlsBean@servletRequest" />
		  <oem:choice
		     name="endTimeMinute"
         shortDescBinding="END_TIME@SDKBundle@servletRequest"
		     optionsBinding="minutesListSource@topSqlHistCustBean@topSqlsBean@servletRequest" 
		     selectedValueBinding="endTimeMinute@topSqlHistCustBean@topSqlsBean@servletRequest" />

        <oem:radioButton name="endTimeAmPm" value="am"
                           selectedValueBinding="endTimeAmPm@topSqlHistCustBean@topSqlsBean@servletRequest"
                           textBinding="AM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
        <oem:radioButton name="endTimeAmPm" value="pm"
                           selectedValueBinding="endTimeAmPm@topSqlHistCustBean@topSqlsBean@servletRequest"
                           textBinding="PM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
      </uix:cellFormat>
   </uix:rowLayout>
  </uix:tableLayout>
  </uix:cellFormat>

      </uix:header>

    <uix:header textBinding="FILTER_CONDITION@sqlMsg" >
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="moduleInput" 
                            promptBinding="TSQL_MODULE@dbMsg" />
        </uix:cellFormat>
           <uix:textInput id="moduleInput" name="module"
            textBinding="module@topSqlHistCustBean@topSqlsBean@servletRequest" />
     </uix:labeledFieldLayout>
    </uix:header>

      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="left" vAlign="top" width="100%">
          <uix:submitButton textBinding="GO@sqlMsg" 
            name="event" value="generateTopSqlReport"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:header>
    
    <uix:separator />

    <uix:switcher childNameBinding="showReport@topSqlHistCustBean@topSqlsBean@servletRequest">
      <uix:case name="true">
    <uix:header textBinding="RESULT_LABEL@dbMsg" >

    <uix:tableLayout width="100%" hAlign="left" >
      <uix:rowLayout>
      <uix:cellFormat hAlign="left" > 
        <uix:styledText styleClass="OraPromptText"
                        textBinding="START_TIME@sqlMsg"/>
        <uix:spacer width="8"/>
        <uix:styledText styleClass="OraDataText"
                        textBinding="beginSnapshotTime@topSqlHistCustBean@topSqlsBean@servletRequest"/>
  </uix:cellFormat>  
      <uix:cellFormat hAlign="left" > 
        <uix:styledText styleClass="OraPromptText" textBinding="END_TIME@sqlMsg"/>
        <uix:spacer width="8"/>
        <uix:styledText styleClass="OraDataText" 
                        textBinding="endSnapshotTime@topSqlHistCustBean@topSqlsBean@servletRequest"/>  </uix:cellFormat>  
   </uix:rowLayout>
  </uix:tableLayout>
    
      <uix:labeledFieldLayout columns="2">
        <uix:styledText styleClass="OraPromptText"
                        textBinding="START_TIME@sqlMsg"/>
        <uix:styledText styleClass="OraDataText"
                        textBinding="beginSnapshotTime@topSqlHistCustBean@topSqlsBean@servletRequest"/>
        <uix:styledText styleClass="OraPromptText" textBinding="END_TIME@sqlMsg"/>
        <uix:styledText styleClass="OraDataText" 
                        textBinding="endSnapshotTime@topSqlHistCustBean@topSqlsBean@servletRequest"/>
      </uix:labeledFieldLayout>
    
      <oem:table name="twoDUIDataSource"
                  summaryBinding="header@topSqlHistCustBean@topSqlsBean@servletRequest"
                  id="theTopSqlTable"
                  blockSize="25"
                  beanKey="dataSourceBean"
                  formSubmitted="true"
                  dataSourceProp="twoDUIDataSource"
                  alternateTextBinding="TABLE_NO_DATA@dbMsg"
                  showAll="yes"
                  width="100%">
      </oem:table>
    </uix:header>
      </uix:case>
    </uix:switcher>
    </uix:header>
    
    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

