<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Top SQL Report Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>  
    <%@ include file="/oemTitle.jspf" %>  
    
    
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %> 
    
        <db:form name="tsForm" destination="/console/database/instance/topSqlReport"
                 copyParams="target,type">
          <uix:header textBinding="header@topSqlReportBean@servletRequest" >     
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:rowLayout>
                      <uix:styledText styleClass="OraInlineInfoText" 
                        textBinding="timeIntervalDesc@topSqlReportBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5"/>
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="pageDesc@topSqlReportBean@servletRequest" />
            <uix:spacer height="10"/>

            <uix:tableLayout  width="100%">          
              <uix:rowLayout>            
                  <uix:stackLayout>                
                    <uix:switcher childNameBinding="node@topSqlReportBean@servletRequest">                  
                      <uix:case name="okNode">                    
                        <oem:table name="twoDUIDataSource" 
                                   summaryBinding="header@topSqlReportBean@servletRequest"
                                   blockSize="25" 
                                   beanKey="dataSourceBean" 
                                   destination="/console/database/instance/topSqlReport" 
                                   formSubmitted="true"                        
                                   dataSourceProp="twoDUIDataSource" 
                                   width="100%">                    
                        </oem:table>                  
                      </uix:case>                  
                      <uix:case name="emptyNode">                    
                        <!-- <html:em> -->                    
                        <uix:styledText textBinding="noData@topSqlReportBean@servletRequest"/>                    
                        <!-- </html:em> -->                  
                      </uix:case>                  
                      <!-- Error message -->                  
                      <uix:case name="errNode">                    
                        <!-- <include baja:node="errMessage" /> -->                  
                      </uix:case>                
                    </uix:switcher>              
                  </uix:stackLayout>            
              </uix:rowLayout>        

              <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RELATED_LINKS@ResourceBundle@servletRequest">
                    <uix:link textBinding="VIEW_TOP_SQL@ResourceBundle@servletRequest"
                             destinationBinding="topSqlUrl@servletRequest"/>
                  </uix:header>
                </uix:stackLayout>
              </uix:rowLayout>

            </uix:tableLayout>
          </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
