<%-- ================   Database Top Sqls Page for pre-1og  =================

   MODIFIED    (MM/DD/YY)
      yma       03/09/07 -  remove yAxisWidth attribute in chart
      sresrini  03/20/06 - Fix jsp compilation errors
      yfeng     06/24/05 - Fix ADA violation - add summary for oem:table 
      yma       07/05/05 -  bug 4292160 - add instance switch for 9i RAC 
      yfeng     05/26/05 - Support show all 
      yfeng     02/02/05 - Fix bug 4155126 - get rid of Generate Top SQL 
                           Report button 
      swexler   10/29/04 - 
      yfeng     10/21/04 - Fix bug 3090652 - by removing partialRenderMode in 
                           oem:table 
      yfeng     10/15/04 - Show no data when the table is empty
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
            
<script>
 function scroll_timechart(direction)
 {
   if (direction == 'prev'){
     document.foo.direction.value = '1';
   }
   else{
     document.foo.direction.value = '2';
   }
   submitForm('foo', true, {'event':'scrollChart'});
 }

  function my_goto_band(selIdx, startMS, endMS)
  {
    submitForm('foo', true, {'event':'sliderChanged','t1':startMS,'t2':endMS});
  }  
</script>

  <uix:document>

  <uix:metaContainer>
    <db:script src="/database/utils.js"/>
  </uix:metaContainer>
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>


    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="warning"
			      errorTableBinding="intervalWarning@servletRequest"
                  mainTextKey="exceptionText"/>

        <oem:messageBox messageType="error"
			      errorTableBinding="intervalError@servletRequest"
			      mainTextKey="exceptionText"/>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>  

        <db:form name="foo" destination="/console/database/instance/topSqls"
                 copyParams="target,type">
          <uix:formValue name="t1" value=""/>
          <uix:formValue name="t2" value=""/>
          <uix:formValue name="direction" value=""/>

        <uix:switcher childNameBinding="isSWRF@servletRequest">
          <uix:case name="false">
        <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
                <uix:flowLayout>
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="VIEW_DATA_LABEL@ResourceBundle@servletRequest" 
                                    labeledNodeId="ViewLabel" />
                    <uix:choice name="refreshChoice" id="ViewLabel"
                        selectedIndexBinding="refreshChoice@servletRequest"
                        onChange="submitForm('foo', true, {'event':'updateView'})">
                        <uix:option textBinding="REAL_TIME_MANUAL@ResourceBundle@servletRequest"
                            value="0"  />
                        <uix:option textBinding="HISTORICAL@ResourceBundle@servletRequest"
                            value="1"  />
                    </uix:choice>
                </uix:flowLayout>
            </uix:rowLayout>
        </uix:tableLayout>
        </uix:case>
      </uix:switcher>

          <uix:header textBinding="TOP_SQL_HEADER@ResourceBundle@servletRequest" >
<%@ include file="/database/instances.jspf" %>       
     <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
               <uix:cellFormat>
                <uix:rowLayout>
                <uix:styledText styleClass="OraTipText"
                  textBinding="fromText@servletRequest"/>
                  <uix:spacer width="5" />
                  <uix:styledText styleClass="OraTipLabel"
                  textBinding="fromDate@servletRequest"/>
                  <uix:spacer width="5" />
                  <uix:styledText styleClass="OraTipText"
                  textBinding="toText@servletRequest"/>
                  <uix:spacer width="5" />
                  <uix:styledText styleClass="OraTipLabel"
                  textBinding="toDate@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:switcher childNameBinding="refreshChoice@servletRequest">
                    <uix:case name="0">
                        <uix:image sourceBinding="refreshImage@servletRequest"
                            destinationBinding="refreshDest@servletRequest" />
                     </uix:case>
                </uix:switcher>
                </uix:rowLayout>
               </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout  width="100%">
            <uix:rowLayout hAlign="right" >
              <uix:pageButtonBar>
                <contents>
                  <uix:submitButton textBinding="TOP_SQL_ASSESS@ResourceBundle@servletRequest"
                            name="event"
                            value="sqlAssessment" />
                </contents>
              </uix:pageButtonBar>
            </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout  width="100%">            
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                    <uix:styledText styleClass="OraInlineInfoText"
                          textBinding="LONG_ASSESS_INFO@ResourceBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
            </uix:tableLayout> 


            <uix:switcher childNameBinding="refreshChoice@servletRequest">
              <uix:case name="1">
              <uix:switcher childNameBinding="intervalLessThan1Day@waitsBean@servletRequest">
              <uix:case name="false">
              <uix:stackLayout>
              <uix:header size="1"
                textBinding="HIST_INTERVAL_SELECTION@ResourceBundle@servletRequest" />
                <uix:switcher childNameBinding="useSVG@topSqlsBean@servletRequest">
                <uix:case name="true">
                  <uix:tableLayout>
                    <uix:rowLayout hAlign="left">
                      <uix:messagePrompt promptBinding="HIST_PICKER_INSTR_1DAY@DBMsgBundle@servletRequest" />
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:case>
                <uix:case name="false">
                  <uix:tableLayout>
                    <uix:rowLayout hAlign="left">
                      <uix:messagePrompt promptBinding="TIME_BAND_24HOUR_INSTR@DBMsgBundle@servletRequest" />
                    </uix:rowLayout>
                  </uix:tableLayout> 
                </uix:case>
                </uix:switcher>
                
              
              </uix:stackLayout>
              </uix:case>
              </uix:switcher>
              </uix:case>
            </uix:switcher>


            <uix:switcher childNameBinding="refreshChoice@servletRequest">
              <uix:case name="1">
               <uix:switcher childNameBinding="showData@topSqlsBean@servletRequest">
                <uix:case name="true">              
               <oem:chart 
                    chartType="timeSeriesChart"
                    width="850"
                    height="200"
                    timeGranularity="SECOND" 
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"  
                    legendPosition="east"
                    legendVisible="true"
                    titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    seriesColorsAutomatic="true"
                    format="svg"
                    xAxisMinBinding="beginDate@waitsBean@servletRequest"
                    xAxisMaxBinding="endDate@waitsBean@servletRequest"
                    colorPaletteBinding="nonStaticPickerColors@waitsChart@waitsBean@servletRequest"
                    axisMaxBinding="maxValue@waitsBean@servletRequest"
                    svgHighlightLegend="true"
                  >
                  <uix:contents>
                    <oem:timeSelector
                      xAxisMinBinding="beginDate@waitsBean@servletRequest"
                      xAxisMaxBinding="endDate@waitsBean@servletRequest"
                      intervalTimeSecBinding="intervalTimeSec@servletRequest"
                      height="20"
                      selectedMaxDateBinding="selectedMaxDate@servletRequest"
                      selectedMinDateBinding="selectedMinDate@servletRequest"
                      numBandsSelectedBinding="numBandsSelected@servletRequest"
                      selectionDest="my_goto_band"
                      selectionDestType="JavaScript"
                      selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
                      position="south"
                      dynamicTimeSelector="true"
                      xAxisScrollDest="scroll_timechart"
                      xAxisScrollDestType="JavaScript"
                      xAxisScrollPrev="true"
                      xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
                      xAxisScrollNext="true"
                      xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
                      selectionIndicator="shading"
                      dynamicTimeSelectorColorBinding="sliderColor@waitsChart@waitsBean@servletRequest"
                      dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitsChart@waitsBean@servletRequest"
                    >
                    </oem:timeSelector>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="chartDataSource@waitsBean@servletRequest"/>               
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
               </uix:case>
            </uix:switcher>
          </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="refreshChoice@servletRequest">
          <uix:case name="1">
          <uix:switcher childNameBinding="intervalLessThan1Day@waitsBean@servletRequest">
          <uix:case name="false">
          <uix:stackLayout>
              <uix:header size="1"
                textBinding="HIST_24HOUR_DETAIL_HDR@DBMsgBundle@servletRequest"/>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:spacer width="8"/>
                <uix:styledText styleClass="OraPromptText"
                    textBinding="SPOT_SQL_DETAIL_TEXT@DBMsgBundle@servletRequest"/>
                <uix:spacer width="8"/>
                <uix:styledText styleClass="OraDataText"
                  textBinding="beginSnapshotTime@topSqlsBean@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            </uix:stackLayout>
            </uix:case>
            </uix:switcher>
            </uix:case>
          </uix:switcher>

            <uix:tableLayout  width="100%">
              <uix:rowLayout>
                  <uix:stackLayout>

                        <oem:table name="twoDUIDataSource"
                                   summaryBinding="TOP_SQL_HEADER@ResourceBundle@servletRequest"
                                   id="theTopSqlTable"
                                   blockSize="25"
                                   beanKey="topSqlsBean"
                                   formSubmitted="true"
                                   dataSourceProp="twoDUIDataSource"
                                   alternateTextBinding="TABLE_NO_DATA@dbMsg"
                                   showAll="yes"
                                   width="100%">
                          <uix:tableSelection>
              <uix:switcher childNameBinding="isSWRF@servletRequest">
                <uix:case name="false">
                             <oem:singleSelection 
                                  shortDescBinding="SELECT@ResourceBundle@servletRequest"
                                  selectedIndexBinding="selectedIndex@topSqlsBean@servletRequest">
                                <uix:submitButton 
                                  textBinding="VIEW_DETAIL@ResourceBundle@servletRequest"
                                  name="event" 
                                  value="viewDetail"/>
                             </oem:singleSelection>

                </uix:case>
                <uix:case name="true">
                            <uix:multipleSelection
                              selectedBinding="selected"
                              shortDescBinding="SELECT@ResourceBundle@servletRequest"
                              selectionBinding="selection@topSqlsBean@servletRequest"
                              >
                              <uix:submitButton
                                textBinding="SQL_TUNING_ADVISOR@ResourceBundle@servletRequest"
                                name="event"
                                value="sqlTuning"
                              />
                              <uix:submitButton
                                textBinding="CREATE_STS@ResourceBundle@servletRequest"
                                name="event"
                                value="createSTS"
                              />
                             </uix:multipleSelection>
              </uix:case>
            </uix:switcher>
                          </uix:tableSelection>
                        </oem:table>



                  </uix:stackLayout>
                
              </uix:rowLayout>
            </uix:tableLayout>

                <uix:spacer width="8"/>
                
            <uix:tableLayout  width="100%">
            <uix:rowLayout hAlign="right" >
              <uix:pageButtonBar>
                <contents>
                  <uix:submitButton textBinding="TOP_SQL_ASSESS@ResourceBundle@servletRequest"
                            name="event"
                            value="sqlAssessment" />
                </contents>
              </uix:pageButtonBar>
            </uix:rowLayout>
            </uix:tableLayout>

</uix:header>
          <uix:spacer height="15" />

          <%@ include file="/database/instance/monitoringLinks.jspf" %>

        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
