function getSelectionInfoInSQLTextArea()
{  
	var txtarea = document.getElementById("text_area");
  txtarea.focus();
  
	if (txtarea.selectionStart >= 0)
	{ // Mozilla
        document.forms[0].browserType.value = 'Mozilla';
	var selStart = txtarea.selectionStart;
	var selEnd = txtarea.selectionEnd;
  if (selStart != selEnd)
  {
      while(isNewLine(txtarea.value.charAt(selStart)))
          selStart++; 
      while((selEnd-1 >= 0) && isNewLine(txtarea.value.charAt(selEnd-1)))
          selEnd--;
    document.forms[0].selectedSQLText.value = (txtarea.value).substring(selStart, selEnd);        
    document.forms[0].selectionStart.value = selStart;
    document.forms[0].selectionEnd.value = selEnd;
  }
  else
  { 
    document.forms[0].selectedSQLText.value = getSelectedSQLText(txtarea.value, selStart);    
    if (isNewLine(txtarea.value.charAt(document.forms[0].selectionEnd.value-1)))
        document.forms[0].selectionEnd.value--;
  }

  document.forms[0].textBeforeSelectedSQLText.value = (txtarea.value).substring(0, document.forms[0].selectionStart.value);
  document.forms[0].textAfterSelectedSQLText.value = (txtarea.value).substring( document.forms[0].selectionEnd.value, txtarea.value.length);              

  document.forms[0].scrollPos.value = txtarea.scrollTop;  
  
  return;
	}

	if( document.selection  || document.getSelection())
  { // IE
        document.forms[0].browserType.value = 'IE';
  if (document.selection)
    range = document.selection.createRange();
  else
    range = document.getSelection().createRange();
	var stored_range = range.duplicate();
	stored_range.moveToElementText( txtarea );
	stored_range.setEndPoint( 'EndToEnd', range );
  var selStart = stored_range.text.length - range.text.length;
	var selEnd = selStart + range.text.length;
  if (selStart != selEnd)
  {
      while(isNewLine(txtarea.value.charAt(selStart)))
          selStart++; 
      while((selEnd-1 >= 0) && isNewLine(txtarea.value.charAt(selEnd-1)))
          selEnd--;
    document.forms[0].selectedSQLText.value = (txtarea.value).substring(selStart, selEnd);
    document.forms[0].selectionStart.value = selStart;
    if (isNewLine(txtarea.value.charAt(selEnd-1)))
        document.forms[0].selectionEnd.value = selEnd; 
    else
        document.forms[0].selectionEnd.value = selEnd+1;
  }
  else
  {
    document.forms[0].selectedSQLText.value = getSelectedSQLText(txtarea.value, selStart);
    if (isNewLine(txtarea.value.charAt(document.forms[0].selectionEnd.value-1)))
        document.forms[0].selectionEnd.value--;
    else
        document.forms[0].selectionEnd.value++;
  }    

  document.forms[0].textBeforeSelectedSQLText.value = (txtarea.value).substring(0, document.forms[0].selectionStart.value);
  document.forms[0].textAfterSelectedSQLText.value = (txtarea.value).substring((document.forms[0].selectionEnd).value-1, (txtarea.value).length);              

  document.forms[0].fullTextLength.value = (txtarea.value).length;
  document.forms[0].scrollPos.value = txtarea.scrollTop;  
  
  return;
	}

  return;
}

function isWhite(c)
{
    return ((c == '\t') || (c == ' ') || (c == '\n') || (c == '\r'));    
}

function isNewLine(c)
{
    return ((c == '\n') || (c == '\r'));    
}

function trim(s) 
{
    var i, j = s.length;

    for (i = 0; isWhite(s.charAt(i)) && (i < j); i++)
        ;
    if (i == j) 
    {
      return ""; //whole string is white
    }
    for (; isWhite(s.charAt(j-1)); j--)
        ;
    return s.substring(i, j);
}

function getSelectedSQLText(str, ind)
{    
  var index = ind;  

  while (isWhite(str.charAt(index)) && (index-1) >= 0)
  {
    if (str.charAt(index-1) == '\n' || str.charAt(index-1) == '\r')
    {
      break;
    }    
    index--;
  }  
  
  if (trim(str.substring(0, index)).length == 0)
    index = ind;
  while (isWhite(str.charAt(index)) && (index+1) < str.length)
  {
    index++;
  }

  var sqlStart = -1;
  var sqlEnd = -1;
  // search for start index
  var prev = str.lastIndexOf('\n', index);
  if (prev == -1)
    prev = str.lastIndexOf('\r', index);
  var curr = str.lastIndexOf('\n', prev-1);
  if (curr == -1)
    curr = str.lastIndexOf('\r', prev-1);  
  
  if (prev < 0 || curr < 0)
  {
    sqlStart = 0;
  }
  else
  {       
    while (curr >= 0 && trim(str.substring(curr, prev)).length > 0)
    {     
      prev = curr;            
      curr = str.lastIndexOf('\n', curr-1);
      if (curr == -1)
        curr = str.lastIndexOf('\r', curr-1);
    }
    if (curr < 0)
    {
      sqlStart = 0;
    }
    else if (str.lastIndexOf('\n', prev-1) < 0)
    {
      sqlStart = 0;
    }
    else
    {
      sqlStart = prev+1;
    }
  }
  // search for end index
  prev = str.indexOf('\n', index);
  if (prev == -1)
    prev = str.indexOf('\r', index);
  curr = str.indexOf('\n', prev+1);
  if (curr == -1)
    curr = str.indexOf('\r', prev+1);
  
  if (prev < 0 || curr < 0)
  {
    sqlEnd = str.length-1;
  }
  else
  {
    while (curr >= 0 && trim(str.substring(prev, curr)).length > 0)
    {
      prev = curr;
      curr = str.indexOf('\n', curr+1);
      if (curr == -1)
        curr = str.indexOf('\r', curr+1);        
    }
    if (curr < 0)
    {
      sqlEnd = str.length-1;
    }
    else
    {
      sqlEnd = curr-1;
    }
  }

  var sql = str.substring(sqlStart, sqlEnd+1);

  var i, j = sql.length;
  for (i = 0; isWhite(sql.charAt(i)) && (i < j); i++)
  {
      sqlStart++; 
  }

  if (i == j) 
  {
      sql = ""; //whole string is white
  } 
  
  for (; isWhite(sql.charAt(j-1)); j--)
  {
      sqlEnd--;
  }

  document.forms[0].selectionStart.value = sqlStart;
  document.forms[0].selectionEnd.value = sqlEnd+1;

  return sql;
}

function onEvent(eventName)
{
  var txtarea = document.getElementById("text_area");
  if (eventName == 'cancelExecution' && txtarea.selectionStart >= 0) // Mozilla
    window.stop();    
    
  if (eventName == 'executeSelectedSQL')
  {      
    var executeBtn = document.getElementById("executeBtn");
    if (executeBtn != null)
    {
      executeBtn.style.display = 'none';
    }
    
    var processIcon = document.getElementById("processIcon");
    if (processIcon != null)
    {
      processIcon.style.display = 'block';
    }
    
    var cancelBtn = document.getElementById("cancelBtn");
    if (cancelBtn != null)
    {
      cancelBtn.style.display = 'block';
    }
  }
  
  getSelectionInfoInSQLTextArea();
	document.forms[0].event.value = eventName; 
	document.forms[0].submit();	 

    setTimeout('document.getElementById("processIcon").src = "/em/images/process_animation.gif"', 20); 
} 

function openURLInOpener(url)
{
    if (opener != null && !opener.closed)
    {
      opener.document.location = url;
      opener.focus();
    }
    else
    {
      opener = window.open(url, '');
      opener.focus();
    }
}

function submitFormAndSwitchTab(pageNum)
{
  getSelectionInfoInSQLTextArea();
  document.forms[0].event.value = 'switchTab';
  document.forms[0].toPageNum.value = pageNum;
  document.forms[0].submit();
}

function onLoad(selectionStart, selectionEnd, originalLength, scrollPos)
{  
  var processIcon = document.getElementById("processIcon");
  if (processIcon != null)
  {
    processIcon.style.display = 'none';
  }
  
  var cancelBtn = document.getElementById("cancelBtn");
  if (cancelBtn != null)
  {
    cancelBtn.style.display = 'none';
  }
  var executeBtn = document.getElementById("executeBtn");
  if (executeBtn != null)
  {
    executeBtn.style.display = 'block';
  }
  
  var txtarea = document.getElementById("text_area");
  if (txtarea.selectionStart >= 0)
  { // Mozilla
    txtarea.focus();
    txtarea.selectionStart = selectionStart;
    txtarea.selectionEnd = selectionEnd;
    txtarea.scrollTop = scrollPos;
  }
  else
  { // IE
    var oRange = txtarea.createTextRange();
    var txt = txtarea.value;
    oRange.moveStart("character", calculateStart(txt, selectionStart));
    oRange.moveEnd("character", -txtarea.value.length + calculateEnd(txt, selectionEnd));      

    oRange.select();   
    txtarea.scrollTop = scrollPos;
  }      
}

function calculateStart(str, selectionStart)
{
  var temp = selectionStart;
  for (var i = 0; i < selectionStart; i++)
  {
    if (str.charAt(i) == '\n' && str.charAt(i-1) == '\r')
      temp--;
    if (i > str.length)
      break;
  }
  return temp;
}

function calculateEnd(str, selectionEnd)
{
  var temp = selectionEnd;  
  
  for (var i = str.length-1; i >= selectionEnd; i--)
  {
    if (str.charAt(i) == '\n' && str.charAt(i-1) == '\r')
      temp++;
    if (i < 0)
      break;
  }

  return temp;
}
 
