<%@ include file="/sdk/oemTop.jspf" %> 
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/instance/sql/worksheet.js"/>

<jsp:useBean
    id="sqlDetailUI"
    scope="request"
    type="oracle.sysman.emo.perf.bean.sql.SQLDetailUI"/> 
            
<uix:renderingContext id="renderingContext"> 
 <oem:setURLEncoder id="renderingContext"/>     
       
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="topConsumersMsg"
            class="oracle.sysman.db.rsc.inst.TopConsumersMsg"/>
<uix:bundle name="DBObjectMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="mvMsgs" class="oracle.sysman.db.rsc.schm.MViewMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %> 
    <%@ include file="/oemTitle.jspf" %>

    <uix:rowLayout width="100%">
      <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="bottom">
          <uix:globalButtonBar>
            <uix:contents childDataBinding=
              "oracle_sysman_emSDK_eml_nav_GlobalButtons@servletRequest">
              <uix:globalButton textBinding="text" destinationBinding="destination" renderedBinding="rendered" selectedBinding="selected"/>
            </uix:contents>
         </uix:globalButtonBar>
       </uix:cellFormat>
     </uix:rowLayout>

    <uix:body onLoadBinding="onLoad@sqlDetailUI@servletRequest">
     
    <db:form name="sqlForm" method="POST" destination="/console/database/instance/sqlWorksheet"
      copyParams="target,type,sql_id,planHashValue,childNumber,pageNum" onSubmit="javascript:getSelectionInfoInSQLTextArea()">
    <uix:pageLayout titleBinding="header@sqlDetailUI@servletRequest" >    
    <%@ include file="/oemLicense.jspf" %>
    <%@ include file="/database/instances.jspf" %>				   

<uix:location>
  <uix:tableLayout width="100%">
    <uix:rowLayout width="100%"> 
      <uix:cellFormat wrappingDisabled="true" hAlign="right"
                      vAlign="bottom">
        <uix:spacer width="5"/>
        <uix:styledText styleClass="OraTipText" 
                        textBinding="loggedInAsLabel@servletRequest"
                        renderedBinding="loggedInUserNameAvailable@servletRequest"/>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
</uix:location>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>  
    <oem:messageBox messageType="warning"
                        errorTableBinding="intervalWarning@servletRequest"
                        mainTextKey="exceptionText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="intervalError@servletRequest"
                        mainTextKey="exceptionText"/>
                        
    
    <uix:formValue name="event" value="doLoad" /> 
    <uix:formValue name="selectionStart" value="0" />
    <uix:formValue name="selectionEnd" value="0" />
    <uix:formValue name="scrollPos" value="0" />
    <uix:formValue name="fullTextLength" value="0" />
    <uix:formValue name="selectedSQLText" value="" />
    <uix:formValue name="textBeforeSelectedSQLText" value="" /> 
    <uix:formValue name="textAfterSelectedSQLText" value="" />
    <uix:formValue name="browserType" value="Mozilla" />
    <uix:formValue name="toPageNum" value="1" />      
  
    <uix:styledText styleClass="OraInstructionText" textBinding="SQL_WORKSHEET_INSTRUCTION@sqlMsg"/>

    <uix:tableLayout cellSpacing="10" width="90%">
    <uix:rowLayout>
    
    <uix:cellFormat vAlign="top">
    <uix:header textBinding="SQL_COMMANDS@sqlMsg"> 
    <uix:textInput shortDescBinding="SQL_COMMANDS@sqlMsg" name="SQLTextInTextBox" textBinding="SQLTextInTextBox@sqlWorksheetBean@servletRequest" 
        columns="70" rows="10" id="text_area" /> 
    </uix:header>  
    </uix:cellFormat>
    
    <uix:cellFormat vAlign="center" hAlign="left">
    <uix:messageCheckBox id="useBindingVariable" name="useBindingVariable" textBinding="USE_BINDING_VARIABLES@sqlMsg" shortDescBinding="USE_BINDING_VARIABLES@sqlMsg"
                         checkedBinding="useBindingVariable@sqlDetailUI@servletRequest" 
                         onClick="javascript:onEvent('changeBindingVaraibleState')" /> 
    <oem:table id="bindingVariablesDS"
           name="bindingVariablesDS"
           summaryBinding="BINDING_VARIABLES@sqlMsg"
           beanKey="sqlDetailUI" blockSize="5"
           dataSourceProp="bindingVariablesDS"
           copyParams="target,type,pageNum,sql_id,planHashValue,childNumber"
           alternateTextBinding="NO_BINDING_VARIABLE@sqlMsg"
           formSubmitted="true" renderedBinding="useBindingVariable@sqlDetailUI@servletRequest">        
        <uix:tableActions>
          <uix:flowLayout>
          <uix:button textBinding="ADD_FIVE_ROWS@sqlMsg" destination="javascript:onEvent('addBindingVariable')" />
          <uix:spacer width="5"/>
          <uix:button textBinding="REMOVE_ALL@sqlMsg" destination="javascript:onEvent('removeAllBindingVariables')" />
          </uix:flowLayout>
        </uix:tableActions>
        <uix:tableSelection>
          <uix:singleSelection shortDescBinding="SELECT@DBObjectMsg"
            selectedIndexBinding="visibleSelectedIndex@bindingVariablesDS@sqlDetailUI@servletRequest">
          <uix:flowLayout>
          <uix:button textBinding="REMOVE@sqlMsg" destination="javascript:onEvent('removeBindingVariable')" />
          <uix:spacer width="5"/>
          <uix:button textBinding="MOVE_UP@sqlMsg" destination="javascript:onEvent('moveUpBindingVariable')" />
          <uix:spacer width="5"/>
          <uix:button textBinding="MOVE_DOWN@sqlMsg" destination="javascript:onEvent('moveDownBindingVariable')" />
          </uix:flowLayout>
          </uix:singleSelection>
        </uix:tableSelection>        
    </oem:table> 
    <uix:flowLayout>
    <uix:messageCheckBox id="autoCommit" name="autoCommit" textBinding="AUTOCOMMIT@sqlMsg" shortDescBinding="AUTOCOMMIT@sqlMsg" 
                         checkedBinding="autoCommit@sqlWorksheetBean@servletRequest" />
    <uix:messageCheckBox id="selectOnlyMode" name="selectOnlyMode" 
                         textBinding="SELECT_ONLY_MODE@sqlMsg" 
                         shortDescBinding="SELECT_ONLY_MODE@sqlMsg" 
                         checkedBinding="selectOnlyMode@sqlWorksheetBean@servletRequest" />
    </uix:flowLayout>
    <uix:spacer height="5"/>
    <uix:rowLayout> 
    <uix:button id="formatBtn" textBinding="FORMAT@sqlMsg" destination="javascript:onEvent('formatSelectedSQL')" />    
    <uix:button id="executeBtn" textBinding="EXECUTE@sqlMsg" destination="javascript:onEvent('executeSelectedSQL')" />    
    <uix:spacer width="5"/>
    <uix:rowLayout>
    <uix:image source="/em/images/process_animation.gif" id="processIcon" shortDescBinding="EXECUTING@sqlMsg"/>
    <uix:spacer width="5"/>
    <uix:button id="cancelBtn" textBinding="CANCEL_EXECUTION@sqlMsg" destination="javascript:onEvent('cancelExecution')" />
    </uix:rowLayout>
    </uix:rowLayout>     
    </uix:cellFormat>
    
    </uix:rowLayout>
    </uix:tableLayout>
    
    <uix:switcher childNameBinding="showTextIcon@sqlDetailUI@servletRequest">        
      <uix:case name="true"> 
        <uix:stackLayout>
          <uix:hideShowHeader textBinding="LAST_EXECUTED_SQL@sqlMsg"
                    disclosedBinding="disclosedIcon@sqlDetailUI@servletRequest" 
                    formSubmitted="true" id="hideShowSql"/>
          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer width="15" />
                </uix:cellFormat > 
                <uix:cellFormat hAlign="left">
                   <uix:rawText textBinding="formatSql@sqlDetailUI@servletRequest"/>
                  <!-- db:sqlDisplay sqlListBinding="sqlList@sqlDetailUI@servletRequest"/-->
                </uix:cellFormat>
              </uix:rowLayout>
          </uix:tableLayout>
        </uix:stackLayout>
      </uix:case>         
      <uix:case name="false"> 
        <uix:stackLayout>
        <uix:header textBinding="LAST_EXECUTED_SQL@sqlMsg">
          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer width="15" />
                </uix:cellFormat > 
                <uix:cellFormat hAlign="left">
                   <uix:rawText textBinding="formatSql@sqlDetailUI@servletRequest"/>
                  <!-- db:sqlDisplay
sqlListBinding="sqlList@sqlDetailUI@servletRequest"/ -->
                </uix:cellFormat>
                <%-- uix:cellFormat hAlign="right" vAlign="top">
                <uix:tableLayout cellSpacing="5" renderedBinding="sqlIDAvailable@sqlDetailUI@servletRequest">
                <uix:rowLayout  hAlign="right">      
                <uix:cellFormat hAlign="right">         
				<uix:button textBinding="SQL_DIAG_ADVISOR@dbMsg" 
                     destinationBinding="sqlRepairURL@servletRequest"
                     renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:button textBinding="PG_SQL_DETAILS@dbMsg" 
                  destinationBinding="sqlDetailsURL@servletRequest"
                  renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:button textBinding="RUN_TUNING_ADVISOR@dbMsg" 
                  destinationBinding="sqlTuningURL@servletRequest"
                  renderedBinding="sqlTunable@servletRequest"/>                                  
                </uix:cellFormat> 
                </uix:rowLayout>     
                </uix:tableLayout>  
                </uix:cellFormat --%>
              </uix:rowLayout>     
            </uix:tableLayout>
          </uix:header>
          </uix:stackLayout>
      </uix:case>         
    </uix:switcher>     
    
    <uix:header textBinding="LAST_EXECUTION_DETAILS@sqlMsg">            
          <uix:tableLayout width="100%" cellSpacing="3">
             <uix:rowLayout>        
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:tableLayout cellSpacing="5" renderedBinding="sqlIDAvailable@sqlDetailUI@servletRequest">
                    <uix:rowLayout  hAlign="right">      
                      <uix:cellFormat hAlign="right">         
                        <uix:button textBinding="SQL_DIAG_ADVISOR@dbMsg" 
                          destinationBinding="sqlRepairURL@servletRequest"
                          renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:button textBinding="PG_SQL_DETAILS@dbMsg" 
                          destinationBinding="sqlDetailsURL@servletRequest"
                          renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:button textBinding="RUN_TUNING_ADVISOR@dbMsg" 
                          destinationBinding="sqlTuningURL@servletRequest"
                          renderedBinding="sqlTunable@servletRequest"/>
                      </uix:cellFormat> 
                    </uix:rowLayout>     
                  </uix:tableLayout> 
                </uix:cellFormat>
              </uix:rowLayout>     
           </uix:tableLayout>
    <uix:switcher childNameBinding="pageNum@servletRequest">   
      <uix:case name="1">
        <jsp:include page="worksheetResults.jsp" />  
        <uix:ref refID="worksheetResults" /> 
      </uix:case>        
      <uix:case name="2">
        <jsp:include page="sqlExecStats.jsp" />   
        <uix:ref refID="sqlExecStats" />         
      </uix:case>          
      <uix:case name="3">
        <jsp:include page="executionPlan.jsp" />   
        <uix:ref refID="executionPlan" />              
      </uix:case>      
      <uix:case name="4">
        <jsp:include page="sqlPlanControl.jsp" />   
        <uix:ref refID="sqlPlanControl" />              
      </uix:case>      
      <uix:case name="5">      
        <uix:switcher childNameBinding="SWRF@sqlDetailUI@servletRequest">
          <uix:case name="true">
            <jsp:include page="sqlTuningInfo.jsp" />   
            <uix:ref refID="sqlTuningInfo" />
          </uix:case>
           <uix:case name="false">
            <jsp:include page="sqlAssess.jsp" />   
            <uix:ref refID="sqlAssess" />
          </uix:case>         
        </uix:switcher>         
      </uix:case>            
      <uix:default> 
        <uix:styledText styleClass="OraPromptText" text="under construction"/>
      </uix:default>         
    </uix:switcher> 
    
  <uix:tableLayout  width="100%" renderedBinding="sqlIDAvailable@sqlDetailUI@servletRequest">
    <uix:rowLayout  hAlign="right">       
       <uix:tableLayout cellSpacing="5">
         <uix:rowLayout  hAlign="right">      
           <uix:cellFormat hAlign="right">         
			<uix:button textBinding="SQL_DIAG_ADVISOR@dbMsg" 
                  destinationBinding="sqlRepairURL@servletRequest"
                  renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest"/>
             <uix:spacer width="5"/>
             <uix:button textBinding="PG_SQL_DETAILS@dbMsg" 
                  destinationBinding="sqlDetailsURL@servletRequest"
                  renderedBinding="SQLTextAvailable@sqlDetailUI@servletRequest"/>
             <uix:spacer width="5"/>
             <uix:button textBinding="RUN_TUNING_ADVISOR@dbMsg" 
                  destinationBinding="sqlTuningURL@servletRequest"
                  renderedBinding="sqlTunable@servletRequest"/>                                  
           </uix:cellFormat> 
         </uix:rowLayout>     
       </uix:tableLayout>  
    </uix:rowLayout>     
  </uix:tableLayout>  
  </uix:header>
  <uix:header textBinding="RELATED_LINK@dbMsg">
     <uix:link textBinding="SQL_WORKSHEET_SESS_DETAILS@sqlMsg" 
          destinationBinding="sessionDetailsURL@servletRequest"/>
  </uix:header>

      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
