<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
          <db:form name="foo" method="GET" destination="/console/database/instance/sqldiag"
                   copyParams="target,type,isSTS,newSTS,backURL,defaultSTSName,sts,stsOwner,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">
          <uix:formValue name="schemaName" valueBinding="schemaName@defaultBean@servletRequest" />

      <uix:pageLayout titleBinding="DIAGOPT_PAGE_HEADER@sqlMsg">
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

        <%@ include file="/database/global.jspf" %>

<uix:styledText styleClass="OraInstructionText" textBinding="DIAGOPT_INSTRUCTION_AC@sqlMsg"/>
    <uix:spacer height="5"/>

    <uix:stackLayout>    
      <uix:rowLayout>    
        <uix:cellFormat width="60%">
            <%@include file="optionFields.jspf" %>
        </uix:cellFormat>     
          
        <uix:cellFormat width="40%">
            <uix:contentContainer textBinding="SQL_DIAG_ADVISOR_DATA_SOURCE_LINKS@sqlMsg" width="100%">
              <uix:stackLayout>
                <uix:separator>
                    <uix:spacer width="10" height="7"/>
                </uix:separator>
                  
                  <uix:styledText styleClass="OraInstructionText" 
                      textBinding="SQL_DIAG_ADVISOR_DATA_SOURCE_LINKS_DESC@sqlMsg" />
                      
                <%--
                  <uix:tableLayout width="100%" cellSpacing="2">
                      <uix:rowLayout>
                      <db:link textBinding="ACTIVITY_DETAILS@dbMsg"
                          destination="/console/database/instance/waitDetails?event=doLoad&waitClass=Overview" copyParams="target,type,dbPageNum"/>
                      <uix:spacer height="10"/>
                      
                      <db:link textBinding="PERIOD_SQL@dbMsg"
                          destination="/console/database/instance/topSqls?event=doLoad&refreshChoice=1" copyParams="target,type,dbPageNum"/>
                      <uix:spacer height="10"/>
      
                      <db:link textBinding="SQL_TUNING_SETS@dbMsg" 
                          destination="/console/database/instance/sqlSet?event=doLoad" copyParams="target,type,dbPageNum"/>
                      <uix:spacer height="10"/>
                --%>
                  <%-- need to be changed into SQL Worksheet, the destination need to be generated from java coder
                      <db:link textBinding="SNAPSHOTS@dbMsg"
                          destination="/console/database/instance/swrfSnapshots?event=doLoad" copyParams="target,type,dbPageNum"/>
                  --%>
                <%--
                      </uix:rowLayout>
                  </uix:tableLayout>
                --%>
      
              </uix:stackLayout>
            </uix:contentContainer>
          </uix:cellFormat>
      </uix:rowLayout>  
    </uix:stackLayout>
  
 
 <uix:hideShowHeader id="sqlStatementsHideShow"
                     textBinding="OPT_SQL_STMTS@sqlMsg"
                     disclosedBinding="showSqlStatements@defaultBean@servletRequest"
                     formName="foo"
                     formSubmitted="true" >

    <oem:table name="stmts"
        summaryBinding="OPT_SQL_STMTS@sqlMsg"
        partialRenderMode="self"
        dataSourceBinding="stmtTableUI@servletRequest"
        width="80%"
        renderedBinding="stmtTableUIRendered@servletRequest"
        blockSize="5"
        formSubmitted="true"
        copyParams="target,type,isSTS,newSTS,backURL,sts,stsOwner,defaultSTSName,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">
    </oem:table>
</uix:hideShowHeader>

    <%@include file="scopeSched.jspf" %>

        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@dbMsg"
                                name="event" value="cancelOptions"/>
              <uix:submitButton textBinding="DIAGOPT_SUBMIT@sqlMsg" name="event" value="acceptOptions"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
          </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
