<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

<oem:setURLEncoder id="renderingContext"/>

<uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
        <db:form name="foo" method="GET" destination="/console/database/instance/sqldiag"
                copyParams="target,type,isSTS,newSTS,backURL,defaultSTSName,sts,stsOwner,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">

        <uix:pageLayout titleBinding="DIAGOPT_PAGE_HEADER_C@sqlMsg">
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%@ include file="/database/global.jspf" %>

          <uix:styledText styleClass="OraInstructionText" textBinding="DIAGOPT_INSTRUCTION_AC@sqlMsg"/>

          <uix:spacer height="5"/>

    <uix:stackLayout>    
      <uix:rowLayout>    
        <uix:cellFormat width="55%">

            <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                        <uix:messagePrompt styleClass="OraPromptText"
                                          labeledNodeId="OptName"
                                          promptBinding="DIAGOPT_NAME@sqlMsg" required="yes"/>
                    </uix:cellFormat>
                    <uix:cellFormat columnSpan="2">
                        <uix:textInput name="taskName" id="OptName" 
                                        textBinding="taskName@defaultBean@servletRequest" 
                                        columns="52"/>
                    </uix:cellFormat>  
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraPromptText"
                                   labeledNodeId="OptDesc"
                                     textBinding="DIAGOPT_DESCRIPTION@sqlMsg"/>
                    </uix:cellFormat>
                    <uix:cellFormat columnSpan="2">
                        <uix:textInput name="description" id="OptDesc" 
                                textBinding="description@defaultBean@servletRequest" 
                                columns="52"/>
                    </uix:cellFormat>  
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraPromptText"
                                textBinding="DIAGOPT_PROBLEMID@sqlMsg"/> 
                    </uix:cellFormat>
                    <uix:cellFormat columnSpan="2">
                        <uix:styledText styleClass="OraDataText" textBinding="problemId@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraPromptText"
                                textBinding="DIAGOPT_INCIDENTID@sqlMsg"/>   
                    </uix:cellFormat>
                    <uix:cellFormat columnSpan="2">
                        <uix:styledText styleClass="OraDataText" textBinding="incidentId@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>

        </uix:cellFormat>     
          
        <uix:cellFormat width="45%">
            <uix:contentContainer textBinding="SQL_DIAG_ADVISOR_DATA_SOURCE_LINKS_2@sqlMsg" width="100%">
              <uix:stackLayout>
                <uix:separator>
                    <uix:spacer width="10" height="7"/>
                </uix:separator>
                  
                  <uix:styledText styleClass="OraInstructionText" 
                      textBinding="SQL_DIAG_ADVISOR_DATA_SOURCE_LINKS_DESC_2@sqlMsg" />
      
              </uix:stackLayout>
            </uix:contentContainer>
          </uix:cellFormat>
      </uix:rowLayout>  
    </uix:stackLayout>

          <uix:header textBinding="DIAGOPT_SQL_STMTS@sqlMsg">
                <oem:table name="stmts"
			   summaryBinding="DIAGOPT_SQL_STMTS@sqlMsg"
			   partialRenderMode="self"
                           dataSourceBinding="stmtTableUI@servletRequest"
                           width="80%"
                           renderedBinding="stmtTableUIRendered@servletRequest"
		           blockSize="5"
			   formSubmitted="true"
		           copyParams="target,type,isSTS,newSTS,backURL,sts,stsOwner,defaultSTSName,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">

                </oem:table>
          </uix:header>
              
          <%@include file="scopeSched.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@dbMsg"
                                name="event" value="cancelOptions"/>
              <uix:submitButton textBinding="DIAGOPT_SUBMIT@sqlMsg" name="event" value="acceptOptions"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
