<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
          <db:form name="foo" method="GET" destination="/console/database/instance/sqldiag"
                   copyParams="target,type,isSTS,newSTS,backURL,defaultSTSName,sts,stsOwner,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">

      <uix:pageLayout titleBinding="DIAGOPT_PAGE_HEADER_P@sqlMsg">
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

        <%@ include file="/database/global.jspf" %>

<uix:styledText styleClass="OraInstructionText" textBinding="DIAGOPT_INSTRUCTION@sqlMsg"/>

              <uix:spacer height="5"/>

              <uix:labeledFieldLayout columns="1" labelWidth="15%" fieldWidth="85%">

                <uix:messagePrompt styleClass="OraPromptText"
                        labeledNodeId="OptName"
                        promptBinding="DIAGOPT_NAME@sqlMsg" required="yes"/>
                <uix:textInput name="taskName" id="OptName" textBinding="taskName@defaultBean@servletRequest" columns="40"/>

                <uix:styledText styleClass="OraPromptText"
                                labeledNodeId="OptDesc"
                                textBinding="DIAGOPT_DESCRIPTION@sqlMsg"/>
                <uix:textInput name="description" id="OptDesc" textBinding="description@defaultBean@servletRequest" columns="80"/>
              
                <!--
                <uix:styledText styleClass="OraPromptText"
                                  labeledNodeId="OptPid"
                                  textBinding="DIAGOPT_PROBLEMID@sqlMsg"/>
                <uix:textInput name="problemId" id="OptPid" textBinding="problemId@defaultBean@servletRequest" readOnly="true" columns="40"/>
                -->
                
                <uix:styledText styleClass="OraPromptText"
                                  labeledNodeId="OptTid"
                                  textBinding="DIAGOPT_TUNING_TASKID@sqlMsg"/>
                <uix:textInput name="tuneId" id="OptTid" textBinding="tuneId@defaultBean@servletRequest" readOnly="true" columns="40"/>
                <uix:styledText styleClass="OraPromptText"/>
                <uix:tip>
                  <uix:styledText textBinding="DIAGOPT_TUNING_TIP@sqlMsg"/>
                </uix:tip>
              </uix:labeledFieldLayout>


              <uix:header textBinding="DIAGOPT_SQL_STMTS@sqlMsg">
                <oem:table name="stmts"
			   summaryBinding="DIAGOPT_SQL_STMTS@sqlMsg"
			   partialRenderMode="self"
                           dataSourceBinding="stmtTableUI@servletRequest"
                           width="80%"
                           renderedBinding="stmtTableUIRendered@servletRequest"
		           blockSize="5"
			   formSubmitted="true"
		           copyParams="target,type,isSTS,newSTS,backURL,sts,stsOwner,defaultSTSName,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">
<%--
                  <uix:tableSelection>
                    <oem:singleSelection selectedIndex="0">
                      <uix:submitButton text="View Details" name="event" value="viewDetails"/>
                    </oem:singleSelection>
                  </uix:tableSelection>
--%>
                </oem:table>
              </uix:header>

              <uix:header textBinding="DIAGOPT_SCOPE@sqlMsg">
                <uix:stackLayout>
                  <oem:radioButton name="scope"
                                   value="LIMITED" selectedValueBinding="scope@defaultBean@servletRequest"
                                   textBinding="DIAGOPT_LIMITED@sqlMsg"
                                   styleClass="OraInstructionText"/>
                  <oem:radioButton name="scope"
                                   value="COMPREHENSIVE" selectedValueBinding="scope@defaultBean@servletRequest"
                                   textBinding="DIAGOPT_COMPREHENSIVE@sqlMsg"
                                   styleClass="OraInstructionText"/>

                  <uix:labeledFieldLayout columns="1" labelWidth="15%" fieldWidth="85%">
                    <uix:styledText styleClass="OraPromptText"
                        labeledNodeId="OptTotalTimeLimit"
                        textBinding="DIAGOPT_TOTAL_TIME_LIMIT@sqlMsg"/>
                    <uix:rowLayout>
                      <uix:textInput name="timeLimitedMinutes"
                        id="OptTotalTimeLimit"
                        textBinding="timeLimitedMinutes@defaultBean@servletRequest" columns="10"/>
                    </uix:rowLayout>
                  </uix:labeledFieldLayout>

                </uix:stackLayout>
              </uix:header>

<uix:dataScope>
<uix:bundle name="ScheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<%-- START HEADER --%>
<uix:header textBinding="DIAGOPT_SCHEDULE@sqlMsg">

<uix:tableLayout cellSpacing="5">
<%-- START TIME ZONE --%>
<uix:cellFormat hAlign="right">
<uix:messagePrompt
     promptBinding="TIME_ZONE@ScheduleBundle"
/>
</uix:cellFormat>
<uix:cellFormat>
<oem:choice
     name="startTimeZoneSB"
     optionsBinding="timeZonesSB@scheduleBean@servletRequest"
     selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"
/>
</uix:cellFormat>
</uix:tableLayout>

<uix:tableLayout cellSpacing="5">
<uix:rowLayout>
<%-- IMMEDIATELY RADIO BUTTON --%>
<uix:radioButton
     name="scheduleTypeSB"
     value="now"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="IMMEDIATELY@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- LATER RADIO BUTTON --%>
<uix:radioButton
     name="scheduleTypeSB"
     value="later"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="LATER@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- START DATE --%>
<uix:cellFormat  hAlign="right">
<uix:messagePrompt
     promptBinding="DATE@ScheduleBundle"
/>
</uix:cellFormat>
<uix:messageDateField
     name="startDateSB"
     valueBinding="startDateSB@scheduleBean@pageContext"
     tipBinding="dateTip@scheduleBean@servletRequest"
     columns="24">
<uix:onSubmitValidater>
<uix:date dateStyle="medium"/>
</uix:onSubmitValidater>
</uix:messageDateField>
</uix:rowLayout>

<uix:rowLayout hAlign="right">
<%-- START HOUR --%>
<uix:messagePrompt
     promptBinding="TIME@ScheduleBundle"
/>
<uix:flowLayout>
<oem:choice
     name="startHourSB"
     optionsBinding="hoursSB@scheduleBean@servletRequest"
     selectedValueBinding="startHourSB@scheduleBean@servletRequest"
/>

<%-- START MINUTE --%>
<oem:choice
     name="startMinuteSB"
     optionsBinding="minutesSB@scheduleBean@servletRequest"
     selectedValueBinding="startMinuteSB@scheduleBean@servletRequest"
/>

<%-- START SECOND --%>
<oem:choice
     name="startSecondSB"
     renderedBinding="showSeconds@scheduleBean@servletRequest"
     optionsBinding="secondsSB@scheduleBean@servletRequest"
     selectedValueBinding="startSecondSB@scheduleBean@servletRequest"
/>

<%-- START AM/PM --%>
<oem:radioButton
     name="startAmPmSB"
     value="AM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="AM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText"
/>
<oem:radioButton
     name="startAmPmSB"
     value="PM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="PM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:flowLayout>
</uix:rowLayout>

<%-- TIME LIMIT --%>
<%--
<uix:rowLayout>
<uix:cellFormat  hAlign="right">
<uix:messagePrompt
     prompt="Time Limit (Minutes)" required="yes"
/>
</uix:cellFormat>
<uix:textInput name="timeLimitedMinutes"
    shortDescBinding="timeLimitedMinutes@defaultBean@servletRequest"
    textBinding="timeLimitedMinutes@defaultBean@servletRequest" columns="10"/>
</uix:rowLayout>
--%>
</uix:tableLayout>
</uix:header>

</uix:dataScope>

            <%-- /uix:header --%>


        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@dbMsg"
                                name="event" value="cancelOptions"/>
              <uix:submitButton textBinding="OK@dbMsg" name="event" value="acceptOptions"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
          </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
