<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext" >
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

<oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <db:form name="processForm" method="POST" destination="/console/database/instance/sqldiag" copyParams="target,type,processId,backURL,planHashValue,objectId,advisorCentralURL,processBackURL,dbPageNum">
      <uix:formValue name="pageName" value="/database/instance/sqldiag/process.jsp"/>

     <uix:pageLayout titleBinding="DIAGPROCESSING_TITLE@sqlMsg">
      <%@ include file="/database/global.jspf" %>
	
          <uix:spacer height="5" />
            <uix:styledText styleClass="OraDataText" textBinding="DIAGPROCESSING_BOLD_MSG@sqlMsg"/>
          <uix:spacer height="5" />
            <uix:styledText styleClass="OraInstructionText" textBinding="DIAGPROCESSING_MSG@sqlMsg"/>
          <uix:spacer height="20" /> 

        <uix:processing id="sqlTuneProcess"
              timeInterval="<%=processingPageInterval%>">

            <uix:tableLayout cellSpacing="1">
              <uix:contents childDataBinding="allStepsData@processBean@servletRequest">
                <uix:rowLayout>
                    <uix:cellFormat>
                        <uix:image source="/em/images/processCheck.gif" 
                          renderedBinding="renderedDone" shortDescBinding="DIAGPROCESSING_MSG@sqlMsg"/>       
                        <uix:image source="/em/images/currentStep.gif" 
                          renderedBinding="current" shortDescBinding="DIAGPROCESSING_MSG@sqlMsg"/>       
                    </uix:cellFormat>
                    <uix:spacer width="3" />
                    <uix:cellFormat vAlign="bottom">
                      <uix:styledText styleClass="OraFieldText" textBinding="text" /> 
                    </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
        </uix:processing>
        <uix:spacer height="20" />
        <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat vAlign="middle" hAlign="middle">
                  <uix:tip>
                        <uix:styledText styleClass="OraTipText"
                                        textBinding="DIAG_CANNOT_CANCEL@sqlMsg" />
                  </uix:tip>
                  </uix:cellFormat>
                </uix:rowLayout>
        </uix:tableLayout>

       <uix:pageButtons>
        <uix:pageButtonBar>
           <uix:submitButton textBinding="DIAG_RETURN@sqlMsg" name="event" value="cancelProcess" /> 
        </uix:pageButtonBar>
        </uix:pageButtons>

     </uix:pageLayout>

     </db:form>
    
    </uix:body>
  </uix:document> 
</uix:renderingContext>
