<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg" class="oracle.sysman.db.rsc.inst.SQLMsg"/>

<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="foo" destination="/em/console/database/instance/sqldiag"
          copyParams="target,type,advisoryCentralURL,task_id,dbPageNum">

      <uix:pageLayout titleBinding="header@diagresultObj@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:contents>
        
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- REFRESH --%>
          <uix:tableLayout width="100%" cellSpacing="2">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
                <uix:button textBinding="SQL_DIAG_VERIFY_SQL_WORKSHEET@sqlMsg"
                      destinationBinding="sqlWorksheetURL@servletRequest" renderedBinding="showWorksheet@servletRequest"/>            
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:rowLayout>
                <uix:styledText styleClass="OraTipText"
                     textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipLabel"
                     textBinding="refreshTime@servletRequest"/>
                <uix:spacer width="10"/>
                <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                      destinationBinding="refreshD@servletRequest" />               
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

              <uix:labeledFieldLayout columns="2">            
                <uix:styledText styleClass="OraPromptText" textBinding="RST_STATUS@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="taskStatus@diagresultObj@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_TUNING_SET_OWNER@sqlMsg" renderedBinding="showSTSOwner@servletRequest"/>                
                <uix:styledText styleClass="OraDataText" textBinding="stsOwner@servletRequest" renderedBinding="showSTSOwner@servletRequest"/>
                
                <uix:styledText styleClass="OraPromptText" textBinding="RST_STARTED@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="startDate@servletRequest"/>

                <uix:styledText styleClass="OraPromptText"
                                textBinding="stsNameOrSqlIdLabel@servletRequest"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="stsNameOrSqlId@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_COMPLETED@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="endDate@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_TIME_LIMIT@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="timeLimitSeconds@diagresultObj@servletRequest"/>

                <uix:spacer  width = "10" renderedBinding="showSTSOwner@servletRequest"/>
                <uix:spacer  width = "10" renderedBinding="showSTSOwner@servletRequest"/>
                
                <uix:styledText styleClass="OraPromptText" textBinding="RST_RUNNING_TIME@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="runningTime@servletRequest"/>
              </uix:labeledFieldLayout>
              
              <uix:spacer height="5"/>

              <uix:header textBinding="RST_RECOMMENDATIONS@sqlMsg">

                <oem:table name="ovw" partialRenderMode="self"
                           summaryBinding="RST_RECOMMENDATIONS@sqlMsg"
			   dataSourceBinding="actionOverview@servletRequest"
			   width="100%" blockSize="25"
                           renderedBinding="actionOverviewRendered@servletRequest"
			   copyParams="target,type,advisoryCentralURL,task_id,dbPageNum"
			   formSubmitted="true"
                           alternateTextBinding="DIAGRST_NO_RECOMMENDATIONS_AVAILABLE@sqlMsg">
                  <uix:tableSelection>
                    <oem:singleSelection shortDescBinding="SELECT@dbMsg"
                                         selectedIndex="0">
                      <uix:submitButton textBinding="DIAGRST_VIEW_RECOMMENDATIONS@sqlMsg" name="event" value="viewstmt"/>
                    </oem:singleSelection>
                  </uix:tableSelection>
                </oem:table>

              </uix:header>

        </uix:contents>

      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
