<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="dbObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
          <db:form name="foo" method="GET" destination="/console/database/instance/sqldiag"
                   copyParams="target,type,task_id,objectId,backURL,processBackURL,advisoryCentralURL,dbPageNum">
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:contents>

        <uix:tableLayout width="100%" cellSpacing="2">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:rowLayout>
                <uix:styledText styleClass="OraTipText"
                     textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipLabel"
                     textBinding="refreshTime@servletRequest"/>
                <uix:spacer width="10"/>
                
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:styledText styleClass="OraPromptText" textBinding="DIAGSRT_DESCRIPTION@sqlMsg" renderedBinding="showDescription@servletRequest"/>

          <uix:header textBinding="SRT_SQL_TEXT@sqlMsg">
            <uix:link textBinding="displaySQLText@sresultObj@servletRequest" destinationBinding="sqlUrl@servletRequest" />
          </uix:header>

          <uix:header textBinding="DIAGSRT_RECOMMENDATIONS@sqlMsg">
            <uix:tableLayout  width="100%">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:table width="100%"
                summaryBinding="DIAGSRT_RECOMMENDATIONS@sqlMsg"
                name="recomTable"
                formSubmitted="true"
                alternateTextBinding="DIAGRST_NO_RECOMMENDATIONS_AVAILABLE@sqlMsg"
                tableDataBinding="SQLStmtData@recomTable@servletRequest">
                
                <uix:column>
                    <uix:columnHeader>
                        <uix:styledText textBinding="SRT_COL_FINDINGS@sqlMsg"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="finding"/>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                </uix:column>
                <uix:column>
                    <uix:columnHeader>
                        <uix:styledText textBinding="RST_RECOMMENDATIONS@sqlMsg"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="rec"/>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                </uix:column>
                <uix:columnGroup>
                    <uix:columnHeader>
                        <uix:styledText textBinding="DIAG_RESULT_EXECUTION_TIME@sqlMsg"/>
                    </uix:columnHeader>
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="DIAG_RESULT_BEFORE@sqlMsg"/>
                        </uix:columnHeader>
                        <uix:styledText textBinding="timeBefore"/>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                    </uix:column>
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="DIAG_RESULT_AFTER@sqlMsg"/>
                        </uix:columnHeader>
                        <uix:styledText textBinding="timeAfter"/>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                    </uix:column>
                </uix:columnGroup>
                <uix:columnGroup>
                    <uix:columnHeader>
                        <uix:styledText textBinding="DIAG_RESULT_NUMBER_ROWS@sqlMsg"/>
                    </uix:columnHeader>
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="DIAG_RESULT_BEFORE@sqlMsg"/>
                        </uix:columnHeader>
                        <uix:styledText textBinding="rowBefore"/>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                    </uix:column>
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="DIAG_RESULT_AFTER@sqlMsg"/>
                        </uix:columnHeader>
                        <uix:styledText textBinding="rowAfter"/>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                    </uix:column>
                </uix:columnGroup>
                <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT@dbMsg"
                        selectedIndex="0">
                      <uix:submitButton textBinding="DIAGSRT_IMPLEMENT@sqlMsg" name="event" value="implement" renderedBinding="couldImplement@servletRequest"/>
                    </uix:singleSelection>
                </uix:tableSelection>
                <uix:tableFormat tableBanding="noBanding"/>               
            </uix:table>
            
                <%--
                <oem:table name="recomTable" width="100%"
                           summaryBinding="DIAGSRT_RECOMMENDATIONS@sqlMsg"
                           dataSourceBinding="recomTable@servletRequest"
                           alternateTextBinding="DIAGRST_NO_RECOMMENDATIONS_AVAILABLE@sqlMsg">
                  <uix:tableSelection>
                    <oem:singleSelection shortDescBinding="SELECT@dbMsg"
                        selectedIndex="0">
                      <uix:submitButton textBinding="DIAGSRT_IMPLEMENT@sqlMsg" name="event" value="implement" renderedBinding="couldImplement@servletRequest"/>
                    </oem:singleSelection>
                  </uix:tableSelection>
                  <uix:tableFormat tableBanding="noBanding"/>
                </oem:table>
                --%>
                
            </uix:header>

        </uix:contents>

        <uix:pageButtons>
          <uix:pageButtonBar>
               <uix:submitButton textBinding="RETURN@dbObjectMsg"
                                name="event" value="cancelStmtResult"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
