<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>                

    <db:form name="foo" method="get" destination="/console/database/instance/sqlHistory"
      copyParams="target,type,pageNum">

    <uix:header textBinding="header@sqlHistoryBean@servletRequest">

    <%@ include file="../refreshTime.jspf" %>


    <uix:tableLayout width="100%" >
      <uix:rowLayout hAlign="left">
        <uix:messagePrompt promptBinding="SQL_HISTORY_INSTR@DBMsgBundle@servletRequest" />
      </uix:rowLayout>
    </uix:tableLayout>       

    <uix:spacer height="10" />

    <uix:tableLayout width="100%" >
        <uix:rowLayout hAlign="left">
          <uix:cellFormat>
            <uix:flowLayout>
              <uix:styledText styleClass="OraInstructionText"
                              labeledNodeId="viewChoiceId"
                              textBinding="DUP_SQL_MODULE@DBMsgBundle@servletRequest" />
              <uix:choice name="viewChoice" id="viewChoiceId"
                          onChange="submitForm('foo', true, {'event':'doLoad'})" >
                <uix:option textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                            value="ADMIN"/>
                <uix:option textBinding="REAL_TIME_MONITORING@DBMsgBundle@servletRequest"
                            value="RT_MON" 
                            selectedBinding="realTimeSelected@sqlHistoryBean@servletRequest"/>
              </uix:choice>
            </uix:flowLayout>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>


    <uix:spacer height="10" />


    <uix:tableLayout width="100%" >
      <uix:cellFormat hAlign="left" vAlign="top" width="100%">
        <uix:checkBox name="showBindVars"
                      textBinding="SHOW_SQL_BIND_VARS@DBMsgBundle@servletRequest"
                      onClick="submitForm('foo', true, {'event':'switchBindVars'})"
                      checkedBinding="showBindVariables@sqlHistoryBean@servletRequest"
                      />
      </uix:cellFormat>
      <uix:cellFormat hAlign="right" vAlign="top" width="100%">
      
          <uix:button textBinding="ENABLE_SQL_TRACE@TopConsumersBundle@servletRequest" 
             destinationBinding="enableSqlTrace@servletRequest"
             renderedBinding="showSqlTraceButtons@servletRequest" />
          <uix:spacer width="10" />  
          <uix:button textBinding="DISABLE_SQL_TRACE@TopConsumersBundle@servletRequest" 
             destinationBinding="disableSqlTrace@servletRequest"
             renderedBinding="showSqlTraceButtons@servletRequest" />
          <uix:spacer width="10" />     
          <uix:submitButton textBinding="CLEAR@DBMsgBundle@servletRequest" 
            name="event" value="clear"/>
          <uix:spacer width="10" />  
          <uix:submitButton textBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest"
            name="event" value="saveToFile" />
        </uix:cellFormat>
    </uix:tableLayout>


      <oem:table name="sqlHistoryUIDataSource"
                 partialRenderMode="self"
                 id="sqlHistoryTable"
                 alternateTextBinding="NO_HISTORY_ALT@DBMsgBundle@servletRequest" 
                 width="100%"
                 dataSourceProp="sqlHistoryUIDataSource"
                 beanKey="sqlHistoryBean"
                 summaryBinding="header@sqlHistoryBean@servletRequest"
                 formSubmitted="true">
      </oem:table>


    </uix:header>


    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

