<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"> 
<uix:bundle name="DBMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

<script>
 function getBrowserHeight()
 {
    var winH = 460;
    winH = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight;
   return winH; 
 }

 function resizeFlexHeight(height)
 {
   var o = document.getElementById('flexSqlMonitorEmbedId');
   if (o)
     o.style.height=height;
   var o1 = document.getElementById('flexSqlMonitorObjectId');
   if (o1)
     o1.style.height=height;
 }
</script>
  
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="sqlMonitorForm" method="POST" destination="sqlMonitor" copyParams="target,type,pageName">    
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
     
       <db:flexRegion
                swfName="/database/flex/sqlmonitor/SqlMonitorList.swf"
                dataSrcKeyBinding="flexKey@SqlMonitor@servletRequest"
                optionsBinding="params@SqlMonitor@servletRequest"
                windowWidth="100%"
                windowHeight="100%"
                idBase="flexSqlMonitor" />
	<uix:tip renderedBinding="accessibilityOn@servletRequest">
              <uix:link textBinding="ACCESSIBILITY_HELP@DBMsg" destinationBinding="accessibilityHelp@servletRequest"/>
	</uix:tip>
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

