<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" method="post"
               destinationBinding="dsqlPlanManagement"
               copyParams="target,type">

      <uix:formValue name="backPage" valueBinding="backPage@servletRequest" />
      <uix:formValue name="pageName" value="/database/instance/sqlplan/changeCategory" />
      <uix:pageLayout  titleBinding="OPM_TITLE@sqlMsg">
        <%@ include file="/database/global.jspf" %>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>

        
<uix:header textBinding="headerText@servletRequest" >
        <uix:tableLayout width="100%">
  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="instrText@servletRequest"/>
  </uix:cellFormat>
  </uix:rowLayout>
	<uix:rowLayout>
	<uix:cellFormat hAlign="center">
        <uix:tableLayout width="50%" cellSpacing="10">
        <uix:rowLayout>
        <uix:cellFormat hAlign="center" columnSpan="2">
               <uix:table name="plnBaseline"
            width="100%"
            tableDataBinding="selectedList@servletRequest"
            formSubmitted="true"
            showAll="yes"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@sqlMsg"
          >
                 <uix:tableFormat tableBanding="rowBanding"/>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_NAME@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="NAME"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_SQL_TEXT@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="SHORT_SQL_TEXT"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_OLD_CATEGORY@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="CATEGORY"/>
               </uix:contents>
           </uix:column>
          </uix:table>
          </uix:cellFormat>
	</uix:rowLayout>

<%--        
	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="labelName@servletRequest"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="selectedList@servletRequest"/>
	</uix:cellFormat>
	</uix:rowLayout>
	--%>
	<uix:rowLayout>
	<uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="NEW_CATEGORY@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
          <uix:textInput id="category" name="newCategory" />
	</uix:cellFormat>
	</uix:rowLayout>
	</uix:tableLayout >
	</uix:cellFormat>
	</uix:rowLayout>
	</uix:tableLayout >
</uix:header>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@dbMsg"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@dbMsg"
                              name="event"
                              value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

