<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="bundle" class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@bundle"/>
    </uix:metaContainer>
    
    <uix:body>      
      <db:form name="delForm" destination="sqlPlanManagement" copyParams="target,type">        
        <uix:formValue name="event"/>        
	    <uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>        
	    <uix:formValue name="pageName"
	    value="/database/instance/sqlplan/confirmPage"/>        
        
        <uix:pageLayout messageTypeBinding="CONFIRMATION@bundle">                  
          <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->          
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>

          
          <uix:header textBinding="CONFIRMATION@bundle" icon="/em/images/confirmation.gif">            
            <uix:stackLayout>              
              <uix:rowLayout>              
                <uix:styledText styleClass="OraDataText"                                
                    textBinding="CONFIRM_MSG@bundle"/>
              </uix:rowLayout>              
              <uix:rowLayout>                
                <uix:spacer height="10"/>              
              </uix:rowLayout>
              <uix:rowLayout>
               <uix:table name="plnBaseline"
            width="100%"
            tableDataBinding="selectedList@servletRequest"
            formSubmitted="true"
            showAll="yes"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@bundle"
          >
                 <uix:tableFormat tableBanding="rowBanding"/>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_NAME@bundle"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="NAME"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_SQL_TEXT@bundle"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="SHORT_SQL_TEXT"/>
               </uix:contents>
           </uix:column>

          </uix:table>
              
              </uix:rowLayout>              
              </uix:stackLayout>          
            </uix:header>          
            
            <uix:pageButtons>            
              <uix:pageButtonBar>              
                <uix:submitButton textBinding="NO@bundle"                      
                    name="event" value="noDelete"/>             
                <uix:submitButton textBinding="YES@bundle"                      
                    name="event" value="doDelete"/>             
              </uix:pageButtonBar>          
            </uix:pageButtons>        
          </uix:pageLayout>        
        </db:form>                
      </uix:body>  
    </uix:document>
  </uix:renderingContext> 
