<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="chngMsg"
              class="oracle.sysman.db.rsc.inst.ChangeStateMsg"/>
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" method="post"
               destinationBinding="dsqlPlanManagement"
               copyParams="target,type">

      <uix:formValue name="backPage" valueBinding="backPage@servletRequest" />
      <uix:formValue name="pageName" value="/database/instance/sqlplan/evolve" />
      <uix:pageLayout  titleBinding="OPM_TITLE@sqlMsg">
        <%@ include file="/database/global.jspf" %>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>

		<uix:header textBinding="EVOLVE_HEADER@sqlMsg" >
        <uix:tableLayout width="100%">
	  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="EVOLVE_INSTR@sqlMsg"/>
  </uix:cellFormat>
  </uix:rowLayout>
	<uix:rowLayout>
	<uix:cellFormat hAlign="left">
        <uix:tableLayout width="80%" cellSpacing="10">
	<uix:rowLayout>
	<uix:cellFormat hAlign="center" wrappingDisabled="true" columnSpan="2">
	       <uix:table name="plnBaseline"
            width="100%"
            tableDataBinding="selectedPlanSqlIDTable@sqlPlanBean@servletRequest"
            formSubmitted="true"
            showAll="yes"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@sqlMsg"
          >
                 <uix:tableFormat tableBanding="rowBanding"/>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="PLAN_NAME@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="NAME"/>
                   <uix:formValue name="sqlID" valueBinding="SQL_ID"/>
                   <uix:formValue name="planName" valueBinding="NAME"/>
                   <uix:formValue name="selected" valueBinding="NAME"/>
                 
               </uix:contents>
           </uix:column>
           
           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_SQL_TEXT@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="SHORT_SQL_TEXT"/>
               </uix:contents>
           </uix:column>

          </uix:table>

	</uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="EVOLVE_PERF@sqlMsg"
                               shortDescBinding="VERIFY_PERF_TIP@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
		<uix:flowLayout>
	  		<uix:radioButton 	name="verifyPerf" 
	  					selectedValueBinding="verifyPerf@evolveBean@sqlPlanBean@servletRequest" 
	  					shortDescBinding="VERIFY_PERF_TIP@sqlMsg"
	  					id="sqlProfile" 
	  					textBinding="YES@sqlMsg" 
	  					value="YES" />
	  		<uix:radioButton name="verifyPerf"
	  				   selectedValueBinding="verifyPerf@evolveBean@sqlPlanBean@servletRequest" 
	  				   shortDescBinding="VERIFY_PERF_TIP@sqlMsg"
	  				   id="sqlProfile" 
	  				   textBinding="NO@sqlMsg" 
	  				   value="NO" />
	  </uix:flowLayout>
	</uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="EVOLVE_TIME_LIMIT@sqlMsg"
                               shortDescBinding="TIME_LIMIT_TIP@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
		<uix:flowLayout>
	  		<uix:radioButton name="timeLimit" 
	  						 selectedValueBinding="timeLimit@evolveBean@sqlPlanBean@servletRequest" 
	  						 id="sqlProfile" 
	  						 shortDescBinding="TIME_LIMIT_TIP@sqlMsg"
	  						 textBinding="AUTO@sqlMsg" 
	  						 value="-1" />
	  		<uix:radioButton name="timeLimit" 
	  						 selectedValueBinding="timeLimit@evolveBean@sqlPlanBean@servletRequest" 
	  						 shortDescBinding="TIME_LIMIT_TIP@sqlMsg"
	  						 id="sqlProfile" 
	  						 textBinding="UNLIMITED@sqlMsg" 
	  						 value="0" />
	  		<uix:radioButton 	name="timeLimit" 
								selectedValueBinding="timeLimit@evolveBean@sqlPlanBean@servletRequest" 
	  							id="sqlProfile" 
	  							shortDescBinding="TIME_LIMIT_TIP@sqlMsg"
	  							textBinding="SPECIFY@sqlMsg" 
	  							value="1" />
	  							
	  		<uix:textInput 	name="timeInMins" 
	  						columns="4" 
	  						shortDescBinding="TIME_LIMIT_TIP@sqlMsg"
	  						textBinding="timeInMins@evolveBean@sqlPlanBean@servletRequest">
	  				<uix:onSubmitValidater>
	  					<uix:decimal/>
	  				</uix:onSubmitValidater>
	  		</uix:textInput>
	  		<uix:styledText styleClass="OraDataText" id="sqlProfile"  shortDescBinding="TIME_LIMIT_TIP@sqlMsg" textBinding="MINS@sqlMsg"/>
	  </uix:flowLayout>
	</uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="EVOLVE_ACTION@sqlMsg"
                               shortDescBinding="ACTION_TIP@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
		<uix:flowLayout>
	  		<uix:radioButton 	name="action" 
	  							selectedValueBinding="action@evolveBean@sqlPlanBean@servletRequest"
	  							id="sqlProfile" 
	  							textBinding="REPORT_N_ACCEPT@sqlMsg" 
	  							shortDescBinding="ACTION_TIP@sqlMsg"
	  							value="YES" />
	  		<uix:radioButton 	name="action" 
	  							selectedValueBinding="action@evolveBean@sqlPlanBean@servletRequest"
	  							id="sqlProfile" 
	  							textBinding="REPORT@sqlMsg" 
	  							shortDescBinding="ACTION_TIP@sqlMsg"
	  							value="NO" />
	  </uix:flowLayout>
	</uix:cellFormat>
	</uix:rowLayout>
	
	</uix:tableLayout >
	</uix:cellFormat>
	</uix:rowLayout>
	</uix:tableLayout >
</uix:header>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@dbMsg"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@dbMsg"
                              name="event"
                              value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

