<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>



<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

<script language="javascript">
  function lovCallBack(data){
  var i =0;
    if ((i=data.indexOf('".')) > 0)
    {
      data = removeQuotes(data);
      document.loadSchema.value=data.substring(0,i+1);
      document.loadSTS.value = data.substring(i+2, data.length);   
    }
    else if ((i=data.indexOf('.')) >= 0) 
    {
      data = removeQuotes(data);
      document.forms[0].loadSchema.value = data.substring(0,i);
      document.forms[0].loadSTS.value = data.substring(i+1, data.length);
    } else if ((i=data.indexOf(',')) >= 0)
    {
	    data = removeQuotes(data);
	    data = removeCommas(data);
	    document.forms[0].loadCursor.value=data;
    }else if ((i=data.indexOf('"')) >= 0)
    {
	    data = removeQuotes(data);
	    document.forms[0].loadCursor.value=data;
    }
  }
  
  function removeCommas(data){
  	var i =0;
	  if ((i=data.indexOf(',')) >= 0)
	  {
		  return removeCommas(data.substring(0,i)+'\n'+data.substring(i+2, data.length));
	  }
	  else
	  {
		  return data;
	  }
  }
  
  function removeQuotes(data){
	  if ((i=data.indexOf('"')) >= 0)
	  {
	  	return removeQuotes(data.substring(0,i)+data.substring(i+1, data.length));
  	  }
	  else {
	  	return data;
  	  }
  }
</script> 
      <db:form name="foo"  method="post"
               destinationBinding="dsqlPlanManagement"
               copyParams="target,type">

      <uix:formValue name="backPage" valueBinding="backPage@servletRequest" />
      <uix:formValue name="pageName" value="/database/instance/sqlplan/load" />
      <uix:pageLayout  titleBinding="OPM_TITLE@sqlMsg">
        <%@ include file="/database/global.jspf" %>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>

		<uix:header textBinding="LOAD_HEADER@sqlMsg" >
        <uix:tableLayout width="100%">
	  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="LOAD_INSTR@sqlMsg"/>
  </uix:cellFormat>
  </uix:rowLayout>
			<uix:rowLayout>
				<uix:cellFormat hAlign="left" wrappingDisabled="true" >
        <uix:tableLayout width="40%" cellSpacing="10">
			<uix:rowLayout>
				<uix:cellFormat hAlign="left" wrappingDisabled="true" >
            		<uix:radioButton name="loadOption"
                               textBinding="LOAD_STS@sqlMsg"
                               shortDescBinding="LOAD_STS@sqlMsg"
                               value="STS"
                               selected="true"  />
				</uix:cellFormat>
			</uix:rowLayout>

			<uix:rowLayout>
				<uix:cellFormat hAlign="right" wrappingDisabled="true">
					<uix:flowLayout>
						<uix:messagePrompt promptBinding="STS@sqlMsg"/>
            			<uix:textInput name="loadSchema" columns="15" onFocus="this.blur();"/>
            			<uix:styledText styleClass="OraDataText" id="sqlProfile"  text="."/>
            			<uix:lovField name="loadSTS" columns="15" onFocus="this.blur();"
            				onClick="useCallBack();setSearchFilter('loadSchema');startLov('loadSTS', 'ListSTS');return false" />
					</uix:flowLayout>
				</uix:cellFormat>
			</uix:rowLayout>
	
			<uix:rowLayout>
				<uix:cellFormat hAlign="left" wrappingDisabled="true" >
            		<uix:radioButton name="loadOption"
                               textBinding="LOAD_CURSOR@sqlMsg"
                               value="CURSOR"
                               shortDescBinding="LOAD_CURSOR@sqlMsg"  />
				</uix:cellFormat>
			</uix:rowLayout>

			<uix:rowLayout>
				<uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
					<uix:flowLayout >
						<uix:messagePrompt promptBinding="SQL_ID@sqlMsg"/>
            			<uix:lovField name="loadCursor" destination="" rows="5" columns="33" onFocus="this.blur();"
            			onClick="useCallBack();selectMultiple();startLov('loadCursor', 'ListSQLID');return false" />
					</uix:flowLayout>
				</uix:cellFormat>
			</uix:rowLayout>
	</uix:tableLayout >
				</uix:cellFormat>
			</uix:rowLayout>
	</uix:tableLayout >
</uix:header>
	<%@ include file="/database/instance/simpleSchedule.jspf" %> 
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@dbMsg"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@dbMsg"
                              name="event"
                              value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

