<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<db:script src="/database/LOV.js"/>
<script language="javascript">
  function lovCallBack(data){
    if ((i=data.indexOf('.')) >= 0) 
    {
      document.forms[0].sname.value = data.substring(0,i);
      document.forms[0].tname.value = data.substring(i+1, data.length);
    }
  }
</script> 
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" 
               destinationBinding="sqlPlanManagement"
               copyParams="target,type">

      <uix:formValue name="backPage" valueBinding="backPage@servletRequest" />
      <uix:formValue name="pageName" value="/database/instance/sqlplan/packPage" />
      <uix:formValue name="action" valueBinding="action@servletRequest" />
      <uix:pageLayout  titleBinding="OPM_TITLE@sqlMsg">
        <%@ include file="/database/global.jspf" %>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
        

      <uix:formValue name="labelName" valueBinding="labelName@servletRequest" />
      <uix:formValue name="selectedList" valueBinding="selectedList@servletRequest" />
      <uix:formValue name="tabName" valueBinding="tabName@servletRequest" />
      <uix:formValue name="showCategory" valueBinding="showCategoryText@servletRequest" />
      <uix:header textBinding="actionHeaderText@servletRequest">
        <uix:tableLayout width="100%">
	  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="actionInstrText@servletRequest"/>
  </uix:cellFormat>
  </uix:rowLayout>
<uix:rowLayout>
	<uix:cellFormat hAlign="center">
        <uix:tableLayout width="50%" cellSpacing="10">
	<uix:rowLayout renderedBinding="normalView@sqlPlanBean@servletRequest">
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="labelName@servletRequest"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="selectedList@servletRequest"/>
	</uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout renderedBinding="showPackPlanTable@sqlPlanBean@servletRequest">
	<uix:cellFormat columnSpan="2">
       <uix:table name="plnBaseline"
            width="100%"
            tableDataBinding="selectedPlanSqlIDTable@sqlPlanBean@servletRequest"
            formSubmitted="true"
            showAll="yes"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@sqlMsg"
          >
                 <uix:tableFormat tableBanding="rowBanding"/>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_SQL_HANDLE@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="SQL_ID"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="PLAN_NAME@sqlMsg"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="NAME"/>
               </uix:contents>
           </uix:column>
          </uix:table>
	</uix:cellFormat>
	</uix:rowLayout>
	<%--
	<uix:rowLayout>
	<uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="SCHEMA_NAME@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
          <uix:textInput id="sname" name="sname"
	  textBinding="schemaName@servletRequest" />
	</uix:cellFormat>
	</uix:rowLayout>
	--%>
	<uix:rowLayout>
	<uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="TABLE_NAME@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
		<uix:flowLayout>
   			<uix:textInput name="sname" columns="15"/>
            <uix:styledText styleClass="OraDataText" id="sqlProfile"  text="."/>
            <uix:lovField name="tname" columns="15" 
            	onClick="useCallBack();setSearchFilter('sname');startLov('tname', 'ListSchemaTable');return false" />
		</uix:flowLayout>
	<%--
          <uix:textInput id="tname" name="tname" 
	  textBinding="tname@servletRequest" />
	 <uix:messageLovField name="tname" 
	 textBinding="tname@servletRequest"
	 tipBinding="TABLE_NAME_TIP@sqlMsg"
	 onClick="startLov('tname','ListSchemaTable')" />
	 --%>
	</uix:cellFormat>
	</uix:rowLayout>
	<uix:rowLayout renderedBinding="showCategory@servletRequest">
	<uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_CATEGORY@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
          <uix:messageTextInput id="category" name="category" 
	  textBinding="category@servletRequest" 
	  tipBinding="CATEGORY_TIP@sqlMsg" />
	</uix:cellFormat>
	</uix:rowLayout>
	<uix:rowLayout renderedBinding="isNewStgTable@servletRequest">
	<uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="nameInput" prompt=""  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
		<uix:checkBox name="isNewTable" id="isNewTable" value="TRUE" 
			shortDescBinding="IS_NEW_STAGING_TABLE@sqlMsg"
			textBinding="IS_NEW_STAGING_TABLE@sqlMsg" />
	</uix:cellFormat>
	</uix:rowLayout>
	</uix:tableLayout >
	</uix:cellFormat>
	</uix:rowLayout>
	</uix:tableLayout >
</uix:header>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@dbMsg"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@dbMsg"
                              name="event"
                              value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

