<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="bundle"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:document>
<%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL"
        name="plnBaselineForm" 
        method="post"
        destination="sqlPlanManagement">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/sqlplan/plnBaseline"/>

        <uix:pageLayout
          titleBinding="OPM_TITLE@bundle"
          >

          <%@ include file="/database/global.jspf" %>
          
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>

          <uix:subTabLayout>

            <%-------------------------
             -  Subtabs
             ---------------------------%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="2">
                <uix:contents>

                <uix:link textBinding="OPM_PROFILE_TAB@bundle"
                   onClick="submitForm('plnBaselineForm', true, {event:'sqlProfileTab'})"/>

                <uix:link textBinding="OPM_PATCH_TAB@bundle"
                   onClick="submitForm('plnBaselineForm', true, {event:'sqlPatchTab'})"/>

                <uix:link textBinding="OPM_PLN_BASELINE_TAB@bundle"
                   />
                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

  <uix:messageBox message="" textBinding="MIGRATE_STORED_OUTLINES@bundle" messageType="info"
                  renderedBinding="displayMigrate@migrateEntryPointPageBean@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:rowLayout>
          <uix:styledText styleClass="OraInstructionText"
            textBinding="entryPageStoredOutlineText@migrateEntryPointPageBean@servletRequest" />
          <uix:spacer width="10" />
          <uix:button textBinding="MIGRATE_ENTRY_TEXT@bundle" 
                destinationBinding="storedOutlinesUrl@servletRequest" 
                disabledBinding="migrateButtonDisabled@migrateEntryPointPageBean@servletRequest"/>
          <uix:spacer width="5"/>
          <uix:messageStyledText 
            tipBinding="MIGRATE_PRIV_TEXT@bundle"
            renderedBinding="migrateButtonDisabled@migrateEntryPointPageBean@servletRequest" />
        </uix:rowLayout>
        <uix:spacer height="10" />
        <uix:styledText styleClass="OraInstructionTextStrong" textBinding="STORED_OUTLINES_INSTR_TEXT@bundle" />
      </uix:stackLayout>
    </uix:contents>
  </uix:messageBox>

<uix:spacer height="10" />
 
<uix:tableLayout width="100%" cellSpacing="5">
  <uix:rowLayout>
  <uix:cellFormat hAlign="right">
<uix:submitButton textBinding="REFRESH@bundle" name="event" value="refresh"/>
  </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="BASELINE_INSTR@bundle"/>
  </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout >

<%-- Settings & Jobs --%>
<uix:tableLayout cellSpacing="4" width="100%">
<uix:rowLayout>
<uix:cellFormat vAlign="top" width="50%" wrappingDisabled="false">
<uix:header textBinding="SETTING_HEADER@bundle">
<uix:tableLayout cellSpacing="4" >
  <uix:rowLayout>
    <uix:flowLayout>
  <uix:styledText labeledNodeId="plnBaseline" styleClass="OraPromptText" textBinding="CAPTURE_PLN_BSLN@bundle" />
  <uix:spacer width="5" />
  <uix:link textBinding="captureValue@servletRequest" destinationBinding="captureBaseline@servletRequest" />
    </uix:flowLayout>
  </uix:rowLayout>          
  <uix:rowLayout>
    <uix:flowLayout>
  <uix:styledText labeledNodeId="plnBaseline" styleClass="OraPromptText" textBinding="USE_PLN_BSLN@bundle" />
  <uix:spacer width="5" />
  <uix:link textBinding="useValue@servletRequest" destinationBinding="useBaseline@servletRequest" />
    </uix:flowLayout>
  </uix:rowLayout>          
  <uix:rowLayout>
    <uix:flowLayout>
  <uix:styledText labeledNodeId="planRetention" styleClass="OraPromptText" textBinding="PLAN_RETENTION@bundle" />
  <uix:spacer width="5" />
  <uix:textInput name="configRetention" textBinding="planRetention@sqlPlanBean@servletRequest" columns="5" shortDescBinding="PLAN_RETENTION_TIP@bundle" >
             <uix:onBlurValidater>
               <uix:decimal/>
           </uix:onBlurValidater>
  </uix:textInput>

  <uix:spacer width="5" />
  <uix:submitButton textBinding="CONFIG@bundle" name="event" value="configRetention"/>       
    </uix:flowLayout>
  </uix:rowLayout>          
</uix:tableLayout>  
</uix:header>
</uix:cellFormat>
<uix:cellFormat vAlign="top" width="50%" wrappingDisabled="false">
    <uix:contentContainer background="light" rendered="true" textBinding="CONTEXT_HEADER@bundle"  shortDescBinding="CONTEXT_HEADER@bundle" width="90%">
        <uix:tableLayout rendered="true" width="100%" cellSpacing="5">
            <uix:rowLayout>
                <uix:cellFormat width="20%">
                    <uix:messageStyledText styleClass="OraHeaderSubSub" text=""/>
                </uix:cellFormat>
                <uix:cellFormat width="40%">
                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="PENDING_CONTEXT@bundle"/>
                </uix:cellFormat>
                <uix:cellFormat width="40%">
                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="COMPLETED_CONTEXT@bundle"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
                <uix:cellFormat width="20%">
                <uix:messageStyledText styleClass="OraHeaderSubSub" textBinding="LOAD_JOBS@bundle"/>
                </uix:cellFormat>
                <uix:cellFormat width="40%">
                <uix:include nodeBinding="loadPendingJobs@sqlPlanBean@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="40%">
                <uix:include nodeBinding="loadCompletedJobs@sqlPlanBean@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>
    </uix:contentContainer>
</uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>


<uix:header textBinding="OPM_SEARCH@bundle">
<uix:tableLayout cellSpacing="4" >
  <uix:rowLayout>
    <uix:flowLayout>
      <uix:styledText labeledNodeId="plnBaseline" styleClass="OraPromptText"
        textBinding="OPM_SEARCH_NAME@bundle" />

      <uix:textInput name="searchPlnBaseline" id="searchPlnBaseline"  textBinding="searchPlnBaseline@sqlPlanBean@servletRequest" />

        <uix:submitButton textBinding="OPM_GO@bundle" name="event" value="searchPlnBaseline"/>       

    </uix:flowLayout>
  </uix:rowLayout>          
  <uix:rowLayout>
    <uix:styledText styleClass="OraInlineInfoText"
            textBinding="OPM_SEARCH_TIP@bundle"/>
  </uix:rowLayout>          
</uix:tableLayout>  
</uix:header>



<uix:tableLayout cellSpacing="1" width="100%">
<uix:rowLayout>
<uix:cellFormat hAlign="right">
<uix:submitButton textBinding="LOAD@bundle" name="event" value="load" />
<uix:submitButton textBinding="OPM_UNPACK@bundle" name="event" value="unpack" />
</uix:cellFormat>
</uix:rowLayout>
<uix:rowLayout>
<uix:cellFormat>
       <uix:table name="plnBaseline"
            width="100%"
	    blockSize="25"
            tableDataBinding="plnBaselineTable@sqlPlanBean@servletRequest"
            formSubmitted="true"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@bundle"
	   valueBinding="plnBaselineStartIdx@sqlPlanBean@servletRequest"
	    maxValueBinding="maxPlnBaseline@sqlPlanBean@servletRequest">
                 <uix:tableFormat tableBanding="rowBanding"/>
                 
           <uix:column>
                 <uix:columnHeader>
                 <uix:sortableHeader textBinding="PLAN_NAME@bundle" sortableBinding="nameBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <%--
                   <uix:styledText styleClass="OraText" textBinding="PLAN_NAME"/>
				--%>
	       	    <uix:link textBinding="PLAN_NAME"
    				destinationBinding="PLAN_DEST" 
				/>
		   <uix:formValue name="planName" valueBinding="PLAN_NAME"/>
		   		<uix:formValue name="sqlID" valueBinding="NAME"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
                 <uix:sortableHeader textBinding="OPM_SQL_TEXT@bundle" sortableBinding="sqlTextBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
	       	    <uix:link textBinding="SHORT_SQL_TEXT" destinationBinding="DEST" />
		   		<uix:formValue name="SHORT_SQL_TEXT" valueBinding="SHORT_SQL_TEXT"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="ENABLED@bundle" sortableBinding="statusBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="STATUS"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_ACCEPTED@bundle" sortableBinding="acceptedBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="ACCEPTED"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_FIXED@bundle" sortableBinding="fixedBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="FIXED"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_AUTO_PURGE@bundle" sortableBinding="autoPurgeBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="AUTO_PURGE"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_CREATED@bundle" sortableBinding="createdBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="CREATED_STR"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_MODIFIED@bundle" sortableBinding="modifiedBaselineSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText"
		   textBinding="MODIFIED_STR"/>
               </uix:contents>
           </uix:column>
	   
	   <uix:tableSelection>
		<uix:multipleSelection selectedBinding="select" shortDescBinding="SELECTED@bundle">
			<uix:submitButton textBinding="OPM_ENABLE@bundle" name="event" value="enable" />
			<uix:submitButton textBinding="OPM_DISABLE@bundle" name="event" value="disable" />
			<uix:submitButton textBinding="OPM_DROP@bundle" name="event" value="purge" />
			<uix:submitButton textBinding="EVOLVE@bundle" name="event" value="evolve" />
			<uix:submitButton textBinding="OPM_PACK@bundle"	name="event" value="pack" />
			<uix:choice name="plnBaselinechoice">
			<uix:option textBinding="FIX@bundle" value="fix" />
			<uix:option textBinding="UNFIX@bundle" value="unfix" />
			<uix:option textBinding="AUTO_PURGE@bundle" value="apurge" />
			<uix:option textBinding="NO_AUTO_PURGE@bundle" value="noapurge" />
			</uix:choice>
			<uix:submitButton textBinding="OPM_GO@bundle" name="event" value="go" />
		</uix:multipleSelection>
	   </uix:tableSelection>
       </uix:table>
</uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>
<uix:tip shortDescBinding="MAX_TABLE_ROWS_TIP@bundle" textBinding="MAX_TABLE_ROWS_TIP@bundle"/>
          </uix:subTabLayout>


        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
