<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" 
               destinationBinding="dsqlPlanManagement"
               copyParams="target,type">

      <uix:formValue name="backPage" valueBinding="backURL@servletRequest" />
      <uix:formValue name="pageName" value="/database/instance/sqlplan/showdetails" />
      <uix:pageLayout  titleBinding="OPM_TITLE@sqlMsg">
        <%@ include file="/database/global.jspf" %>
		<uix:header textBinding="headerText@servletRequest" >
        <uix:tableLayout width="100%" renderedBinding="isProfile@servletRequest">
  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="SHOW_DETAILS_INSTR@bundle"/>
  </uix:cellFormat>
  </uix:rowLayout>
	<uix:rowLayout>
	<uix:cellFormat hAlign="center">
        <uix:tableLayout width="60%" cellSpacing="10">
	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_NAME@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	    <uix:contents childDataBinding="showDetails@servletRequest">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="NAME"/>
	</uix:contents>
	</uix:cellFormat>
	</uix:rowLayout>
	
	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true" vAlign="top">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_SQL_TEXT@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	    <uix:contents childDataBinding="showDetails@servletRequest">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="SQL_TEXT"/>
	</uix:contents>
	</uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_CATEGORY@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	    <uix:contents childDataBinding="showDetails@servletRequest">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="CATEGORY"/>
	</uix:contents>
	</uix:cellFormat>
	</uix:rowLayout>
	
	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_STATUS@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	    <uix:contents childDataBinding="showDetails@servletRequest">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="STATUS"/>
	</uix:contents>
	</uix:cellFormat>
	</uix:rowLayout>
	
	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_CREATED@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	    <uix:contents childDataBinding="showDetails@servletRequest">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="CREATED"/>
	</uix:contents>
	</uix:cellFormat>
	</uix:rowLayout>
	
	<uix:rowLayout>
	<uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="nameInput"
                               promptBinding="OPM_MODIFIED@sqlMsg"  />
	</uix:cellFormat>
	<uix:cellFormat hAlign="left">
	    <uix:contents childDataBinding="showDetails@servletRequest">
	  <uix:styledText styleClass="OraDataText" id="sqlProfile"
	  textBinding="MODIFIED"/>
	</uix:contents>
	</uix:cellFormat>
	</uix:rowLayout>
	
	</uix:tableLayout >
	</uix:cellFormat>
	</uix:rowLayout>
	</uix:tableLayout >
	
        <uix:tableLayout width="100%" renderedBinding="isBaseline@servletRequest">
	<uix:rowLayout>
	<uix:rawText betweenText="<BR>" preText="<PRE>" postText="</PRE>" >
	<uix:contents childDataBinding="planDetails@servletRequest">
	<uix:formattedText  textBinding="viewPlan"/>
	</uix:contents>
	</uix:rawText>
                   <%--
               <uix:table name="sqlProfile"
            width="100%"
            tableDataBinding="planDetails@servletRequest"
            formSubmitted="true"
            showAll="yes"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@bundle"
          >

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText text="Plan Details"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="viewPlan"/>
               </uix:contents>
           </uix:column>
       </uix:table>
       --%>
	</uix:rowLayout>
		</uix:tableLayout>
</uix:header>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="DIAG_RETURN@sqlMsg"
                              name="event"
                              value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

