<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="bundle"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL"
        name="sqlPatchForm" 
        method="post"
        destination="sqlPlanManagement">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/sqlplan/sqlPatch"/>

        <uix:pageLayout
          titleBinding="OPM_TITLE@bundle"
          >

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>

          <uix:subTabLayout>

            <%-------------------------
             -  Subtabs
             ---------------------------%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:contents>

                <uix:link textBinding="OPM_PROFILE_TAB@bundle"
                   onClick="submitForm('sqlPatchForm', true, {event:'sqlProfileTab'})"/>

                <uix:link textBinding="OPM_PATCH_TAB@bundle"/>

                <uix:link textBinding="OPM_PLN_BASELINE_TAB@bundle"
                   onClick="submitForm('sqlPatchForm', true, {event:'plnBaselineTab'})"/>
                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

<uix:tableLayout width="100%" cellSpacing="5">
  <uix:rowLayout>
  <uix:cellFormat hAlign="right">
<uix:submitButton textBinding="REFRESH@bundle" name="event" value="refresh"/>
  </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout>
  <uix:cellFormat hAlign="left">
<uix:styledText labeledNodeId="plnBaseline" styleClass="OraInstructionText" textBinding="PATCH_INSTR@bundle"/>
  </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout >


<uix:header textBinding="OPM_SEARCH@bundle">
<uix:tableLayout cellSpacing="4" >
  <uix:rowLayout>
    <uix:flowLayout>
      <uix:styledText labeledNodeId="patch" styleClass="OraPromptText"
        textBinding="OPM_SEARCH_NAME@bundle" />

      <uix:textInput name="searchPatch" id="searchPatch"  textBinding="searchPatch@sqlPlanBean@servletRequest" />

        <uix:submitButton textBinding="OPM_GO@bundle" name="event" value="searchPatch"/>

    </uix:flowLayout>
  </uix:rowLayout>          
  <uix:rowLayout>
    <uix:styledText styleClass="OraInlineInfoText"
            textBinding="OPM_SEARCH_TIP@bundle"  />
  </uix:rowLayout>          
</uix:tableLayout>  
</uix:header>


<uix:tableLayout cellSpacing="1" width="100%">
<uix:rowLayout>
<uix:cellFormat hAlign="right">
<%--
<uix:submitButton textBinding="OPM_UNPACK@bundle" name="event" value="unpack" />
--%>
</uix:cellFormat>
</uix:rowLayout>
<uix:rowLayout>
<uix:cellFormat>
       <uix:table name="sqlPatch"
            width="100%"
            blockSize="25"
            tableDataBinding="sqlPatchTable@sqlPlanBean@servletRequest"
            formSubmitted="true"
           valueBinding="patchStartIdx@sqlPlanBean@servletRequest" 
           maxValueBinding="maxPatch@sqlPlanBean@servletRequest"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@bundle"
          >
                 <uix:tableFormat tableBanding="rowBanding"/>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_NAME@bundle"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="NAME"/>
		   <uix:formValue name="sqlID" valueBinding="NAME"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="OPM_SQL_TEXT@bundle"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:link textBinding="SHORT_SQL_TEXT" destinationBinding="DEST" />
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_CATEGORY@bundle" sortableBinding="categoryPatchSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="CATEGORY"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_STATUS@bundle" sortableBinding="statusPatchSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="STATUS"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_CREATED@bundle" sortableBinding="createdPatchSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="CREATED"/>
               </uix:contents>
           </uix:column>

           <uix:column>
                 <uix:columnHeader>
			<uix:sortableHeader textBinding="OPM_MODIFIED@bundle" sortableBinding="modifiedPatchSortable@sqlPlanBean@servletRequest"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="MODIFIED"/>
               </uix:contents>
           </uix:column>	   
	   <uix:tableSelection>
		<uix:multipleSelection selectedBinding="select" shortDescBinding="SELECTED@bundle">
			<uix:submitButton textBinding="OPM_ENABLE@bundle" name="event" value="enable" />
			<uix:submitButton textBinding="OPM_DISABLE@bundle" name="event" value="disable" />
			<uix:submitButton textBinding="OPM_DROP@bundle" name="event" value="drop" />
			<uix:submitButton textBinding="OPM_CHANGE_CATEGORY@bundle" name="event" value="changeCategory" />
			<%--
			<uix:submitButton textBinding="OPM_PACK@bundle"	name="event" value="pack" />
			--%>
		</uix:multipleSelection>
	   </uix:tableSelection>
       </uix:table>
</uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>
<uix:tip shortDescBinding="MAX_TABLE_ROWS_TIP@bundle" textBinding="MAX_TABLE_ROWS_TIP@bundle"/>

          </uix:subTabLayout>


        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
