<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="bundle"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL"
        name="sqlProfileForm" 
        method="post"
        destination="sqlPlanManagement">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/sqlplan/viewPlan"/>

        <uix:pageLayout
          titleBinding="OPM_TITLE@bundle"
          >

          <%@ include file="/database/global.jspf" %>

       <uix:table name="sqlProfile"
            width="100%"
            tableDataBinding="planDetails@servletRequest"
            formSubmitted="true"
            showAll="yes"
           alternateTextBinding="OPM_ITEMS_NOT_FOUND@bundle"
          >

           <uix:column>
                 <uix:columnHeader>
                   <uix:styledText textBinding="PLAN_DETAILS@bundle"/>
               </uix:columnHeader>
               <uix:contents>
                   <uix:styledText styleClass="OraText" textBinding="viewPlan"/>
               </uix:contents>
           </uix:column>
       </uix:table>
           
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="DIAG_RETURN@bundle" name="event" value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>
