<%--
  -- Page:        sqlsets.jsp
  -- Controller:  oracle.sysman.db.adm.inst.SqlSetController.java
  --
  -- Description:  Summary page for list of SQL Tuning Sets
  --
  --  MODIFIED    (MM/DD/YY)
  --     yma     02/14/07 - bug 5761069 
  --     yfeng   12/05/06 - Fix ADA issue by adding oemNoscript.jspf
  --     yfeng   11/29/06 - Add vertical spaces between buttons and the table 
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    <%@ include file="/sdk/page/pageMsgBox.jspf" %>

    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="confirmation"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <db:form name="foo" method="POST" destination="/console/database/instance/sqlSet"
      copyParams="target,type">

    <uix:header textBinding="SQL_TUNING_SETS@DBMsgBundle@servletRequest">
    <%@ include file="/database/instances.jspf" %>

    <%@ include file="../refreshTime.jspf" %>

    <uix:messagePrompt promptBinding="STS_INSTR@DBMsgBundle@servletRequest"/>

    <uix:rowLayout>
      <uix:spacer height="10" />
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:messageTextInput name="searchName"
           promptBinding="SEARCH@DBMsgBundle@servletRequest"
           textBinding="searchName@sqlsetCollectionBean@servletRequest"
           tipBinding="FILTER_ON_NAME@DBMsgBundle@servletRequest" >
        <uix:end>
          <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest" name="event" value="search"/>
        </uix:end>
      </uix:messageTextInput>
    </uix:rowLayout>



      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CREATE@DBMsgBundle@servletRequest"
                              name="event" value="create" />
            <uix:submitButton textBinding="IMPORT@DBMsgBundle@servletRequest"
                              name="event" value="importSTS" />   
          </uix:pageButtonBar>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="2" />
      </uix:rowLayout>
    
       <uix:tableLayout width="100%" >
          <uix:rowLayout vAlign="top">

            <oem:table name="sqlSetUIDataSource"
                       partialRenderMode="self"
                       alternateTextBinding="NO_STS_ALT@DBMsgBundle@servletRequest"
                       id="sqlsetTable"
                       width="100%"
                       dataSourceProp="sqlSetUIDataSource"
                       beanKey="sqlsetCollectionBean"
                       formSubmitted="true"
                       summaryBinding="SQL_TUNING_SETS@DBMsgBundle@servletRequest"
                       blockSize="25">

              <uix:tableSelection >
                <oem:singleSelection
                  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                  selectedIndex="0" >

                <uix:pageButtonBar>
                  <uix:submitButton textBinding="DETAILS@DBMsgBundle@servletRequest"
                     name="event" value="viewSTS"/>
                  <uix:submitButton textBinding="DROP@DBMsgBundle@servletRequest"
                    name="event" value="deleteSTS" />
                  <uix:submitButton textBinding="EXPORT@DBMsgBundle@servletRequest"
                    name="event" value="exportSTS" />
                  <uix:submitButton textBinding="RUN_TUNING_ADVISOR@DBMsgBundle@servletRequest"
                     name="event" value="runTuningAdvisor" />
                  <uix:submitButton textBinding="SCHEDULE_ACCESS_ADVISOR@DBMsgBundle@servletRequest"
                     name="event" value="runAccessAdvisor" />
                </uix:pageButtonBar>

                </oem:singleSelection>
              </uix:tableSelection>
            </oem:table>


          </uix:rowLayout>
        </uix:tableLayout>

        <uix:switcher childNameBinding="version11gOrHigher@sqlsetCollectionBean@servletRequest">
          <uix:case name="true">
      
            <uix:rowLayout>
              <uix:spacer height="20"/>
            </uix:rowLayout>
        
            <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
              <uix:tableLayout width="100%" cellSpacing="2">
                <uix:rowLayout>
                  <uix:stackLayout>
                    <uix:link textBinding="SPIA@SPIAMsgBundle@servletRequest"
                              destinationBinding="sqlReplay@servletRequest" />
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
          </uix:case>
        </uix:switcher>


    </uix:header>


    </db:form>
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

