<%--
  -- Page:        stsCreateFilterOptions.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsCreateController.java
  --
  -- Description: 3rd step of SQL Tuning Set creation wizard: Filter Options
  --
  --  MODIFIED    (MM/DD/YY)t
  --     yfeng   03/27/07 - Fix 5893748 - Delete condition failed
  --                        Change the form name to be foo
  --     yfeng   12/05/06 - Fix ADA issue
  --     yfeng   11/21/06 - Remove the desciption on the page
  --     yfeng   10/12/06 - Reduce number of columns for TextInput that accepts
  --                        numbers
  --     yfeng   05/19/06 - Do not show top N for incremental capture 
  --     yfeng   05/16/06 - Add filter condition 
  --     yfeng   04/11/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:document>

  <%-- HTML Page Title --%>
  <%@ include file="/oemTitle.jspf" %>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="foo" 
             method="post" 
             destination="/console/database/instance/stsCreate" 
             copyParams="target,type,backURL" >
      <uix:formValue name="pageName" 
                     value="/database/instance/sqlset/stsCreateFilterOptions"/>                   


<uix:pageLayout titleBinding="STS_CREATE_FILTER_OPTIONS_TITLE@sqlMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

  <%-- Display wizard train and Logged in As --%>
  <uix:location>
    <uix:tableLayout width="100%">
      <uix:rowLayout width="100%">
        <uix:cellFormat wrappingDisabled="true">
          <uix:train selectedIndex="2">
            <db:link textBinding="OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="LOAD_METHODS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="FILTER_OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="SCHEDULE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="REVIEW@sqlMsg"
                     copyParams="target,type,backURL" />
          </uix:train>
        </uix:cellFormat>
        <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
          <uix:messageStyledText styleClass="OraTipText" 
                                 textBinding="loggedInAsLabel@servletRequest"
                                 renderedBinding="loggedInUserNameAvailable@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:location>

  <uix:pageStatus>
    <uix:rowLayout width="100%">
      <uix:stackLayout> 
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:messagePrompt
               promptBinding="DATABASE@dbMsg"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="target@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:pageStatus>
  
  <%-- Follow page/wizard context information with a separator --%>
  <uix:separator/>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:header textBinding="TOTAL_NUMBER_SQL@sqlMsg"
              renderedBinding="captureOnce@searchSource@servletRequest">
    <uix:stackLayout>
      <uix:flowLayout>
<%--
        <uix:rowLayout>
          <uix:styledText textBinding="TOTAL_NUMBER_SQL_DESC@sqlMsg"  
                          styleClass="OraInstructionText"/>
        </uix:rowLayout>
        <uix:spacer height="5"/>
--%>
        
        <uix:tableLayout>
          <uix:contents>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:spacer height ="0" width="38"/> 
                <uix:messagePrompt labeledNodeId="topN" 
                                   promptBinding="TOP_N@sqlMsg" />
              </uix:cellFormat>  
              <uix:cellFormat hAlign="right">
                <uix:spacer width="5" />
                <uix:textInput id="topN" name="topN"
                               columns="16"
                               textBinding="topN@filterCondition@servletRequest" />
              </uix:cellFormat> 
        
              <uix:cellFormat hAlign="right">
                <uix:spacer height ="0" width="38"/> 
                <uix:messagePrompt labeledNodeId="selectedSortedBy" 
                                   promptBinding="SORTED_BY@sqlMsg" />
              </uix:cellFormat>  
              <uix:cellFormat hAlign="right">
                <uix:spacer width="5" />
                <uix:choice id="selectedSortedBy" 
                            name="selectedSortedBy"
                            selectedValueBinding="selectedSortedBy@filterCondition@servletRequest"                                
                            shortDescBinding="SORTED_BY@sqlMsg">
                  <uix:contents childDataBinding="sortedByList@filterCondition@servletRequest">
                    <uix:option textBinding="stext"
                                valueBinding="sval"/>
          </uix:contents>
        </uix:choice>   
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:contents>
        </uix:tableLayout>
      
      </uix:flowLayout>
    </uix:stackLayout>   
  </uix:header>
 <%--
  <uix:header textBinding="FILTER_CONDITIONS@sqlMsg">
    <uix:stackLayout>
      <uix:flowLayout>
        <uix:rowLayout>
          <uix:styledText textBinding="FILTER_CONDITION_DESC@sqlMsg"  
                          styleClass="OraInstructionText"/>
        </uix:rowLayout>
        <uix:spacer height="5"/>
 --%>       
        <%@ include file="/database/instance/filterConditions.jspf" %>
      <%--
      </uix:flowLayout>
    </uix:stackLayout>   
  </uix:header>
  --%>
  <uix:pageButtons>  
    <uix:pageButtonBar>
      <uix:submitButton textBinding="FINISH@dbMsg"
                        shortDescBinding="FINISH@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "finish" />
      <uix:submitButton textBinding="CANCEL@dbMsg"
                        shortDescBinding="CANCEL@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "cancel" />
      <uix:navigationBar maxValue="5" minValue="1" name="step" value="3" 
                         destination="/console/database/instance/stsCreate" 
                         formSubmitted="true"
                         formName="foo"/>
    </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
