<%--
  -- Page:        stsCreateOptions.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsCreateController.java
  --
  -- Description: 2nd step of SQL Tuning Set creation wizard: Load Methods
  --
  --  MODIFIED    (MM/DD/YY)t
  --     yfeng   07/08/06 - Launch Time Picker 
  --     yfeng   05/22/06 - include stsDataSources.jspf 
  --     yfeng   05/15/06 - Use instance of StsDataSources for data binding 
  --     yfeng   04/10/06 - Add LOV for baseline and fix javascript error 
  --     yfeng   04/04/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function launchTimePeriodPicker()
{
    if (document.stsCreate.awrSnapshotIntervalChoice.value == "S_CUSTOMIZE")
        submitForm('stsCreate', true, {'event':'changeDataSource'});
        alert(document.stsCreate.awrSnapshotIntervalChoice.value);
}

function launchTimePickerPage(url, winName) 
{
  timePickerWin = openWindow(window, url, winName, {width:1000, height:600}, true, 'dialog', '');
  timePickerWin.focus();
}

function popWindow()
{
  startLov('baseline', 'ListBaselines');
}
</script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<uix:document>

  <%-- HTML Page Title --%>
  <%@ include file="/oemTitle.jspf" %>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="stsCreate" 
             method="post" 
             destination="/console/database/instance/stsCreate" 
             copyParams="target,type,backURL" >
      <uix:formValue name="pageName" 
                     value="/database/instance/sqlset/stsCreateLoadMethods"/>
      <uix:formValue name="dbid" 
                     valueBinding="dbid@stsCreateBean@servletRequest"/>       
      <uix:formValue name="schemaName" 
                     valueBinding="loggedInUserName@stsCreateBean@servletRequest" />


<uix:pageLayout titleBinding="STS_CREATE_LOAD_METHODS_TITLE@sqlMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

  <%-- Display wizard train and Logged in As --%>
  <uix:location>
    <uix:tableLayout width="100%">
      <uix:rowLayout width="100%">
        <uix:cellFormat wrappingDisabled="true">
          <uix:train selectedIndex="1">
            <db:link textBinding="OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="LOAD_METHODS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="FILTER_OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="SCHEDULE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="REVIEW@sqlMsg"
                     copyParams="target,type,backURL" />
          </uix:train>
        </uix:cellFormat>
        <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
          <uix:messageStyledText styleClass="OraTipText" 
                                 textBinding="loggedInAsLabel@servletRequest"
                                 renderedBinding="loggedInUserNameAvailable@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:location>

  <uix:pageStatus>
    <uix:rowLayout width="100%">
      <uix:stackLayout> 
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:messagePrompt
               promptBinding="DATABASE@dbMsg"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="target@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:pageStatus>
  
  <%-- Follow page/wizard context information with a separator --%>
  <uix:separator/>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%@ include file="stsDataSources.jspf" %>

  <uix:pageButtons>  
    <uix:pageButtonBar>
      <uix:submitButton textBinding="FINISH@dbMsg"
                        shortDescBinding="FINISH@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "finish" />
      <uix:submitButton textBinding="CANCEL@dbMsg"
                        shortDescBinding="CANCEL@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "cancel" />
      <uix:navigationBar maxValue="5" minValue="1" name="step" value="2" 
                         destination="/console/database/instance/stsCreate" 
                         formSubmitted="true"
                         formName="stsCreate"/>
    </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
