<%--
  -- Page:        stsCreateOptions.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsCreateController.java
  --
  -- Description: 1st step of SQL Tuning Set creation wizard: Options
  --
  --  MODIFIED    (MM/DD/YY)t
  --     yfeng   12/05/06 - Fix ADA issues
  --     yfeng   04/10/06 - Change the name of LOV field 
  --     yfeng   04/04/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function popWindow()
{
  startLov('owner', 'ListSchema');
}
</script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:document>

  <%-- HTML Page Title --%>
  <%@ include file="/oemTitle.jspf" %>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="stsCreate" 
             method="post" 
             destination="/console/database/instance/stsCreate" 
             copyParams="target,type,backURL" >
      <uix:formValue name="pageName" 
                     value="/database/instance/sqlset/stsCreateOptions"/>


<uix:pageLayout titleBinding="STS_CREATE_OPTIONS_TITLE@sqlMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

  <%-- Display wizard train and Logged in As --%>
  <uix:location>
    <uix:tableLayout width="100%">
      <uix:rowLayout width="100%">
        <uix:cellFormat wrappingDisabled="true">
          <uix:train selectedIndex="0">
            <db:link textBinding="OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="LOAD_METHODS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="FILTER_OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="SCHEDULE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="REVIEW@sqlMsg"
                     copyParams="target,type,backURL" />
          </uix:train>
        </uix:cellFormat>
        <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
          <uix:messageStyledText styleClass="OraTipText" 
                                 textBinding="loggedInAsLabel@servletRequest"
                                 renderedBinding="loggedInUserNameAvailable@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:location>

  <uix:pageStatus>
    <uix:rowLayout width="100%">
      <uix:stackLayout> 
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:messagePrompt
               promptBinding="DATABASE@dbMsg"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="target@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:pageStatus>
  
  <%-- Follow page/wizard context information with a separator --%>
  <uix:separator/>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
                         <%--     
  <uix:stackLayout>
    <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
--%>

              <uix:tableLayout cellSpacing="5">

<uix:rowLayout>
  
      <uix:cellFormat wrappingDisabled="true" hAlign="right">
        <uix:messagePrompt labeledNodeId="stsName"
                           promptBinding="STS_NAME@sqlMsg"
                           required="yes"  />
      </uix:cellFormat>
      <uix:textInput name="stsName" id="stsName"
                     columns="40"
                     textBinding="stsName@stsCreateBean@servletRequest"/>
</uix:rowLayout>

<uix:rowLayout>
      <uix:cellFormat hAlign="right"> 
        <uix:messagePrompt labeledNodeId="owner"
                        styleClass="OraPromptText" 
                        promptBinding ="OWNER@dbMsg"/>
        </uix:cellFormat>
        <uix:messageLovField name="owner"
                             id="owner"
                             textBinding="owner@stsCreateBean@servletRequest"
                             columns="40"
                             searchDescBinding="OWNER@dbMsg"
                             onClick="startLov('owner', 'ListSchema');return false;"/>
          <uix:messageText messageBinding="owner@errors@servletRequest"
                           messageType="error"/>
       </uix:rowLayout>   
                     
                     <uix:rowLayout>  
      <uix:cellFormat wrappingDisabled="true" hAlign="right">
        <uix:messagePrompt labeledNodeId="description" 
                           promptBinding="DESCRIPTION@dbMsg" />
      </uix:cellFormat>
         <uix:textInput name="description" id="description"
                        columns="40"
                        textBinding="description@stsCreateBean@servletRequest"  />
          </uix:rowLayout>  
        </uix:tableLayout>
      
      <uix:tableLayout width="100%" cellSpacing="2">
        <uix:rowLayout>
        
          <uix:checkBox name="emptySts" 
                        textBinding="CREATE_EMPTY_STS@sqlMsg"  
                        checkedBinding="emptySts@stsCreateBean@servletRequest"
                        renderedBinding="allowEmtpySts@stsCreateBean@servletRequest"/>

        </uix:rowLayout>
      </uix:tableLayout>

          <%--
    </uix:labeledFieldLayout>   
  </uix:stackLayout>
  --%>

  <uix:pageButtons>  
    <uix:pageButtonBar>
      <uix:submitButton textBinding="CANCEL@dbMsg"
                        shortDescBinding="CANCEL@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "cancel" />
      <uix:navigationBar maxValue="5" minValue="1" name="step" value="1" 
                         destination="/console/database/instance/stsCreate" 
                         formSubmitted="true"
                         formName="stsCreate"/>
    </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
