<%--
  -- Page:        stsCreateSchedule.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsCreateController.java
  --
  -- Description: 4th step of SQL Tuning Set creation wizard: Schedule
  --
  --  MODIFIED    (MM/DD/YY)t
  --     yfeng   07/14/06 - Used simpleSchedule.jspf because of name conflict 
  --     yfeng   04/11/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:document>

  <%-- HTML Page Title --%>
  <%@ include file="/oemTitle.jspf" %>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="stsCreate" 
             method="post" 
             destination="/console/database/instance/stsCreate" 
             copyParams="target,type,backURL" >
      <uix:formValue name="pageName" 
                     value="/database/instance/sqlset/stsCreateSchedule"/>                   


<uix:pageLayout titleBinding="STS_CREATE_SCHEDULE_TITLE@sqlMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

  <%-- Display wizard train and Logged in As --%>
  <uix:location>
    <uix:tableLayout width="100%">
      <uix:rowLayout width="100%">
        <uix:cellFormat wrappingDisabled="true">
          <uix:train selectedIndex="3">
            <db:link textBinding="OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="LOAD_METHODS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="FILTER_OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="SCHEDULE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="REVIEW@sqlMsg"
                     copyParams="target,type,backURL" />
          </uix:train>
        </uix:cellFormat>
        <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
          <uix:messageStyledText styleClass="OraTipText" 
                                 textBinding="loggedInAsLabel@servletRequest"
                                 renderedBinding="loggedInUserNameAvailable@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:location>

  <uix:pageStatus>
    <uix:rowLayout width="100%">
      <uix:stackLayout> 
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:messagePrompt
               promptBinding="DATABASE@dbMsg"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="target@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:pageStatus>
  
  <%-- Follow page/wizard context information with a separator --%>
  <uix:separator/>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:stackLayout>
      <uix:flowLayout>
        <uix:rowLayout>
          <uix:spacer width="5"/>
          <uix:styledText textBinding="STS_CREATE_SCHEDULE_DESC@sqlMsg"  
                          styleClass="OraInstructionText"/>
        </uix:rowLayout>
        <uix:spacer height="5"/>
      </uix:flowLayout>
    </uix:stackLayout>   
    
  <%@ include file="/database/instance/simpleSchedule.jspf" %>
 
  <uix:pageButtons>  
    <uix:pageButtonBar>
      <uix:submitButton textBinding="FINISH@dbMsg"
                        shortDescBinding="FINISH@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "finish" />
      <uix:submitButton textBinding="CANCEL@dbMsg"
                        shortDescBinding="CANCEL@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "cancel" />
      <uix:navigationBar maxValue="5" minValue="1" name="step" value="4" 
                         destination="/console/database/instance/stsCreate" 
                         formSubmitted="true"
                         formName="stsCreate"/>
    </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
