<%--
  -- Page:        stsExport.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsExportController.java
  --
  -- Description: Export SQL Tuning Set page
  --
  --  MODIFIED    (MM/DD/YY)
  --     yfeng   12/06/06 - Fix ADA issues
  --     yfeng   07/14/06 - Used simpleSchedule.jspf because of name conflict 
  --     yfeng   04/25/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="dbobjMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
            
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="stsExport" method="POST" destination="/console/database/instance/stsExport"
      copyParams="target,type,backURL">
    <uix:formValue name="pageName" value="/database/instance/sqlset/stsExport" />

    <uix:pageLayout titleBinding="EXPORT_STS@sqlMsg">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:stackLayout>
  
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="STS_NAME@sqlMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
                        textBinding="stsName@stsExportBean@servletRequest" />
        
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="OWNER@dbMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
                        textBinding="stsOwner@stsExportBean@servletRequest" />
                      
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="directoryObject"
                             promptBinding="DIRECTORY_OBJECT@sqlMsg"
                             required="yes"  />
        </uix:cellFormat>
        <oem:choice name="directoryObject" 
                    id="directoryObject"
                    shortDescBinding="START_TIME@SDKBundle@servletRequest"
                    optionsBinding="directoryObjectList@stsExportBean@servletRequest" 
                    onChange="submitForm(\'stsExport\', true, {\'event\':\'changeDirectoryObject\'});return false;"
                    selectedValueBinding="directoryObject@stsExportBean@servletRequest" />
      <%--               
        <uix:choice id="directoryObject" 
                    name="directoryObject"
                    onChange="submitForm(\'stsExport\', true, {\'event\':\'changeDirectoryObject\'});return false;"
                    selectedValueBinding="directoryObject@stsExportBean@servletRequest"                                
                    shortDescBinding="DIRECTORY_OBJECT@sqlMsg">
          <uix:contents childDataBinding="directoryObjectList@stsExportBean@servletRequest">
            <uix:option textBinding="stext"
                        valueBinding="sval"/>
          </uix:contents>
        </uix:choice> 
      --%>
            
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DIRECTORY_NAME@sqlMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
                        textBinding="directoryName@stsExportBean@servletRequest" />        
        
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="exportFileName"
                             promptBinding="EXPORT_FILE@sqlMsg"
                             required="yes"  />
        </uix:cellFormat>
         <uix:textInput name="exportFileName" id="exportFileName"
                        textBinding="exportFileName@stsExportBean@servletRequest" />
            
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="logFileName"
                             promptBinding="LOG_FILE@sqlMsg" />
        </uix:cellFormat>
         <uix:textInput name="logFileName" id="logFileName"
                        textBinding="logFileName@stsExportBean@servletRequest" />
     </uix:labeledFieldLayout>

<%--
      <oem:table name="statementTable"
                 dataSourceBinding="stmtTableUI@servletRequest"
                 summaryBinding="SQL_STATEMENTS@DBMsgBundle@servletRequest"
                 width="80%" >

      </oem:table>
      --%> 
      <uix:spacer height="5"/>
      <uix:rowLayout>
        <uix:styledText textBinding="EXPORT_STS_DESC@sqlMsg"  
                        styleClass="OraInstructionText"/>
      </uix:rowLayout>
      <uix:spacer height="5"/>
      <oem:table name="tablespaceUIDataSource"
                 partialRenderMode="self"
                 id="tablespaceTable"
                 width="60%"
                 dataSourceProp="tablespaceUIDataSource"
                 beanKey="stsExportBean"
                 formSubmitted="true"
                 summaryBinding="TABLESPACE_LIST@sqlMsg"
                 blockSize="5">
      
        <uix:tableSelection >
          <oem:singleSelection
            shortDescBinding="SELECT@dbobjMsg"
            selectedIndexBinding="selectedIndex@tablespaceUIDataSource@stsExportBean@servletRequest" >
          </oem:singleSelection>
        </uix:tableSelection>
      </oem:table>

      <uix:spacer height="12"/>          
  <%@ include file="/database/instance/simpleSchedule.jspf" %>
  
    </uix:stackLayout>
     
      <uix:pageButtons>
      <uix:pageButtonBar>

          <uix:submitButton textBinding="CANCEL@dbMsg"
            name="event"
            value="cancel" />
          <uix:submitButton textBinding="OK@dbMsg"
            name="event"
            value="ok"/>

      </uix:pageButtonBar>
      </uix:pageButtons>



    </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

