<%--
  -- Page:        stsImport.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsImportController.java
  --
  -- Description: Import SQL Tuning Set page
  --
  --  MODIFIED    (MM/DD/YY)
  --     yfeng   12/06/06 - Fix ADA issues
  --     yfeng   07/14/06 - Used simpleSchedule.jspf because of name conflict 
  --     yfeng   05/25/06 - Fix the title 
  --     yfeng   04/25/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="dbobjMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
            
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="stsImport" method="POST" destination="/console/database/instance/stsImport"
      copyParams="target,type,backURL">
    <uix:formValue name="pageName" value="/database/instance/sqlset/stsImport" />

    <uix:pageLayout titleBinding="IMPORT_STS@sqlMsg">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:stackLayout>
  
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="directoryObject"
                             promptBinding="DIRECTORY_OBJECT@sqlMsg"
                             required="yes"  />
        </uix:cellFormat>
        <oem:choice name="directoryObject" 
                    id="directoryObject"
                    shortDescBinding="START_TIME@SDKBundle@servletRequest"
                    optionsBinding="directoryObjectList@stsImportBean@servletRequest" 
                    onChange="submitForm(\'stsImport\', true, {\'event\':\'changeDirectoryObject\'});return false;"
                    selectedValueBinding="directoryObject@stsImportBean@servletRequest" />
            
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DIRECTORY_NAME@sqlMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
                        textBinding="directoryName@stsImportBean@servletRequest" />        
        
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="importFileName"
                             promptBinding="IMPORT_FILE@sqlMsg"
                             required="yes"  />
        </uix:cellFormat>
         <uix:textInput name="importFileName" id="importFileName"
                        textBinding="importFileName@stsImportBean@servletRequest" />
            
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="logFileName"
                             promptBinding="LOG_FILE@sqlMsg" />
        </uix:cellFormat>
         <uix:textInput name="logFileName" id="logFileName"
                        textBinding="logFileName@stsImportBean@servletRequest" />
     </uix:labeledFieldLayout>

      <uix:tableLayout width="100%" cellSpacing="2">
        <uix:rowLayout>
        
          <uix:checkBox name="replaceSts" 
                        textBinding="REPLACE_EXISTING_STS@sqlMsg"  
                        checkedBinding="replaceSts@stsImportBean@servletRequest"/>
      
        </uix:rowLayout>
      </uix:tableLayout>
      
      <uix:spacer height="5"/>
      <uix:rowLayout>
        <uix:styledText textBinding="IMPORT_STS_DESC@sqlMsg"  
                        styleClass="OraInstructionText"/>
      </uix:rowLayout>
      <uix:spacer height="5"/>
      <oem:table name="tablespaceUIDataSource"
                 partialRenderMode="self"
                 id="tablespaceTable"
                 width="60%"
                 dataSourceProp="tablespaceUIDataSource"
                 beanKey="stsImportBean"
                 formSubmitted="true"
                 summaryBinding="TABLESPACE_LIST@sqlMsg"
                 blockSize="5">
      
        <uix:tableSelection >
          <oem:singleSelection
            shortDescBinding="SELECT@dbobjMsg"
            selectedIndexBinding="selectedIndex@tablespaceUIDataSource@stsImportBean@servletRequest" >
          </oem:singleSelection>
        </uix:tableSelection>
      </oem:table>

      <uix:spacer height="12"/>          
  <%@ include file="/database/instance/simpleSchedule.jspf" %>
  
    </uix:stackLayout>
     
      <uix:pageButtons>
      <uix:pageButtonBar>

          <uix:submitButton textBinding="CANCEL@dbMsg"
            name="event"
            value="cancel" />
          <uix:submitButton textBinding="OK@dbMsg"
            name="event"
            value="ok"/>

      </uix:pageButtonBar>
      </uix:pageButtons>



    </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

